package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ServerView extends ServerView {

    private final Metadata metadata4;
    private final Metadata metadata5;
    private final Metadata metadata3;
    private final Metadata metadata7;
    private final Metadata metadata6;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata4Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/interface=*");
        this.metadata4 = mbuiContext.metadataRegistry().lookup(metadata4Template);
        AddressTemplate metadata5Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/jvm=*");
        this.metadata5 = mbuiContext.metadataRegistry().lookup(metadata5Template);
        AddressTemplate metadata3Template = AddressTemplate.of("/{selected.host}/{selected.server-config}");
        this.metadata3 = mbuiContext.metadataRegistry().lookup(metadata3Template);
        AddressTemplate metadata7Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/system-property=*");
        this.metadata7 = mbuiContext.metadataRegistry().lookup(metadata7Template);
        AddressTemplate metadata6Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/path=*");
        this.metadata6 = mbuiContext.metadataRegistry().lookup(metadata6Template);
        this.expressionElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata3)
            .includeRuntime()
            .include("name")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("host"), 1)
            .include("group")
            .include("auto-start")
            .include("update-auto-start-with-server-status")
            .include("socket-binding-group")
            .include("socket-binding-port-offset")
            .include("socket-binding-default-interface")
            .include("status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Configuration", metadata3Template.resolve(statementContext()), changedValues, metadata3))
            .prepareReset(form -> resetSingletonForm("Server Configuration", metadata3Template.resolve(statementContext()), form, metadata3))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-form", metadata4)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata4Template.resolve(statementContext(), name), changedValues, metadata4);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata4Template.resolve(statementContext(), name), form, metadata4);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-form", metadata5)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata5Template.resolve(statementContext(), name), changedValues, metadata5);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata5Template.resolve(statementContext(), name), form, metadata5);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-path-form", metadata6)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata6Template.resolve(statementContext(), name), changedValues, metadata6);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata6Template.resolve(statementContext(), name), form, metadata6);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-form", metadata7)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata7Template.resolve(statementContext(), name), changedValues, metadata7);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata7Template.resolve(statementContext(), name), form, metadata7);
            })
            .build();

        serverInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-table", metadata4)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-interface-table", Ids.ADD), "Interface",
                metadata4Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata4Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-table", metadata5)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-jvm-table", Ids.ADD), "JVM",
                metadata5Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata5Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-path-table", metadata6)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-path-table", Ids.ADD), "Path",
                metadata6Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata6Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-table", metadata7)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-system-property-table", Ids.ADD), "System Property",
                metadata7Template, asList("value"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata7Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html9;
        HTMLElement serverConfigurationItemElement = section()
            .add(html9 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>${metadata3.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverConfigurationForm)
                    .element();
        expressionElements.put("html9", html9);
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-settings", serverConfigurationItemElement);
        HTMLElement html11;
        HTMLElement serverInterfaceItemElement = section()
            .add(html11 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata4.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverInterfaceTable)
            .add(serverInterfaceForm)
                    .element();
        expressionElements.put("html11", html11);
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        HTMLElement html14;
        HTMLElement serverJvmItemElement = section()
            .add(html14 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata5.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverJvmTable)
            .add(serverJvmForm)
                    .element();
        expressionElements.put("html14", html14);
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        HTMLElement html17;
        HTMLElement serverPathItemElement = section()
            .add(html17 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata6.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverPathTable)
            .add(serverPathForm)
                    .element();
        expressionElements.put("html17", html17);
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        HTMLElement html20;
        HTMLElement serverSystemPropertyItemElement = section()
            .add(html20 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata7.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverSystemPropertyTable)
            .add(serverSystemPropertyForm)
                    .element();
        expressionElements.put("html20", html20);
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            serverInterfaceTable.bindForm(serverInterfaceForm);
            serverJvmTable.bindForm(serverJvmForm);
            serverPathTable.bindForm(serverPathForm);
            serverSystemPropertyTable.bindForm(serverSystemPropertyForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html9"), "${metadata3.getDescription().getDescription()}", String.valueOf(metadata3.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html11"), "${metadata4.getDescription().getDescription()}", String.valueOf(metadata4.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html14"), "${metadata5.getDescription().getDescription()}", String.valueOf(metadata5.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html17"), "${metadata6.getDescription().getDescription()}", String.valueOf(metadata6.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html20"), "${metadata7.getDescription().getDescription()}", String.valueOf(metadata7.getDescription().getDescription()));
    }
}
