package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_DestinationView extends DestinationView {

    private final Metadata metadata10;
    private final Metadata metadata9;
    private final Metadata metadata8;
    private final Metadata metadata11;
    private final Metadata metadata12;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_DestinationView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata10Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*");
        this.metadata10 = mbuiContext.metadataRegistry().lookup(metadata10Template);
        AddressTemplate metadata9Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*");
        this.metadata9 = mbuiContext.metadataRegistry().lookup(metadata9Template);
        AddressTemplate metadata8Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/queue=*");
        this.metadata8 = mbuiContext.metadataRegistry().lookup(metadata8Template);
        AddressTemplate metadata11Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*");
        this.metadata11 = mbuiContext.metadataRegistry().lookup(metadata11Template);
        AddressTemplate metadata12Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/divert=*");
        this.metadata12 = mbuiContext.metadataRegistry().lookup(metadata12Template);
        this.expressionElements = new HashMap<>();

        coreQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-core-queue-form", metadata8)
            .include("queue-address", "filter", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CORE_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CORE_QUEUE, form))
            .build();
        jmsQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-queue-form", metadata9)
            .include("selector", "entries", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JMS_QUEUE, form))
            .build();
        jmsTopicForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-topic-form", metadata10)
            .include("entries")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_TOPIC, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JMS_TOPIC, form))
            .build();
        addressSettingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-address-setting-form", metadata11)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ADDRESS_SETTING, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.ADDRESS_SETTING, form))
            .build();
        divertForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-divert-form", metadata12)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.DIVERT, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.DIVERT, form))
            .build();

        coreQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-core-queue-table", metadata8)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addCoreQueue(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CORE_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("queue-address")
            .build();
        jmsQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-queue-table", metadata9)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addJMSQueue(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JMS_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("selector")
            .build();
        jmsTopicTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-topic-table", metadata10)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.JMS_TOPIC), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JMS_TOPIC, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        addressSettingTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-address-setting-table", metadata11)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.ADDRESS_SETTING), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.ADDRESS_SETTING, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        divertTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-divert-table", metadata12)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.DIVERT), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/divert=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.DIVERT, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/divert=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html24;
        HTMLElement messagingCoreQueueItemElement = section()
            .add(html24 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Core Queue</h1><p>${metadata8.getDescription().getDescription()}</p>"))
                            .element())
            .add(coreQueueTable)
            .add(coreQueueForm)
                    .element();
        expressionElements.put("html24", html24);
        navigation.addPrimary("messaging-core-queue-item", "Core Queue", "fa fa-cog", messagingCoreQueueItemElement);
        HTMLElement html27;
        HTMLElement messagingJmsQueueItemElement = section()
            .add(html27 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Queue</h1><p>${metadata9.getDescription().getDescription()}</p>"))
                            .element())
            .add(jmsQueueTable)
            .add(jmsQueueForm)
                    .element();
        expressionElements.put("html27", html27);
        navigation.addPrimary("messaging-jms-queue-item", "JMS Queue", "fa fa-long-arrow-right", messagingJmsQueueItemElement);
        HTMLElement html30;
        HTMLElement messagingJmsTopicItemElement = section()
            .add(html30 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Topic</h1><p>${metadata10.getDescription().getDescription()}</p>"))
                            .element())
            .add(jmsTopicTable)
            .add(jmsTopicForm)
                    .element();
        expressionElements.put("html30", html30);
        navigation.addPrimary("messaging-jms-topic-item", "JMS Topic", "fa fa-arrows", messagingJmsTopicItemElement);
        HTMLElement html33;
        HTMLElement messagingAddressSettingItemElement = section()
            .add(html33 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Address Setting</h1><p>${metadata11.getDescription().getDescription()}</p>"))
                            .element())
            .add(addressSettingTable)
            .add(addressSettingForm)
                    .element();
        expressionElements.put("html33", html33);
        navigation.addPrimary("messaging-address-setting-item", "Address Setting", "fa fa-address-card-o", messagingAddressSettingItemElement);
        HTMLElement html36;
        HTMLElement messagingDivertItemElement = section()
            .add(html36 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Divert</h1><p>${metadata12.getDescription().getDescription()}</p>"))
                            .element())
            .add(divertTable)
            .add(divertForm)
                    .element();
        expressionElements.put("html36", html36);
        navigation.addPrimary("messaging-divert-item", "Divert", "fa fa-exchange", messagingDivertItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(coreQueueTable);
        registerAttachable(coreQueueForm);
        registerAttachable(jmsQueueTable);
        registerAttachable(jmsQueueForm);
        registerAttachable(jmsTopicTable);
        registerAttachable(jmsTopicForm);
        registerAttachable(addressSettingTable);
        registerAttachable(addressSettingForm);
        registerAttachable(divertTable);
        registerAttachable(divertForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            coreQueueTable.bindForm(coreQueueForm);
            jmsQueueTable.bindForm(jmsQueueForm);
            jmsTopicTable.bindForm(jmsTopicForm);
            addressSettingTable.bindForm(addressSettingForm);
            divertTable.bindForm(divertForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html24"), "${metadata8.getDescription().getDescription()}", String.valueOf(metadata8.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html27"), "${metadata9.getDescription().getDescription()}", String.valueOf(metadata9.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html30"), "${metadata10.getDescription().getDescription()}", String.valueOf(metadata10.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html33"), "${metadata11.getDescription().getDescription()}", String.valueOf(metadata11.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html36"), "${metadata12.getDescription().getDescription()}", String.valueOf(metadata12.getDescription().getDescription()));
    }
}
