package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ConnectionView extends ConnectionView {

    private final Metadata metadata89;
    private final Metadata metadata88;
    private final Metadata metadata86;
    private final Metadata metadata84;
    private final Metadata metadata81;
    private final Metadata metadata87;
    private final Metadata metadata85;
    private final Metadata metadata82;
    private final Metadata metadata83;
    private final Metadata metadata80;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ConnectionView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata89Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*");
        this.metadata89 = mbuiContext.metadataRegistry().lookup(metadata89Template);
        AddressTemplate metadata88Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*");
        this.metadata88 = mbuiContext.metadataRegistry().lookup(metadata88Template);
        AddressTemplate metadata86Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*");
        this.metadata86 = mbuiContext.metadataRegistry().lookup(metadata86Template);
        AddressTemplate metadata84Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector=*");
        this.metadata84 = mbuiContext.metadataRegistry().lookup(metadata84Template);
        AddressTemplate metadata81Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*");
        this.metadata81 = mbuiContext.metadataRegistry().lookup(metadata81Template);
        AddressTemplate metadata87Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*");
        this.metadata87 = mbuiContext.metadataRegistry().lookup(metadata87Template);
        AddressTemplate metadata85Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*");
        this.metadata85 = mbuiContext.metadataRegistry().lookup(metadata85Template);
        AddressTemplate metadata82Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*");
        this.metadata82 = mbuiContext.metadataRegistry().lookup(metadata82Template);
        AddressTemplate metadata83Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*");
        this.metadata83 = mbuiContext.metadataRegistry().lookup(metadata83Template);
        AddressTemplate metadata80Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*");
        this.metadata80 = mbuiContext.metadataRegistry().lookup(metadata80Template);
        this.expressionElements = new HashMap<>();

        acceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-acceptor-form", metadata80)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.ACCEPTOR, form))
            .build();
        acceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-acceptor-form", metadata81)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.IN_VM_ACCEPTOR, form))
            .build();
        httpAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-acceptor-form", metadata82)
            .include("http-listener", "upgrade-legacy", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.HTTP_ACCEPTOR, form))
            .build();
        httpAcceptorForm.getFormItem("http-listener").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=undertow/server=*/http-listener=*")));
        remoteAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-acceptor-form", metadata83)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.REMOTE_ACCEPTOR, form))
            .build();
        remoteAcceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-form", metadata84)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTOR, form))
            .build();
        connectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-connector-form", metadata85)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.IN_VM_CONNECTOR, form))
            .build();
        httpConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-connector-form", metadata86)
            .include("endpoint", "server-name", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.HTTP_CONNECTOR, form))
            .build();
        httpConnectorForm.getFormItem("endpoint").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*")));
        httpConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        remoteConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-connector-form", metadata87)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.REMOTE_CONNECTOR, form))
            .build();
        remoteConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorServiceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-service-form", metadata88)
            .include("factory-class", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR_SERVICE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTOR_SERVICE, form))
            .build();
        connectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connection-factory-form", metadata89)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTION_FACTORY, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTION_FACTORY, form))
            .build();

        acceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-acceptor-table", metadata80)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inVmAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-acceptor-table", metadata81)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.IN_VM_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.IN_VM_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        httpAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-acceptor-table", metadata82)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttp(ServerSubResource.HTTP_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.HTTP_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-acceptor-table", metadata83)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemote(ServerSubResource.REMOTE_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.REMOTE_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-table", metadata84)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inVmConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-connector-table", metadata85)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.IN_VM_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.IN_VM_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-connector-table", metadata86)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttpConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.HTTP_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-connector-table", metadata87)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemote(ServerSubResource.REMOTE_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.REMOTE_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorServiceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-service-table", metadata88)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTOR_SERVICE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTOR_SERVICE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectionFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connection-factory-table", metadata89)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTION_FACTORY), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTION_FACTORY, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("messaging-acceptor-group-item", "Acceptor", "fa fa-sign-in");
        HTMLElement html229;
        HTMLElement messagingAcceptorItemElement = section()
            .add(html229 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Acceptor</h1><p>${metadata80.getDescription().getDescription()}</p>"))
                                    .element())
            .add(acceptorTable)
            .add(acceptorForm)
                            .element();
        expressionElements.put("html229", html229);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-acceptor-item", "Generic", messagingAcceptorItemElement);
        HTMLElement html232;
        HTMLElement messagingInVmAcceptorItemElement = section()
            .add(html232 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Acceptor</h1><p>${metadata81.getDescription().getDescription()}</p>"))
                                    .element())
            .add(inVmAcceptorTable)
            .add(inVmAcceptorForm)
                            .element();
        expressionElements.put("html232", html232);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-in-vm-acceptor-item", "In VM", messagingInVmAcceptorItemElement);
        HTMLElement html235;
        HTMLElement messagingHttpAcceptorItemElement = section()
            .add(html235 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Acceptor</h1><p>${metadata82.getDescription().getDescription()}</p>"))
                                    .element())
            .add(httpAcceptorTable)
            .add(httpAcceptorForm)
                            .element();
        expressionElements.put("html235", html235);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-http-acceptor-item", "HTTP", messagingHttpAcceptorItemElement);
        HTMLElement html238;
        HTMLElement messagingRemoteAcceptorItemElement = section()
            .add(html238 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Acceptor</h1><p>${metadata83.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remoteAcceptorTable)
            .add(remoteAcceptorForm)
                            .element();
        expressionElements.put("html238", html238);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-remote-acceptor-item", "Remote", messagingRemoteAcceptorItemElement);
        navigation.addPrimary("messaging-connector-group-item", "Connector", "fa fa-link");
        HTMLElement html241;
        HTMLElement messagingConnectorItemElement = section()
            .add(html241 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Connector</h1><p>${metadata84.getDescription().getDescription()}</p>"))
                                    .element())
            .add(connectorTable)
            .add(connectorForm)
                            .element();
        expressionElements.put("html241", html241);
        navigation.addSecondary("messaging-connector-group-item", "messaging-connector-item", "Generic", messagingConnectorItemElement);
        HTMLElement html244;
        HTMLElement messagingInVmConnectorItemElement = section()
            .add(html244 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Connector</h1><p>${metadata85.getDescription().getDescription()}</p>"))
                                    .element())
            .add(inVmConnectorTable)
            .add(inVmConnectorForm)
                            .element();
        expressionElements.put("html244", html244);
        navigation.addSecondary("messaging-connector-group-item", "messaging-in-vm-connector-item", "In VM", messagingInVmConnectorItemElement);
        HTMLElement html247;
        HTMLElement messagingHttpConnectorItemElement = section()
            .add(html247 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata86.getDescription().getDescription()}</p>"))
                                    .element())
            .add(httpConnectorTable)
            .add(httpConnectorForm)
                            .element();
        expressionElements.put("html247", html247);
        navigation.addSecondary("messaging-connector-group-item", "messaging-http-connector-item", "HTTP", messagingHttpConnectorItemElement);
        HTMLElement html250;
        HTMLElement messagingRemoteConnectorItemElement = section()
            .add(html250 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Connector</h1><p>${metadata87.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remoteConnectorTable)
            .add(remoteConnectorForm)
                            .element();
        expressionElements.put("html250", html250);
        navigation.addSecondary("messaging-connector-group-item", "messaging-remote-connector-item", "Remote", messagingRemoteConnectorItemElement);
        HTMLElement html253;
        HTMLElement messagingConnectorServiceItemElement = section()
            .add(html253 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector Service</h1><p>${metadata88.getDescription().getDescription()}</p>"))
                            .element())
            .add(connectorServiceTable)
            .add(connectorServiceForm)
                    .element();
        expressionElements.put("html253", html253);
        navigation.addPrimary("messaging-connector-service-item", "Connector Service", "pficon pficon-service", messagingConnectorServiceItemElement);
        HTMLElement html256;
        HTMLElement messagingConnectionFactoryItemElement = section()
            .add(html256 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connection Factory</h1><p>${metadata89.getDescription().getDescription()}</p>"))
                            .element())
            .add(connectionFactoryTable)
            .add(connectionFactoryForm)
                    .element();
        expressionElements.put("html256", html256);
        navigation.addPrimary("messaging-connection-factory-item", "Connection Factory", "fa fa-cubes", messagingConnectionFactoryItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(acceptorTable);
        registerAttachable(acceptorForm);
        registerAttachable(inVmAcceptorTable);
        registerAttachable(inVmAcceptorForm);
        registerAttachable(httpAcceptorTable);
        registerAttachable(httpAcceptorForm);
        registerAttachable(remoteAcceptorTable);
        registerAttachable(remoteAcceptorForm);
        registerAttachable(connectorTable);
        registerAttachable(connectorForm);
        registerAttachable(inVmConnectorTable);
        registerAttachable(inVmConnectorForm);
        registerAttachable(httpConnectorTable);
        registerAttachable(httpConnectorForm);
        registerAttachable(remoteConnectorTable);
        registerAttachable(remoteConnectorForm);
        registerAttachable(connectorServiceTable);
        registerAttachable(connectorServiceForm);
        registerAttachable(connectionFactoryTable);
        registerAttachable(connectionFactoryForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            acceptorTable.bindForm(acceptorForm);
            inVmAcceptorTable.bindForm(inVmAcceptorForm);
            httpAcceptorTable.bindForm(httpAcceptorForm);
            remoteAcceptorTable.bindForm(remoteAcceptorForm);
            connectorTable.bindForm(connectorForm);
            inVmConnectorTable.bindForm(inVmConnectorForm);
            httpConnectorTable.bindForm(httpConnectorForm);
            remoteConnectorTable.bindForm(remoteConnectorForm);
            connectorServiceTable.bindForm(connectorServiceForm);
            connectionFactoryTable.bindForm(connectionFactoryForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html229"), "${metadata80.getDescription().getDescription()}", String.valueOf(metadata80.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html232"), "${metadata81.getDescription().getDescription()}", String.valueOf(metadata81.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html235"), "${metadata82.getDescription().getDescription()}", String.valueOf(metadata82.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html238"), "${metadata83.getDescription().getDescription()}", String.valueOf(metadata83.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html241"), "${metadata84.getDescription().getDescription()}", String.valueOf(metadata84.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html244"), "${metadata85.getDescription().getDescription()}", String.valueOf(metadata85.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html247"), "${metadata86.getDescription().getDescription()}", String.valueOf(metadata86.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html250"), "${metadata87.getDescription().getDescription()}", String.valueOf(metadata87.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html253"), "${metadata88.getDescription().getDescription()}", String.valueOf(metadata88.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html256"), "${metadata89.getDescription().getDescription()}", String.valueOf(metadata89.getDescription().getDescription()));
    }
}
