/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.DeploymentGroup;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentScanner
extends DeploymentGroup {
    private static final Logger log = Logger.getLogger(DeploymentScanner.class);
    private List<URL> urls;
    private List<String> resources;
    private List<String> multiple;
    private List<String> dirs;
    private List<String> filesByResource;

    public void setUrls(List<URL> urls) throws DeploymentException {
        this.urls = urls;
    }

    public void setResources(List<String> resources) throws DeploymentException, NullPointerException {
        this.resources = resources;
    }

    public void setMultipleResources(List<String> resources) throws DeploymentException, IOException {
        this.multiple = resources;
    }

    public void setDirectoriesByResource(List<String> resources) throws DeploymentException, IOException {
        this.dirs = resources;
    }

    public void setFilesByResource(List<String> filesByResource) {
        this.filesByResource = filesByResource;
    }

    public void start() throws Exception {
        try {
            if (this.urls != null) {
                this.addUrls(this.urls);
            }
            if (this.resources != null) {
                for (String resource : this.resources) {
                    this.addResource(resource);
                }
            }
            if (this.multiple != null) {
                for (String resource : this.multiple) {
                    this.addMultipleResources(resource);
                }
            }
            if (this.dirs != null) {
                for (String resource : this.dirs) {
                    this.addDirectoryByResource(resource, true);
                }
            }
            if (this.filesByResource != null) {
                for (String resource : this.filesByResource) {
                    this.addFileByResource(resource);
                }
            }
            this.mainDeployer.process();
        }
        catch (Exception ex) {
            log.error((Object)"Failed to deploy", (Throwable)ex);
            throw ex;
        }
    }

    public void stop() throws DeploymentException {
        this.undeploy();
    }
}

