/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.Controller;
import org.jboss.deployers.plugins.structure.AbstractDeploymentContext;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.IncompleteDeploymentException;
import org.jboss.deployers.spi.IncompleteDeployments;
import org.jboss.deployers.spi.IncompleteDeploymentsBuilder;
import org.jboss.deployers.spi.deployment.MainDeployer;
import org.jboss.embedded.DeploymentGroup;
import org.jboss.embedded.adapters.ServerConfig;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;

public class Bootstrap {
    private static final Logger log = Logger.getLogger(Bootstrap.class);
    public static final String BOOTSTRAP_RESOURCE_PATH = "jboss.embedded.bootstrap.resource.path";
    public static final String BOOTSTRAP_RESOURCE_FILE = "conf/bootstrap-beans.xml";
    protected Kernel kernel;
    protected ClassLoader loader = Thread.currentThread().getContextClassLoader();
    protected MainDeployer mainDeployer;
    protected boolean started;
    protected boolean ignoreShutdownErrors;
    private static Bootstrap instance;

    public static synchronized Bootstrap getInstance() {
        if (instance == null) {
            instance = new Bootstrap(Bootstrap.createKernel());
        }
        return instance;
    }

    public Bootstrap() {
        this.kernel = Bootstrap.createKernel();
    }

    public Bootstrap(Kernel kernel) {
        this.kernel = kernel;
    }

    public boolean isIgnoreShutdownErrors() {
        return this.ignoreShutdownErrors;
    }

    public void setIgnoreShutdownErrors(boolean ignoreShutdownErrors) {
        this.ignoreShutdownErrors = ignoreShutdownErrors;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    protected static Kernel createKernel() {
        BasicBootstrap bootstrap1 = new BasicBootstrap();
        bootstrap1.run();
        return bootstrap1.getKernel();
    }

    protected void checkIncomplete() throws DeploymentException {
        IncompleteDeployments incomplete = IncompleteDeploymentsBuilder.build((MainDeployer)this.mainDeployer, (Controller)this.kernel.getController());
        if (incomplete.isIncomplete()) {
            throw new IncompleteDeploymentException(incomplete);
        }
    }

    protected void deployBaseBootstrapUrl(URL url) throws Throwable {
        BeanXMLDeployer deployer = new BeanXMLDeployer(this.kernel);
        deployer.deploy(url);
    }

    protected void bootstrapURL(URL url) throws DeploymentException {
        try {
            ServerConfig config = new ServerConfig();
            AbstractBeanMetaData bmd = new AbstractBeanMetaData("ServerConfig", ServerConfig.class.getName());
            this.kernel.getController().install((BeanMetaData)bmd, (Object)config);
            this.deployBaseBootstrapUrl(url);
            this.mainDeployer = (MainDeployer)this.kernel.getRegistry().getEntry((Object)"MainDeployer").getTarget();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to bootstrap: ", throwable);
        }
        this.checkIncomplete();
        this.started = true;
    }

    public void bootstrap(String bootstrapResourcePath) throws DeploymentException {
        if (bootstrapResourcePath == null) {
            bootstrapResourcePath = "";
        } else if (!bootstrapResourcePath.equals("") && !bootstrapResourcePath.endsWith("/")) {
            bootstrapResourcePath = bootstrapResourcePath + "/";
        }
        System.setProperty(BOOTSTRAP_RESOURCE_PATH, bootstrapResourcePath);
        bootstrapResourcePath = bootstrapResourcePath + BOOTSTRAP_RESOURCE_FILE;
        URL url = this.loader.getResource(bootstrapResourcePath);
        if (url == null) {
            throw new DeploymentException("Unable to find bootstrap file: " + bootstrapResourcePath + " in classpath");
        }
        this.bootstrapURL(url);
    }

    public void bootstrap() throws DeploymentException {
        String path = System.getProperty(BOOTSTRAP_RESOURCE_PATH, "");
        this.bootstrap(path);
    }

    public void shutdown() {
        try {
            this.mainDeployer.shutdown();
        }
        catch (Exception e) {
            if (!this.ignoreShutdownErrors) {
                throw new RuntimeException(e);
            }
            log.error((Object)"Failed to shutdown Bootstrap", (Throwable)e);
        }
    }

    public void scanClasspath(String path) throws DeploymentException {
        DeploymentGroup group = this.createDeploymentGroup();
        group.addClasspath(path);
        group.process();
    }

    public void undeployClasspath(String path) throws DeploymentException {
        List<URL> paths = DeploymentGroup.getClassPaths(path);
        for (URL url : paths) {
            this.undeploy(url);
        }
    }

    public void deployResourceBase(String baseResource) throws DeploymentException {
        DeploymentGroup group = this.createDeploymentGroup();
        group.addResourceBase(baseResource);
        group.process();
    }

    public void deployResourceBases(String baseResource) throws DeploymentException {
        DeploymentGroup group = this.createDeploymentGroup();
        group.addResourceBases(baseResource);
        group.process();
    }

    public void deployResourceBase(Class baseResource) throws DeploymentException {
        DeploymentGroup group = this.createDeploymentGroup();
        group.addResourceBase(baseResource);
        group.process();
    }

    public void deploy(URL url) throws DeploymentException {
        DeploymentGroup group = this.createDeploymentGroup();
        group.add(url);
        group.process();
    }

    public void deploy(VirtualFile file) throws DeploymentException {
        DeploymentGroup group = this.createDeploymentGroup();
        group.add(file);
        group.process();
    }

    public void deployResource(String resource) throws DeploymentException {
        DeploymentGroup group = this.createDeploymentGroup();
        group.addResource(resource);
        group.process();
    }

    public void deployDirectory(URL url, boolean recurse) throws DeploymentException, IOException {
        DeploymentGroup group = this.createDeploymentGroup();
        group.addDirectory(url, recurse);
        group.process();
    }

    public void deployDirectoryFromResource(String resource, boolean recurse) throws DeploymentException, IOException {
        DeploymentGroup group = this.createDeploymentGroup();
        group.addDirectoryByResource(resource, recurse);
        group.process();
    }

    public void undeployResourceBase(String baseResource) throws DeploymentException {
        URL url;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.loader != null) {
            classLoader = this.loader;
        }
        if ((url = classLoader.getResource(baseResource)) == null) {
            throw new RuntimeException("Could not find baseResource: " + baseResource);
        }
        this.undeployResourceBase(url, baseResource);
    }

    private void undeployResourceBase(URL url, String baseResource) throws DeploymentException {
        String urlString = url.toString();
        int idx = urlString.lastIndexOf(baseResource);
        urlString = urlString.substring(0, idx);
        URL deployUrl = null;
        try {
            deployUrl = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.undeploy(deployUrl);
    }

    public void undeployResourceBases(String baseResource) throws DeploymentException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.loader != null) {
            classLoader = this.loader;
        }
        try {
            Enumeration<URL> urls = this.loader.getResources(baseResource);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                this.undeployResourceBase(url, baseResource);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void undeployResourceBase(Class baseResource) throws DeploymentException {
        String resource = baseResource.getName().replace('.', '/') + ".class";
        this.undeployResourceBase(resource);
    }

    public void undeployResource(String resource) throws DeploymentException {
        URL url;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.loader != null) {
            classLoader = this.loader;
        }
        if ((url = classLoader.getResource(resource)) == null) {
            throw new NullPointerException("Resource was null: " + resource);
        }
        this.undeploy(url);
    }

    public void undeploy(URL url) throws DeploymentException {
        VirtualFile vf = DeploymentGroup.getVirtualFile(url);
        this.undeploy(vf);
    }

    public void undeploy(VirtualFile vf) throws DeploymentException {
        String name = AbstractDeploymentContext.getDeploymentName((VirtualFile)vf);
        this.mainDeployer.removeDeploymentContext(name);
        this.mainDeployer.process();
    }

    public void undeployDirectory(URL url, boolean recurse) throws DeploymentException, IOException {
        List<VirtualFile> files = DeploymentGroup.getDeployerDirUrls(null, url, recurse);
        for (VirtualFile vf : files) {
            String name = AbstractDeploymentContext.getDeploymentName((VirtualFile)vf);
            this.mainDeployer.removeDeploymentContext(name);
        }
        this.mainDeployer.process();
    }

    public void undeployDirectoryFromResource(String resource, boolean recurse) throws DeploymentException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.loader != null) {
            classLoader = this.loader;
        }
        List<VirtualFile> files = DeploymentGroup.getDeployerDirUrlsFromResource(null, classLoader, resource, recurse);
        for (VirtualFile vf : files) {
            String name = AbstractDeploymentContext.getDeploymentName((VirtualFile)vf);
            this.mainDeployer.removeDeploymentContext(name);
        }
        this.mainDeployer.process();
    }

    public DeploymentGroup createDeploymentGroup() {
        DeploymentGroup group = new DeploymentGroup();
        group.setClassLoader(this.loader);
        group.setMainDeployer(this.mainDeployer);
        group.setKernel(this.kernel);
        return group;
    }

    public static void main(String[] args) throws Exception {
        Bootstrap.getInstance().bootstrap();
        for (String arg : args) {
            Bootstrap.getInstance().scanClasspath(arg);
        }
        System.out.println("Running...");
        Thread t = new Thread();
        t.setDaemon(false);
        t.start();
    }
}

