/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.net.InetAddress;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="JBAS")
interface ProcessLogger
extends BasicLogger {
    public static final ProcessLogger ROOT_LOGGER = (ProcessLogger)Logger.getMessageLogger(ProcessLogger.class, (String)ProcessLogger.class.getPackage().getName());
    public static final ProcessLogger CLIENT_LOGGER = (ProcessLogger)Logger.getMessageLogger(ProcessLogger.class, (String)"org.jboss.as.process-controller.client");
    public static final ProcessLogger SERVER_LOGGER = (ProcessLogger)Logger.getMessageLogger(ProcessLogger.class, (String)"org.jboss.as.process-controller.server");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12000, value="Attempted to reconnect non-existent process '%s'")
    public void attemptToReconnectNonExistentProcess(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12001, value="Attempted to remove non-existent process '%s'")
    public void attemptToRemoveNonExistentProcess(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12002, value="Attempted to start non-existent process '%s'")
    public void attemptToStartNonExistentProcess(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12003, value="Attempted to stop non-existent process '%s'")
    public void attemptToStopNonExistentProcess(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12004, value="Attempted to register duplicate named process '%s'")
    public void duplicateProcessName(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12005, value="Failed to send authentication key to process '%s': %s")
    public void failedToSendAuthKey(String var1, Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=12006, value="Failed to send data bytes to process '%s' input stream")
    public void failedToSendDataBytes(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=12007, value="Failed to send reconnect message to process '%s' input stream")
    public void failedToSendReconnect(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=12008, value="Failed to start process '%s'")
    public void failedToStartProcess(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=12009, value="Failed to write %s message to connection: %s")
    public void failedToWriteMessage(String var1, Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12010, value="Process '%s' finished with an exit status of %d")
    public void processFinished(String var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12011, value="Received connection with invalid version from %s")
    public void receivedInvalidVersion(InetAddress var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12012, value="Received unrecognized greeting code 0x%02x from %s")
    public void receivedUnknownGreetingCode(int var1, InetAddress var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12013, value="Received connection with unknown credentials from %s")
    public void receivedUnknownCredentials(InetAddress var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=120014, value="Received unknown message with code 0x%02x")
    public void receivedUnknownMessageCode(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12015, value="All processes finished; exiting")
    public void shutdownComplete();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12016, value="Shutting down process controller")
    public void shuttingDown();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12017, value="Starting process '%s'")
    public void startingProcess(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12018, value="Stopping process '%s'")
    public void stoppingProcess(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=12019, value="Stream processing failed for process '%s': %s")
    public void streamProcessingFailed(String var1, Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12020, value="Waiting %d seconds until trying to restart process %s.")
    public void waitingToRestart(int var1, String var2);
}

