/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.adm;

import java.io.OutputStream;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.jboss.aerogear.adm.TokenService;
import org.jboss.aerogear.adm.internal.Utilities;

public class AdmService {
    private final TokenService tokenService = new TokenService();
    private String accessToken;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String sendMessageToDevice(String registrationId, String clientId, String clientSecret, String payload) throws Exception {
        HttpsURLConnection conn;
        int responseCode;
        if (this.accessToken == null) {
            this.accessToken = this.tokenService.getAuthToken(clientId, clientSecret);
        }
        if ((responseCode = (conn = this.post(registrationId, payload)).getResponseCode()) != 200) {
            if (responseCode != 401) {
                String errorContent = Utilities.parseResponse(conn.getErrorStream());
                throw new RuntimeException(String.format("ERROR: The enqueue request failed with a %d response code, with the following message: %s", responseCode, errorContent));
            }
        } else {
            String responseContent = Utilities.parseResponse(conn.getInputStream());
            String canonicalRegistrationId = Utilities.getStringFromJson(responseContent, "registrationID");
            if (canonicalRegistrationId.equals(registrationId)) return registrationId;
            return canonicalRegistrationId;
        }
        this.accessToken = this.tokenService.getAuthToken(clientId, clientSecret);
        this.sendMessageToDevice(registrationId, clientId, clientSecret, payload);
        return registrationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpsURLConnection post(String registrationId, String payload) throws Exception {
        URL admUrl = new URL(String.format("https://api.amazon.com/messaging/registrations/%1$s/messages", registrationId));
        HttpsURLConnection conn = Utilities.getHttpsURLConnection(admUrl);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("content-type", "application/json");
        conn.setRequestProperty("accept", "application/json");
        conn.setRequestProperty("X-Amzn-Type-Version ", "com.amazon.device.messaging.ADMMessage@1.0");
        conn.setRequestProperty("X-Amzn-Accept-Type", "com.amazon.device.messaging.ADMSendResult@1.0");
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Authorization", "Bearer " + this.accessToken);
        OutputStream out = null;
        byte[] bytes = payload.getBytes(Utilities.UTF_8_CHARSET);
        try {
            out = conn.getOutputStream();
            out.write(bytes);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return conn;
    }
}

