/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.boot.redis;

import java.util.List;
import java.util.Objects;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.JaversBuilderPlugin;
import org.javers.core.JaversCoreProperties;
import org.javers.core.graph.ObjectAccessHook;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.redis.JaversRedisRepository;
import org.javers.spring.JaversSpringProperties;
import org.javers.spring.RegisterJsonTypeAdaptersPlugin;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;
import org.javers.spring.auditable.EmptyPropertiesProvider;
import org.javers.spring.auditable.MockAuthorProvider;
import org.javers.spring.auditable.SpringSecurityAuthorProvider;
import org.javers.spring.auditable.aspect.JaversAuditableAspect;
import org.javers.spring.auditable.aspect.springdata.JaversSpringDataAuditableRepositoryAspect;
import org.javers.spring.boot.redis.JaversTransactionalRedisDecorator;
import org.javers.spring.boot.redis.properties.JaversRedisProperties;
import org.javers.spring.boot.redis.properties.JedisPoolProperties;
import org.javers.spring.boot.redis.properties.SentinelPoolProperties;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.util.Pool;

@Configuration
@ConditionalOnProperty(prefix="javers.redis", name={"enabled"}, matchIfMissing=true)
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={JaversRedisProperties.class})
@Import(value={RegisterJsonTypeAdaptersPlugin.class})
public class JaversRedisAutoConfiguration {
    @Bean(destroyMethod="destroy")
    @ConditionalOnMissingBean
    Pool<Jedis> javersJedisPool(JaversRedisProperties javersRedisProperties) {
        if (Objects.nonNull(javersRedisProperties.getRedis().getSentinel())) {
            JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
            jedisPoolConfig.setJmxEnabled(false);
            SentinelPoolProperties sentinelPoolProps = javersRedisProperties.getRedis().getSentinel();
            return new JedisSentinelPool(sentinelPoolProps.getMasterName(), sentinelPoolProps.getSentinels(), (GenericObjectPoolConfig)jedisPoolConfig, sentinelPoolProps.getConnectionTimeout(), sentinelPoolProps.getSoTimeout(), sentinelPoolProps.getUser(), sentinelPoolProps.getPassword(), sentinelPoolProps.getDatabase(), sentinelPoolProps.getClientName(), sentinelPoolProps.getSentinelConnectionTimeout(), sentinelPoolProps.getSentinelSoTimeout(), sentinelPoolProps.getSentinelUser(), sentinelPoolProps.getSentinelPassword(), sentinelPoolProps.getSentinelClientName());
        }
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setJmxEnabled(false);
        JedisPoolProperties jedisPoolProps = javersRedisProperties.getRedis().getJedis();
        return new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, jedisPoolProps.getHost(), jedisPoolProps.getPort(), jedisPoolProps.getTimeout(), jedisPoolProps.getUser(), jedisPoolProps.getPassword(), jedisPoolProps.getDatabase(), jedisPoolProps.getClientName(), jedisPoolProps.isSsl());
    }

    @Bean(destroyMethod="shutdown")
    JaversRedisRepository javersRedisRepository(Pool<Jedis> javersJedisPool, JaversRedisProperties javersRedisProperties) {
        if (javersJedisPool instanceof JedisPool) {
            JedisPool jedisPool = (JedisPool)javersJedisPool;
            return new JaversRedisRepository(jedisPool, javersRedisProperties.getRedis().getAuditDuration());
        }
        if (javersJedisPool instanceof JedisSentinelPool) {
            JedisSentinelPool sentinelPool = (JedisSentinelPool)javersJedisPool;
            return new JaversRedisRepository(sentinelPool, javersRedisProperties.getRedis().getAuditDuration());
        }
        throw new BeanCreationException("Unsupported Javers Jedis Pool:" + javersJedisPool.getClass().getName());
    }

    @Bean
    @ConditionalOnMissingBean
    Javers javers(ApplicationContext ctx, JaversSpringProperties javersSpringProperties, JaversRedisRepository javersRedisRepository, List<JaversBuilderPlugin> plugins) {
        ObjectAccessHook objectAccessHook = javersSpringProperties.createObjectAccessHookInstance();
        JaversBuilder javersBuilder = JaversBuilder.javers().registerJaversRepository((JaversRepository)javersRedisRepository).withProperties((JaversCoreProperties)javersSpringProperties).withObjectAccessHook(objectAccessHook);
        plugins.forEach(plugin -> plugin.beforeAssemble(javersBuilder));
        Javers javers = javersBuilder.build();
        if (ctx.containsBean("platformTransactionManager")) {
            return new JaversTransactionalRedisDecorator(javers);
        }
        return javers;
    }

    @Bean(name={"springSecurityAuthorProvider"})
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.security.core.context.SecurityContextHolder"})
    AuthorProvider springSecurityAuthorProvider() {
        return new SpringSecurityAuthorProvider();
    }

    @Bean(name={"mockAuthorProvider"})
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.security.core.context.SecurityContextHolder"})
    AuthorProvider unknownAuthorProvider() {
        return new MockAuthorProvider();
    }

    @Bean(name={"emptyPropertiesProvider"})
    @ConditionalOnMissingBean
    CommitPropertiesProvider emptyPropertiesProvider() {
        return new EmptyPropertiesProvider();
    }

    @Bean
    @ConditionalOnProperty(name={"javers.auditableAspectEnabled"}, havingValue="true", matchIfMissing=true)
    JaversAuditableAspect javersAuditableAspect(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        return new JaversAuditableAspect(javers, authorProvider, commitPropertiesProvider);
    }

    @Bean
    @ConditionalOnProperty(name={"javers.springDataAuditableRepositoryAspectEnabled"}, havingValue="true", matchIfMissing=true)
    JaversSpringDataAuditableRepositoryAspect javersSpringDataAuditableAspect(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        return new JaversSpringDataAuditableRepositoryAspect(javers, authorProvider, commitPropertiesProvider);
    }
}

