/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.session;

import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.repository.sql.DialectName;
import org.javers.repository.sql.session.Dialect;
import org.javers.repository.sql.session.KeyGeneratorDefinition;
import org.javers.repository.sql.session.Parameter;
import org.javers.repository.sql.session.SelectBuilder;

class Dialects {
    Dialects() {
    }

    static Dialect fromName(DialectName dialectName) {
        if (DialectName.H2 == dialectName) {
            return new H2(dialectName);
        }
        if (DialectName.MYSQL == dialectName) {
            return new MysqlDialect(dialectName);
        }
        if (DialectName.POSTGRES == dialectName) {
            return new PostgresDialect(dialectName);
        }
        if (DialectName.ORACLE == dialectName) {
            return new OracleDialect(dialectName);
        }
        if (DialectName.MSSQL == dialectName) {
            return new MsSqlDialect(dialectName);
        }
        throw new JaversException(JaversExceptionCode.UNSUPPORTED_SQL_DIALECT, new Object[]{dialectName});
    }

    static class H2
    extends Dialect {
        H2(DialectName dialectName) {
            super(dialectName);
        }

        KeyGeneratorDefinition getKeyGeneratorDefinition() {
            return seqName -> "NEXT VALUE FOR " + seqName;
        }
    }

    static class MysqlDialect
    extends Dialect {
        MysqlDialect(DialectName dialectName) {
            super(dialectName);
        }

        KeyGeneratorDefinition getKeyGeneratorDefinition() {
            return () -> "select last_insert_id()";
        }
    }

    static class PostgresDialect
    extends Dialect {
        PostgresDialect(DialectName dialectName) {
            super(dialectName);
        }

        KeyGeneratorDefinition getKeyGeneratorDefinition() {
            return seqName -> "nextval('" + seqName + "')";
        }
    }

    static class OracleDialect
    extends Dialect {
        OracleDialect(DialectName dialectName) {
            super(dialectName);
        }

        KeyGeneratorDefinition getKeyGeneratorDefinition() {
            return new KeyGeneratorDefinition.SequenceDefinition(){

                @Override
                public String nextFromSequenceAsSQLExpression(String seqName) {
                    return seqName + ".nextval";
                }

                @Override
                public String nextFromSequenceAsSelect(String seqName) {
                    return "select " + seqName + ".nextval from dual";
                }
            };
        }

        @Override
        void limit(SelectBuilder query, long limit, long offset) {
            if (limit == 0L) {
                return;
            }
            if (offset == 0L) {
                query.wrap("SELECT a.*, rownum FROM (", ") a WHERE rownum <= ?", Parameter.longParam(limit));
            } else {
                long lowRownum = offset + 1L;
                long highRownum = offset + limit;
                query.wrap("select b.* from (SELECT a.*, rownum r__ FROM (", ") a WHERE rownum <= ? ) b where b.r__ >= ?", Parameter.longParam(highRownum), Parameter.longParam(lowRownum));
            }
        }
    }

    static class MsSqlDialect
    extends Dialect {
        MsSqlDialect(DialectName dialectName) {
            super(dialectName);
        }

        KeyGeneratorDefinition getKeyGeneratorDefinition() {
            return seqName -> "NEXT VALUE FOR " + seqName;
        }

        @Override
        void limit(SelectBuilder query, long limit, long offset) {
            if (limit == 0L) {
                return;
            }
            query.append("OFFSET ? ROWS FETCH NEXT ? ROWS ONLY", Parameter.longParam(offset), Parameter.longParam(limit));
        }
    }
}

