/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.session;

import org.javers.repository.sql.session.KeyGeneratorDefinition;
import org.javers.repository.sql.session.Select;
import org.javers.repository.sql.session.Session;
import org.polyjdbc.core.exception.SequenceLimitReachedException;

final class Sequence {
    private static final long SEQUENCE_ALLOCATION_SIZE = 100L;
    private final String sequenceName;
    private final KeyGeneratorDefinition.SequenceDefinition sequenceGenerator;
    private long currentValue;
    private long currentLimit = -1L;

    Sequence(String sequenceName, KeyGeneratorDefinition.SequenceDefinition sequenceGenerator) {
        this.sequenceName = sequenceName;
        this.sequenceGenerator = sequenceGenerator;
    }

    synchronized long nextValue(Session session) {
        if (this.recalculationNeeded()) {
            long currentSequenceValue = session.executeQueryForLong(new Select("SELECT next from seq " + this.sequenceName, "SELECT " + this.sequenceGenerator.nextFromSequenceAsSQLExpression(this.sequenceName)));
            this.recalculate(currentSequenceValue);
        }
        return this.nextLocalValue();
    }

    long nextLocalValue() {
        if (this.recalculationNeeded()) {
            throw new SequenceLimitReachedException("Sequence " + this.sequenceName + " has reached its limit of " + this.currentLimit + ". Before fetching value, check if recalculation is needed using recalculationNeeded() method.");
        }
        ++this.currentValue;
        return this.currentValue - 1L;
    }

    void recalculate(long currentSequenceValue) {
        this.currentValue = 100L * currentSequenceValue;
        this.currentLimit = 100L * (currentSequenceValue + 1L) - 1L;
    }

    boolean recalculationNeeded() {
        return this.currentValue > this.currentLimit;
    }
}

