/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.schema;

import java.io.Closeable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.javers.repository.sql.ConnectionProvider;
import org.javers.repository.sql.schema.DBObjectName;
import org.javers.repository.sql.schema.FixedSchemaFactory;
import org.javers.repository.sql.schema.SchemaNameAware;
import org.javers.repository.sql.schema.TableNameProvider;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.dialect.H2Dialect;
import org.polyjdbc.core.dialect.MsSqlDialect;
import org.polyjdbc.core.dialect.MysqlDialect;
import org.polyjdbc.core.dialect.OracleDialect;
import org.polyjdbc.core.dialect.PostgresDialect;
import org.polyjdbc.core.schema.SchemaInspector;
import org.polyjdbc.core.schema.SchemaManager;
import org.polyjdbc.core.schema.model.IndexBuilder;
import org.polyjdbc.core.schema.model.Schema;
import org.polyjdbc.core.util.TheCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversSchemaManager
extends SchemaNameAware {
    private static final Logger logger = LoggerFactory.getLogger(JaversSchemaManager.class);
    private SchemaInspector schemaInspector;
    private SchemaManager schemaManager;
    private final Dialect dialect;
    private final FixedSchemaFactory schemaFactory;
    private final PolyJDBC polyJDBC;
    private final ConnectionProvider connectionProvider;

    public JaversSchemaManager(Dialect dialect, FixedSchemaFactory schemaFactory, PolyJDBC polyJDBC, ConnectionProvider connectionProvider, TableNameProvider tableNameProvider) {
        super(tableNameProvider);
        this.dialect = dialect;
        this.schemaFactory = schemaFactory;
        this.polyJDBC = polyJDBC;
        this.connectionProvider = connectionProvider;
    }

    public void ensureSchema() {
        this.schemaInspector = this.polyJDBC.schemaInspector();
        this.schemaManager = this.polyJDBC.schemaManager();
        for (Map.Entry<String, Schema> e : this.schemaFactory.allTablesSchema(this.dialect).entrySet()) {
            this.ensureTable(e.getKey(), e.getValue());
        }
        this.alterCommitIdColumnIfNeeded();
        if (this.dialect instanceof MsSqlDialect) {
            this.alterMssqlTextColumns();
        }
        if (this.dialect instanceof MysqlDialect) {
            this.alterMySqlCommitDateColumn();
        }
        if (!(this.dialect instanceof H2Dialect)) {
            this.addDbIndexOnOwnerId();
        }
        TheCloser.close((Closeable[])new Closeable[]{this.schemaManager, this.schemaInspector});
    }

    private void alterMySqlCommitDateColumn() {
        ColumnType commitDateColType = this.getTypeOf(this.getCommitTableNameWithSchema(), "commit_date");
        if (commitDateColType.typeName.equals("TIMESTAMP") && commitDateColType.precision == 19) {
            logger.info("migrating db schema from JaVers 3.9.2 to 3.9.3 (MySql only) ...");
            this.executeSQL("ALTER TABLE " + this.getCommitTableNameWithSchema() + " MODIFY commit_date TIMESTAMP(3)");
        }
    }

    private void addDbIndexOnOwnerId() {
        this.addIndex(this.getGlobalIdTableName(), new FixedSchemaFactory.IndexedCols("owner_id_fk"));
    }

    private void alterCommitIdColumnIfNeeded() {
        ColumnType commitIdColType = this.getTypeOf(this.getCommitTableNameWithSchema(), "commit_id");
        if (commitIdColType.precision == 12) {
            logger.info("migrating db schema from JaVers 2.5 to 2.6 ...");
            if (this.dialect instanceof PostgresDialect) {
                this.executeSQL("ALTER TABLE " + this.getCommitTableNameWithSchema() + " ALTER COLUMN commit_id TYPE numeric(22,2)");
            } else if (this.dialect instanceof H2Dialect) {
                this.executeSQL("ALTER TABLE " + this.getCommitTableNameWithSchema() + " ALTER COLUMN commit_id numeric(22,2)");
            } else if (this.dialect instanceof MysqlDialect) {
                this.executeSQL("ALTER TABLE " + this.getCommitTableNameWithSchema() + " MODIFY commit_id numeric(22,2)");
            } else if (this.dialect instanceof OracleDialect) {
                this.executeSQL("ALTER TABLE " + this.getCommitTableNameWithSchema() + " MODIFY commit_id number(22,2)");
            } else if (this.dialect instanceof MsSqlDialect) {
                this.executeSQL("drop index jv_commit_commit_id_idx on " + this.getCommitTableNameWithSchema());
                this.executeSQL("ALTER TABLE " + this.getCommitTableNameWithSchema() + " ALTER COLUMN commit_id numeric(22,2)");
                this.executeSQL("CREATE INDEX jv_commit_commit_id_idx ON " + this.getCommitTableNameWithSchema() + " (commit_id)");
            } else {
                this.handleUnsupportedDialect();
            }
        }
    }

    private void alterMssqlTextColumns() {
        ColumnType stateColType = this.getTypeOf(this.getSnapshotTableNameWithSchema(), "state");
        ColumnType changedPropertiesColType = this.getTypeOf(this.getSnapshotTableNameWithSchema(), "state");
        if (stateColType.typeName.equals("text")) {
            this.executeSQL("ALTER TABLE " + this.getSnapshotTableNameWithSchema() + " ALTER COLUMN state VARCHAR(MAX)");
        }
        if (changedPropertiesColType.typeName.equals("text")) {
            this.executeSQL("ALTER TABLE " + this.getSnapshotTableNameWithSchema() + " ALTER COLUMN changed_properties VARCHAR(MAX)");
        }
    }

    private void handleUnsupportedDialect() {
        logger.error("\nno DB schema migration script for {} :(\nplease contact with JaVers team, javers@javers.org", (Object)this.dialect.getCode());
    }

    private boolean executeSQL(String sql) {
        try {
            Statement stmt = this.connectionProvider.getConnection().createStatement();
            logger.info("executing schema migration SQL:\n" + sql);
            boolean b = stmt.execute(sql);
            stmt.close();
            return b;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private int executeUpdate(String sql) {
        try {
            Statement stmt = this.connectionProvider.getConnection().createStatement();
            int cnt = stmt.executeUpdate(sql);
            stmt.close();
            return cnt;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private ColumnType getTypeOf(String tableName, String colName) {
        try {
            Statement stmt = this.connectionProvider.getConnection().createStatement();
            ResultSet res = stmt.executeQuery("select " + colName + " from " + tableName + " where 1<0");
            int colType = res.getMetaData().getColumnType(1);
            int colPrec = res.getMetaData().getPrecision(1);
            String colTypeName = res.getMetaData().getColumnTypeName(1);
            stmt.close();
            res.close();
            return new ColumnType(colType, colPrec, colTypeName);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean columnExists(String tableName, String colName) {
        try {
            Statement stmt = this.connectionProvider.getConnection().createStatement();
            ResultSet res = stmt.executeQuery("select * from " + tableName + " where 1<0");
            ResultSetMetaData metaData = res.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                if (!metaData.getColumnName(i).equalsIgnoreCase(colName)) continue;
                return true;
            }
            res.close();
            stmt.close();
            return false;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureTable(String tableName, Schema schema) {
        if (this.schemaInspector.relationExists(tableName)) {
            return;
        }
        logger.info("creating javers table {} ...", (Object)tableName);
        this.schemaManager.create(schema);
    }

    private void addStringColumn(String tableName, String colName, int len) {
        logger.warn("column " + tableName + "." + colName + " not exists, running ALTER TABLE ...");
        String sqlType = this.dialect.types().string(len);
        if (this.dialect instanceof OracleDialect || this.dialect instanceof MsSqlDialect) {
            this.executeSQL("ALTER TABLE " + tableName + " ADD " + colName + " " + sqlType);
        } else {
            this.executeSQL("ALTER TABLE " + tableName + " ADD COLUMN " + colName + " " + sqlType);
        }
    }

    private void addLongColumn(String tableName, String colName) {
        logger.warn("column " + tableName + "." + colName + " not exists, running ALTER TABLE ...");
        String sqlType = this.dialect.types().bigint(0);
        if (this.dialect instanceof OracleDialect || this.dialect instanceof MsSqlDialect) {
            this.executeSQL("ALTER TABLE " + tableName + " ADD " + colName + " " + sqlType);
        } else {
            this.executeSQL("ALTER TABLE " + tableName + " ADD COLUMN " + colName + " " + sqlType);
        }
    }

    private void addIndex(DBObjectName tableName, FixedSchemaFactory.IndexedCols indexedCols) {
        String indexName = FixedSchemaFactory.createIndexName(tableName, indexedCols);
        if (!this.schemaInspector.indexExists(tableName.localName(), indexName)) {
            String ddl = IndexBuilder.index((Dialect)this.dialect, (String)indexName).indexing(indexedCols.indexedColNames()).on(tableName.nameWithSchema()).build().ddl();
            this.executeSQL(ddl);
        }
    }

    public void dropSchema() {
        throw new RuntimeException("not implemented");
    }

    static class ColumnType {
        final int type;
        final int precision;
        final String typeName;

        ColumnType(int type, int precision, String typeName) {
            this.type = type;
            this.precision = precision;
            this.typeName = typeName;
        }

        public String toString() {
            return "ColumnType{type=" + this.type + ", precision=" + this.precision + ", typeName='" + this.typeName + '\'' + '}';
        }
    }
}

