/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.schema;

import java.io.Closeable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.javers.repository.sql.ConnectionProvider;
import org.javers.repository.sql.schema.FixedSchemaFactory;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.dialect.H2Dialect;
import org.polyjdbc.core.dialect.MsSqlDialect;
import org.polyjdbc.core.dialect.MysqlDialect;
import org.polyjdbc.core.dialect.OracleDialect;
import org.polyjdbc.core.dialect.PostgresDialect;
import org.polyjdbc.core.schema.SchemaInspector;
import org.polyjdbc.core.schema.SchemaManager;
import org.polyjdbc.core.schema.model.Schema;
import org.polyjdbc.core.util.TheCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversSchemaManager {
    private static final Logger logger = LoggerFactory.getLogger(JaversSchemaManager.class);
    private SchemaInspector schemaInspector;
    private SchemaManager schemaManager;
    private final Dialect dialect;
    private final FixedSchemaFactory schemaFactory;
    private final PolyJDBC polyJDBC;
    private final ConnectionProvider connectionProvider;

    public JaversSchemaManager(Dialect dialect, FixedSchemaFactory schemaFactory, PolyJDBC polyJDBC, ConnectionProvider connectionProvider) {
        this.dialect = dialect;
        this.schemaFactory = schemaFactory;
        this.polyJDBC = polyJDBC;
        this.connectionProvider = connectionProvider;
    }

    public void ensureSchema() {
        this.schemaInspector = this.polyJDBC.schemaInspector();
        this.schemaManager = this.polyJDBC.schemaManager();
        for (Map.Entry<String, Schema> e : this.schemaFactory.allTablesSchema(this.dialect).entrySet()) {
            this.ensureTable(e.getKey(), e.getValue());
        }
        this.alterCommitIdColumnIfNeeded();
        this.addSnapshotVersionColumnIfNeeded();
        TheCloser.close((Closeable[])new Closeable[]{this.schemaManager, this.schemaInspector});
    }

    private void alterCommitIdColumnIfNeeded() {
        if (this.getTypeOf("jv_commit", "commit_id") == 12) {
            logger.info("migrating db schema from JaVers 1.3.15 to 1.3.16 ...");
            if (this.dialect instanceof PostgresDialect) {
                this.executeSQL("ALTER TABLE jv_commit ALTER COLUMN commit_id TYPE numeric(12,2) USING commit_id::numeric");
            } else if (this.dialect instanceof H2Dialect) {
                this.executeSQL("ALTER TABLE jv_commit ALTER COLUMN commit_id numeric(12,2)");
            } else if (this.dialect instanceof MysqlDialect) {
                this.executeSQL("ALTER TABLE jv_commit MODIFY commit_id numeric(12,2)");
            } else if (this.dialect instanceof OracleDialect) {
                this.executeSQL("ALTER TABLE jv_commit MODIFY commit_id number(12,2)");
            } else if (this.dialect instanceof MsSqlDialect) {
                this.executeSQL("drop index jv_commit_commit_id_idx on jv_commit");
                this.executeSQL("ALTER TABLE jv_commit ALTER COLUMN commit_id numeric(12,2)");
                this.executeSQL("CREATE INDEX jv_commit_commit_id_idx ON jv_commit (commit_id)");
            } else {
                logger.error("\nno DB schema migration script for {} :(\nplease contact with JaVers team, javers@javers.org", (Object)this.dialect.getCode());
            }
        }
    }

    private void addSnapshotVersionColumnIfNeeded() {
        if (!this.columnExists("jv_snapshot", "version")) {
            this.addLongColumn("jv_snapshot", "version");
        }
    }

    private void addLongColumn(String tableName, String colName) {
        logger.warn("column " + tableName + "." + colName + " not exists, running ALTER TABLE ...");
        String sqlType = this.dialect.types().bigint(0);
        if (this.dialect instanceof OracleDialect || this.dialect instanceof MsSqlDialect) {
            this.executeSQL("ALTER TABLE " + tableName + " ADD " + colName + " " + sqlType);
        } else {
            this.executeSQL("ALTER TABLE " + tableName + " ADD COLUMN " + colName + " " + sqlType);
        }
    }

    private boolean executeSQL(String sql) {
        try {
            Statement stmt = this.connectionProvider.getConnection().createStatement();
            boolean b = stmt.execute(sql);
            stmt.close();
            return b;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private int getTypeOf(String tableName, String colName) {
        try {
            Statement stmt = this.connectionProvider.getConnection().createStatement();
            ResultSet res = stmt.executeQuery("select " + colName + " from " + tableName + " where 1<0");
            int colType = res.getMetaData().getColumnType(1);
            stmt.close();
            res.close();
            return colType;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean columnExists(String tableName, String colName) {
        try {
            Statement stmt = this.connectionProvider.getConnection().createStatement();
            ResultSet res = stmt.executeQuery("select * from " + tableName + " where 1<0");
            ResultSetMetaData metaData = res.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                if (!metaData.getColumnName(i).equalsIgnoreCase(colName)) continue;
                return true;
            }
            res.close();
            stmt.close();
            return false;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureTable(String tableName, Schema schema) {
        if (this.schemaInspector.relationExists(tableName)) {
            return;
        }
        logger.info("creating javers table {} ...", (Object)tableName);
        this.schemaManager.create(schema);
    }

    public void dropSchema() {
        throw new RuntimeException("not implemented");
    }
}

