/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.util.Collections;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.sql.PolyUtil;
import org.javers.repository.sql.finders.CdoSnapshotObjectMapper;
import org.javers.repository.sql.finders.GlobalIdFilter;
import org.javers.repository.sql.finders.ManagedClassFilter;
import org.javers.repository.sql.finders.SnapshotFilter;
import org.javers.repository.sql.finders.SnapshotIdFilter;
import org.javers.repository.sql.finders.VoOwnerEntityFilter;
import org.javers.repository.sql.reposiotries.GlobalIdRepository;
import org.joda.time.LocalDateTime;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.Order;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.query.mapper.ObjectMapper;

public class CdoSnapshotFinder {
    private final PolyJDBC polyJDBC;
    private JsonConverter jsonConverter;
    private GlobalIdRepository globalIdRepository;

    public CdoSnapshotFinder(GlobalIdRepository globalIdRepository, PolyJDBC polyJDBC) {
        this.globalIdRepository = globalIdRepository;
        this.polyJDBC = polyJDBC;
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        Optional<Long> globalIdPk = this.globalIdRepository.findGlobalIdPk(globalId);
        if (globalIdPk.isEmpty()) {
            return Optional.empty();
        }
        Optional<Long> maxSnapshot = this.selectMaxSnapshotPrimaryKey((Long)globalIdPk.get());
        if (maxSnapshot.isEmpty()) {
            return Optional.empty();
        }
        QueryParams oneItemLimit = QueryParamsBuilder.withLimit((int)1).build();
        return Optional.of((Object)this.queryForCdoSnapshots(new SnapshotIdFilter((Long)maxSnapshot.get()), (Optional<GlobalId>)Optional.of((Object)globalId), oneItemLimit).get(0));
    }

    public List<CdoSnapshot> getStateHistory(ManagedType managedType, Optional<String> propertyName, QueryParams queryParams) {
        Optional<Long> classPk = this.globalIdRepository.findClassPk(managedType.getName());
        if (classPk.isEmpty()) {
            return Collections.emptyList();
        }
        ManagedClassFilter classFilter = new ManagedClassFilter((long)((Long)classPk.get()), propertyName);
        return this.queryForCdoSnapshots(classFilter, (Optional<GlobalId>)Optional.empty(), queryParams);
    }

    public List<CdoSnapshot> getVOStateHistory(EntityType ownerEntity, String fragment, QueryParams queryParams) {
        Optional<Long> ownerEntityClassPk = this.globalIdRepository.findClassPk(ownerEntity.getName());
        if (ownerEntityClassPk.isEmpty()) {
            return Collections.emptyList();
        }
        VoOwnerEntityFilter voOwnerFilter = new VoOwnerEntityFilter((long)((Long)ownerEntityClassPk.get()), fragment);
        return this.queryForCdoSnapshots(voOwnerFilter, (Optional<GlobalId>)Optional.empty(), queryParams);
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, Optional<String> propertyName, QueryParams queryParams) {
        Optional<Long> globalIdPk = this.globalIdRepository.findGlobalIdPk(globalId);
        if (globalIdPk.isEmpty()) {
            return Collections.emptyList();
        }
        return this.queryForCdoSnapshots(new GlobalIdFilter((Long)globalIdPk.get(), propertyName), (Optional<GlobalId>)Optional.of((Object)globalId), queryParams);
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    private List<CdoSnapshot> queryForCdoSnapshots(SnapshotFilter snapshotFilter, Optional<GlobalId> providedGlobalId, QueryParams queryParams) {
        SelectQuery query = this.polyJDBC.query().select(snapshotFilter.select());
        snapshotFilter.addFrom(query);
        snapshotFilter.addWhere(query);
        if (queryParams.from().isPresent()) {
            snapshotFilter.addFromDateCondition(query, (LocalDateTime)queryParams.from().get());
        }
        if (queryParams.to().isPresent()) {
            snapshotFilter.addToDateCondition(query, (LocalDateTime)queryParams.to().get());
        }
        query.orderBy("snapshot_pk", Order.DESC).limit(queryParams.limit());
        return this.polyJDBC.queryRunner().queryList(query, (ObjectMapper)new CdoSnapshotObjectMapper(this.jsonConverter, providedGlobalId));
    }

    private Optional<Long> selectMaxSnapshotPrimaryKey(long globalIdPk) {
        SelectQuery query = this.polyJDBC.query().select("MAX(snapshot_pk)").from("jv_snapshot").where("global_id_fk = :globalIdPk").withArgument("globalIdPk", (Object)globalIdPk);
        Optional<Long> result = PolyUtil.queryForOptionalLong(query, this.polyJDBC);
        if (result.isPresent() && (Long)result.get() == 0L) {
            return Optional.empty();
        }
        return result;
    }
}

