/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.util.Collections;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.clazz.Entity;
import org.javers.core.metamodel.clazz.ManagedClass;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.repository.sql.PolyUtil;
import org.javers.repository.sql.finders.CdoSnapshotObjectMapper;
import org.javers.repository.sql.finders.GlobalIdFilter;
import org.javers.repository.sql.finders.ManagedClassFilter;
import org.javers.repository.sql.finders.SnapshotFilter;
import org.javers.repository.sql.finders.SnapshotIdFilter;
import org.javers.repository.sql.finders.VoOwnerEntityFilter;
import org.javers.repository.sql.reposiotries.GlobalIdRepository;
import org.javers.repository.sql.reposiotries.PersistentGlobalId;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.Order;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.query.mapper.ObjectMapper;

public class CdoSnapshotFinder {
    private final PolyJDBC polyJDBC;
    private JsonConverter jsonConverter;
    private GlobalIdRepository globalIdRepository;

    public CdoSnapshotFinder(GlobalIdRepository globalIdRepository, PolyJDBC polyJDBC) {
        this.globalIdRepository = globalIdRepository;
        this.polyJDBC = polyJDBC;
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        PersistentGlobalId persistentGlobalId = this.globalIdRepository.findPersistedGlobalId(globalId);
        if (!persistentGlobalId.persisted()) {
            return Optional.empty();
        }
        Optional<Long> maxSnapshot = this.selectMaxSnapshotPrimaryKey(persistentGlobalId);
        if (maxSnapshot.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Object)this.queryForCdoSnapshots(new SnapshotIdFilter((Long)maxSnapshot.get(), persistentGlobalId), 1).get(0));
    }

    public List<CdoSnapshot> getStateHistory(ManagedClass givenClass, Optional<String> propertyName, int limit) {
        Optional<Long> classPk = this.globalIdRepository.findClassPk(givenClass.getClientsClass());
        if (classPk.isEmpty()) {
            return Collections.emptyList();
        }
        ManagedClassFilter classFilter = new ManagedClassFilter((long)((Long)classPk.get()), propertyName);
        return this.queryForCdoSnapshots(classFilter, limit);
    }

    public List<CdoSnapshot> getVOStateHistory(Entity ownerEntity, String fragment, int limit) {
        Optional<Long> ownerEntityClassPk = this.globalIdRepository.findClassPk(ownerEntity.getClientsClass());
        if (ownerEntityClassPk.isEmpty()) {
            return Collections.emptyList();
        }
        VoOwnerEntityFilter voOwnerFilter = new VoOwnerEntityFilter((long)((Long)ownerEntityClassPk.get()), fragment);
        return this.queryForCdoSnapshots(voOwnerFilter, limit);
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, Optional<String> propertyName, int limit) {
        PersistentGlobalId persistentGlobalId = this.globalIdRepository.findPersistedGlobalId(globalId);
        if (!persistentGlobalId.persisted()) {
            return Collections.emptyList();
        }
        return this.queryForCdoSnapshots(new GlobalIdFilter(persistentGlobalId, propertyName), limit);
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    private List<CdoSnapshot> queryForCdoSnapshots(SnapshotFilter snapshotFilter, int limit) {
        SelectQuery query = this.polyJDBC.query().select(snapshotFilter.select());
        snapshotFilter.addFrom(query);
        snapshotFilter.addWhere(query);
        query.orderBy("snapshot_pk", Order.DESC).limit(limit);
        GlobalId providedId = null;
        if (snapshotFilter instanceof GlobalIdFilter) {
            providedId = ((GlobalIdFilter)snapshotFilter).globalId;
        } else if (snapshotFilter instanceof SnapshotIdFilter) {
            providedId = ((SnapshotIdFilter)snapshotFilter).globalId;
        }
        return this.polyJDBC.queryRunner().queryList(query, (ObjectMapper)new CdoSnapshotObjectMapper(this.jsonConverter, providedId));
    }

    private Optional<Long> selectMaxSnapshotPrimaryKey(PersistentGlobalId globalId) {
        SelectQuery query = this.polyJDBC.query().select("MAX(snapshot_pk)").from("jv_snapshot").where("global_id_fk = :globalIdPk").withArgument("globalIdPk", (Object)globalId.getPrimaryKey());
        Optional<Long> result = PolyUtil.queryForOptionalLong(query, this.polyJDBC);
        if (result.isPresent() && (Long)result.get() == 0L) {
            return Optional.empty();
        }
        return result;
    }
}

