/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.poly;

import java.io.Closeable;
import org.javers.repository.sql.poly.ProvidedConnectionTransactionManager;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.query.DialectQueryFactory;
import org.polyjdbc.core.query.QueryRunner;
import org.polyjdbc.core.query.QueryRunnerFactory;
import org.polyjdbc.core.query.SimpleQueryRunner;
import org.polyjdbc.core.query.TransactionRunner;
import org.polyjdbc.core.schema.SchemaInspector;
import org.polyjdbc.core.schema.SchemaManager;
import org.polyjdbc.core.schema.SchemaManagerFactory;
import org.polyjdbc.core.transaction.TransactionManager;
import org.polyjdbc.core.util.TheCloser;

public class JaversPolyJDBC {
    private final Dialect dialect;
    private final DialectQueryFactory queryFactory;
    private final TransactionManager transactionManager;
    private final QueryRunnerFactory queryRunnerFactory;
    private final SimpleQueryRunner simpleQueryRunner;
    private final TransactionRunner transactionRunner;
    private final SchemaManagerFactory schemaManagerFactory;

    public JaversPolyJDBC(ProvidedConnectionTransactionManager transactionManager, Dialect dialect) {
        this.dialect = dialect;
        this.queryFactory = new DialectQueryFactory(dialect);
        this.transactionManager = transactionManager;
        this.queryRunnerFactory = new QueryRunnerFactory(dialect, (TransactionManager)transactionManager);
        this.simpleQueryRunner = new SimpleQueryRunner(this.queryRunnerFactory);
        this.transactionRunner = new TransactionRunner(this.queryRunnerFactory);
        this.schemaManagerFactory = new SchemaManagerFactory((TransactionManager)transactionManager);
    }

    public Dialect dialect() {
        return this.dialect;
    }

    public DialectQueryFactory query() {
        return this.queryFactory;
    }

    public QueryRunner queryRunner() {
        return this.queryRunnerFactory.create();
    }

    public SimpleQueryRunner simpleQueryRunner() {
        return this.simpleQueryRunner;
    }

    public TransactionRunner transactionRunner() {
        return this.transactionRunner;
    }

    public SchemaManager schemaManager() {
        return this.schemaManagerFactory.createManager();
    }

    public SchemaInspector schemaInspector() {
        return this.schemaManagerFactory.createInspector();
    }

    public void rollback(QueryRunner ... toRollback) {
        TheCloser.rollback((QueryRunner[])toRollback);
    }

    public void close(Closeable ... toClose) {
        TheCloser.close((Closeable[])toClose);
    }
}

