/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.AccessSpecifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedValueDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.ConflictingGenericTypesException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.InferenceContext;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.MethodResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.LambdaArgumentTypePlaceholder;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.NullType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.SymbolResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.AbstractTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionClassAdapter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionMethodResolutionLogic;

public class ReflectionInterfaceDeclaration
extends AbstractTypeDeclaration
implements ResolvedInterfaceDeclaration,
MethodResolutionCapability,
MethodUsageResolutionCapability,
SymbolResolutionCapability {
    private Class<?> clazz;
    private TypeSolver typeSolver;
    private ReflectionClassAdapter reflectionClassAdapter;

    public ReflectionInterfaceDeclaration(Class<?> clazz, TypeSolver typeSolver) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException();
        }
        this.clazz = clazz;
        this.typeSolver = typeSolver;
        this.reflectionClassAdapter = new ReflectionClassAdapter(clazz, typeSolver, this);
    }

    @Override
    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return this.isAssignableBy(new ReferenceTypeImpl(other));
    }

    @Override
    public String getPackageName() {
        if (this.clazz.getPackage() != null) {
            return this.clazz.getPackage().getName();
        }
        return null;
    }

    @Override
    public String getClassName() {
        String canonicalName = this.clazz.getCanonicalName();
        if (canonicalName != null && this.getPackageName() != null) {
            return canonicalName.substring(this.getPackageName().length() + 1);
        }
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.clazz.getCanonicalName();
    }

    @Override
    @Deprecated
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> parameterTypes, boolean staticOnly) {
        return ReflectionMethodResolutionLogic.solveMethod(name, parameterTypes, staticOnly, this.typeSolver, this, this.clazz);
    }

    public String toString() {
        return "ReflectionInterfaceDeclaration{clazz=" + this.clazz.getCanonicalName() + '}';
    }

    public ResolvedType getUsage(Node node) {
        return new ReferenceTypeImpl(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReflectionInterfaceDeclaration)) {
            return false;
        }
        ReflectionInterfaceDeclaration that = (ReflectionInterfaceDeclaration)o;
        if (!this.clazz.getCanonicalName().equals(that.clazz.getCanonicalName())) {
            return false;
        }
        return this.getTypeParameters().equals(that.getTypeParameters());
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    @Override
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> parameterTypes, Context invokationContext, List<ResolvedType> typeParameterValues) {
        Optional<MethodUsage> res = ReflectionMethodResolutionLogic.solveMethodAsUsage(name, parameterTypes, this.typeSolver, invokationContext, typeParameterValues, this, this.clazz);
        if (res.isPresent()) {
            InferenceContext inferenceContext = new InferenceContext(this.typeSolver);
            MethodUsage methodUsage = res.get();
            int i = 0;
            LinkedList<ResolvedType> parameters = new LinkedList<ResolvedType>();
            for (ResolvedType actualType : parameterTypes) {
                ResolvedType formalType = methodUsage.getParamType(i);
                parameters.add(inferenceContext.addPair(formalType, actualType));
                ++i;
            }
            try {
                ResolvedType returnType = inferenceContext.addSingle(methodUsage.returnType());
                for (int j = 0; j < parameters.size(); ++j) {
                    methodUsage = methodUsage.replaceParamType(j, inferenceContext.resolve((ResolvedType)parameters.get(j)));
                }
                methodUsage = methodUsage.replaceReturnType(inferenceContext.resolve(returnType));
                return Optional.of(methodUsage);
            }
            catch (ConflictingGenericTypesException e) {
                return Optional.empty();
            }
        }
        return res;
    }

    @Override
    public boolean canBeAssignedTo(ResolvedReferenceTypeDeclaration other) {
        if (other instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (other.getQualifiedName().equals(this.getQualifiedName())) {
            return true;
        }
        if (this.clazz.getSuperclass() != null && new ReflectionInterfaceDeclaration(this.clazz.getSuperclass(), this.typeSolver).canBeAssignedTo(other)) {
            return true;
        }
        for (Class<?> interfaze : this.clazz.getInterfaces()) {
            if (!new ReflectionInterfaceDeclaration(interfaze, this.typeSolver).canBeAssignedTo(other)) continue;
            return true;
        }
        return other.isJavaLangObject();
    }

    @Override
    public boolean isAssignableBy(ResolvedType type) {
        ReferenceTypeImpl otherTypeDeclaration;
        if (type instanceof NullType) {
            return true;
        }
        if (type instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (type.isArray()) {
            return false;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (type.describe().equals(this.getQualifiedName())) {
            return true;
        }
        if (type instanceof ReferenceTypeImpl && (otherTypeDeclaration = (ReferenceTypeImpl)type).getTypeDeclaration().isPresent()) {
            return otherTypeDeclaration.getTypeDeclaration().get().canBeAssignedTo(this);
        }
        return false;
    }

    @Override
    public boolean isTypeParameter() {
        return false;
    }

    @Override
    public ResolvedFieldDeclaration getField(String name) {
        return this.reflectionClassAdapter.getField(name);
    }

    @Override
    public List<ResolvedFieldDeclaration> getAllFields() {
        return this.reflectionClassAdapter.getAllFields();
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        for (Field field : this.clazz.getFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved(new ReflectionFieldDeclaration(field, typeSolver));
        }
        return SymbolReference.unsolved();
    }

    @Override
    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        return this.reflectionClassAdapter.getAncestors();
    }

    @Override
    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.reflectionClassAdapter.getDeclaredMethods();
    }

    @Override
    public boolean hasField(String name) {
        return this.reflectionClassAdapter.hasField(name);
    }

    @Override
    public String getName() {
        return this.clazz.getSimpleName();
    }

    @Override
    public boolean isInterface() {
        return true;
    }

    @Override
    public List<ResolvedReferenceType> getInterfacesExtended() {
        ArrayList<ResolvedReferenceType> res = new ArrayList<ResolvedReferenceType>();
        for (Class<?> i : this.clazz.getInterfaces()) {
            res.add(new ReferenceTypeImpl(new ReflectionInterfaceDeclaration(i, this.typeSolver)));
        }
        return res;
    }

    @Override
    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.reflectionClassAdapter.containerType();
    }

    @Override
    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        return Arrays.stream(this.clazz.getDeclaredClasses()).map(ic -> ReflectionFactory.typeDeclarationFor(ic, this.typeSolver)).collect(Collectors.toSet());
    }

    @Override
    public ResolvedInterfaceDeclaration asInterface() {
        return this;
    }

    @Override
    public boolean hasDirectlyAnnotation(String canonicalName) {
        return this.reflectionClassAdapter.hasDirectlyAnnotation(canonicalName);
    }

    @Override
    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.reflectionClassAdapter.getTypeParameters();
    }

    @Override
    public AccessSpecifier accessSpecifier() {
        return ReflectionFactory.modifiersToAccessLevel(this.clazz.getModifiers());
    }

    @Override
    public List<ResolvedConstructorDeclaration> getConstructors() {
        return Collections.emptyList();
    }
}

