/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.impl;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.BufferedSource;
import org.influxdb.BatchOptions;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBException;
import org.influxdb.InfluxDBIOException;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.BoundParameterQuery;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.impl.BatchProcessor;
import org.influxdb.impl.GzipRequestInterceptor;
import org.influxdb.impl.InfluxDBService;
import org.influxdb.impl.Preconditions;
import org.influxdb.impl.TimeUtil;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

public class InfluxDBImpl
implements InfluxDB {
    static final MediaType MEDIA_TYPE_STRING = MediaType.parse((String)"text/plain");
    private static final String SHOW_DATABASE_COMMAND_ENCODED = Query.encode("SHOW DATABASES");
    private static final InfluxDB.LogLevel LOG_LEVEL = InfluxDB.LogLevel.parseLogLevel(System.getProperty("org.influxdb.InfluxDB.logLevel"));
    private final InetAddress hostAddress;
    private final String username;
    private final String password;
    private final Retrofit retrofit;
    private final InfluxDBService influxDBService;
    private BatchProcessor batchProcessor;
    private final AtomicBoolean batchEnabled = new AtomicBoolean(false);
    private final LongAdder writeCount = new LongAdder();
    private final LongAdder unBatchedCount = new LongAdder();
    private final LongAdder batchedCount = new LongAdder();
    private volatile DatagramSocket datagramSocket;
    private final HttpLoggingInterceptor loggingInterceptor;
    private final GzipRequestInterceptor gzipRequestInterceptor;
    private InfluxDB.LogLevel logLevel = InfluxDB.LogLevel.NONE;
    private JsonAdapter<QueryResult> adapter;
    private String database;
    private String retentionPolicy = "autogen";
    private InfluxDB.ConsistencyLevel consistency = InfluxDB.ConsistencyLevel.ONE;

    public InfluxDBImpl(String url, String username, String password, OkHttpClient.Builder client) {
        Moshi moshi = new Moshi.Builder().build();
        this.hostAddress = this.parseHostAddress(url);
        this.username = username;
        this.password = password;
        this.loggingInterceptor = new HttpLoggingInterceptor();
        this.setLogLevel(LOG_LEVEL);
        this.gzipRequestInterceptor = new GzipRequestInterceptor();
        this.retrofit = new Retrofit.Builder().baseUrl(url).client(client.addInterceptor((Interceptor)this.loggingInterceptor).addInterceptor((Interceptor)this.gzipRequestInterceptor).build()).addConverterFactory((Converter.Factory)MoshiConverterFactory.create()).build();
        this.influxDBService = (InfluxDBService)this.retrofit.create(InfluxDBService.class);
        this.adapter = moshi.adapter(QueryResult.class);
    }

    InfluxDBImpl(String url, String username, String password, OkHttpClient.Builder client, InfluxDBService influxDBService, JsonAdapter<QueryResult> adapter) {
        this.hostAddress = this.parseHostAddress(url);
        this.username = username;
        this.password = password;
        this.loggingInterceptor = new HttpLoggingInterceptor();
        this.setLogLevel(LOG_LEVEL);
        this.gzipRequestInterceptor = new GzipRequestInterceptor();
        this.retrofit = new Retrofit.Builder().baseUrl(url).client(client.addInterceptor((Interceptor)this.loggingInterceptor).addInterceptor((Interceptor)this.gzipRequestInterceptor).build()).addConverterFactory((Converter.Factory)MoshiConverterFactory.create()).build();
        this.influxDBService = influxDBService;
        this.adapter = adapter;
    }

    public InfluxDBImpl(String url, String username, String password, OkHttpClient.Builder client, String database, String retentionPolicy, InfluxDB.ConsistencyLevel consistency) {
        this(url, username, password, client);
        this.setConsistency(consistency);
        this.setDatabase(database);
        this.setRetentionPolicy(retentionPolicy);
    }

    private InetAddress parseHostAddress(String url) {
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            throw new IllegalArgumentException("Unable to parse url: " + url);
        }
        try {
            return InetAddress.getByName(httpUrl.host());
        }
        catch (UnknownHostException e) {
            throw new InfluxDBIOException(e);
        }
    }

    @Override
    public InfluxDB setLogLevel(InfluxDB.LogLevel logLevel) {
        switch (logLevel) {
            case NONE: {
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
                break;
            }
            case BASIC: {
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
                break;
            }
            case HEADERS: {
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
                break;
            }
            case FULL: {
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                break;
            }
        }
        this.logLevel = logLevel;
        return this;
    }

    @Override
    public InfluxDB enableGzip() {
        this.gzipRequestInterceptor.enable();
        return this;
    }

    @Override
    public InfluxDB disableGzip() {
        this.gzipRequestInterceptor.disable();
        return this;
    }

    @Override
    public boolean isGzipEnabled() {
        return this.gzipRequestInterceptor.isEnabled();
    }

    @Override
    public InfluxDB enableBatch() {
        this.enableBatch(BatchOptions.DEFAULTS);
        return this;
    }

    @Override
    public InfluxDB enableBatch(BatchOptions batchOptions) {
        if (this.batchEnabled.get()) {
            throw new IllegalStateException("BatchProcessing is already enabled.");
        }
        this.batchProcessor = BatchProcessor.builder(this).actions(batchOptions.getActions()).exceptionHandler(batchOptions.getExceptionHandler()).interval(batchOptions.getFlushDuration(), batchOptions.getJitterDuration(), TimeUnit.MILLISECONDS).threadFactory(batchOptions.getThreadFactory()).bufferLimit(batchOptions.getBufferLimit()).consistencyLevel(batchOptions.getConsistency()).build();
        this.batchEnabled.set(true);
        return this;
    }

    @Override
    public InfluxDB enableBatch(int actions, int flushDuration, TimeUnit flushDurationTimeUnit) {
        this.enableBatch(actions, flushDuration, flushDurationTimeUnit, Executors.defaultThreadFactory());
        return this;
    }

    @Override
    public InfluxDB enableBatch(int actions, int flushDuration, TimeUnit flushDurationTimeUnit, ThreadFactory threadFactory) {
        this.enableBatch(actions, flushDuration, flushDurationTimeUnit, threadFactory, (points, throwable) -> {});
        return this;
    }

    @Override
    public InfluxDB enableBatch(int actions, int flushDuration, TimeUnit flushDurationTimeUnit, ThreadFactory threadFactory, BiConsumer<Iterable<Point>, Throwable> exceptionHandler, InfluxDB.ConsistencyLevel consistency) {
        this.enableBatch(actions, flushDuration, flushDurationTimeUnit, threadFactory, exceptionHandler).setConsistency(consistency);
        return this;
    }

    @Override
    public InfluxDB enableBatch(int actions, int flushDuration, TimeUnit flushDurationTimeUnit, ThreadFactory threadFactory, BiConsumer<Iterable<Point>, Throwable> exceptionHandler) {
        this.enableBatch(actions, flushDuration, 0, flushDurationTimeUnit, threadFactory, exceptionHandler);
        return this;
    }

    private InfluxDB enableBatch(int actions, int flushDuration, int jitterDuration, TimeUnit durationTimeUnit, ThreadFactory threadFactory, BiConsumer<Iterable<Point>, Throwable> exceptionHandler) {
        if (this.batchEnabled.get()) {
            throw new IllegalStateException("BatchProcessing is already enabled.");
        }
        this.batchProcessor = BatchProcessor.builder(this).actions(actions).exceptionHandler(exceptionHandler).interval(flushDuration, jitterDuration, durationTimeUnit).threadFactory(threadFactory).consistencyLevel(this.consistency).build();
        this.batchEnabled.set(true);
        return this;
    }

    @Override
    public void disableBatch() {
        this.batchEnabled.set(false);
        if (this.batchProcessor != null) {
            this.batchProcessor.flushAndShutdown();
        }
    }

    @Override
    public boolean isBatchEnabled() {
        return this.batchEnabled.get();
    }

    @Override
    public Pong ping() {
        long started = System.currentTimeMillis();
        Call<ResponseBody> call = this.influxDBService.ping();
        try {
            Response response = call.execute();
            Headers headers = response.headers();
            String version = "unknown";
            for (String name : headers.toMultimap().keySet()) {
                if (null == name || !"X-Influxdb-Version".equalsIgnoreCase(name)) continue;
                version = headers.get(name);
                break;
            }
            Pong pong = new Pong();
            pong.setVersion(version);
            pong.setResponseTime(System.currentTimeMillis() - started);
            return pong;
        }
        catch (IOException e) {
            throw new InfluxDBIOException(e);
        }
    }

    @Override
    public String version() {
        return this.ping().getVersion();
    }

    @Override
    public void write(Point point) {
        this.write(this.database, this.retentionPolicy, point);
    }

    @Override
    public void write(String records) {
        this.write(this.database, this.retentionPolicy, this.consistency, records);
    }

    @Override
    public void write(List<String> records) {
        this.write(this.database, this.retentionPolicy, this.consistency, records);
    }

    @Override
    public void write(String database, String retentionPolicy, Point point) {
        if (this.batchEnabled.get()) {
            BatchProcessor.HttpBatchEntry batchEntry = new BatchProcessor.HttpBatchEntry(point, database, retentionPolicy);
            this.batchProcessor.put(batchEntry);
        } else {
            BatchPoints batchPoints = BatchPoints.database(database).retentionPolicy(retentionPolicy).build();
            batchPoints.point(point);
            this.write(batchPoints);
            this.unBatchedCount.increment();
        }
        this.writeCount.increment();
    }

    @Override
    public void write(int udpPort, Point point) {
        if (this.batchEnabled.get()) {
            BatchProcessor.UdpBatchEntry batchEntry = new BatchProcessor.UdpBatchEntry(point, udpPort);
            this.batchProcessor.put(batchEntry);
        } else {
            this.write(udpPort, point.lineProtocol());
            this.unBatchedCount.increment();
        }
        this.writeCount.increment();
    }

    @Override
    public void write(BatchPoints batchPoints) {
        this.batchedCount.add(batchPoints.getPoints().size());
        RequestBody lineProtocol = RequestBody.create((MediaType)MEDIA_TYPE_STRING, (String)batchPoints.lineProtocol());
        this.execute(this.influxDBService.writePoints(this.username, this.password, batchPoints.getDatabase(), batchPoints.getRetentionPolicy(), TimeUtil.toTimePrecision(batchPoints.getPrecision()), batchPoints.getConsistency().value(), lineProtocol));
    }

    @Override
    public void write(String database, String retentionPolicy, InfluxDB.ConsistencyLevel consistency, TimeUnit precision, String records) {
        this.execute(this.influxDBService.writePoints(this.username, this.password, database, retentionPolicy, TimeUtil.toTimePrecision(precision), consistency.value(), RequestBody.create((MediaType)MEDIA_TYPE_STRING, (String)records)));
    }

    @Override
    public void write(String database, String retentionPolicy, InfluxDB.ConsistencyLevel consistency, String records) {
        this.write(database, retentionPolicy, consistency, TimeUnit.NANOSECONDS, records);
    }

    @Override
    public void write(String database, String retentionPolicy, InfluxDB.ConsistencyLevel consistency, List<String> records) {
        this.write(database, retentionPolicy, consistency, TimeUnit.NANOSECONDS, records);
    }

    @Override
    public void write(String database, String retentionPolicy, InfluxDB.ConsistencyLevel consistency, TimeUnit precision, List<String> records) {
        this.write(database, retentionPolicy, consistency, precision, String.join((CharSequence)"\n", records));
    }

    @Override
    public void write(int udpPort, String records) {
        this.initialDatagramSocket();
        byte[] bytes = records.getBytes(StandardCharsets.UTF_8);
        try {
            this.datagramSocket.send(new DatagramPacket(bytes, bytes.length, this.hostAddress, udpPort));
        }
        catch (IOException e) {
            throw new InfluxDBIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialDatagramSocket() {
        if (this.datagramSocket != null) return;
        Class<InfluxDBImpl> clazz = InfluxDBImpl.class;
        synchronized (InfluxDBImpl.class) {
            if (this.datagramSocket != null) return;
            try {
                this.datagramSocket = new DatagramSocket();
            }
            catch (SocketException e) {
                throw new InfluxDBIOException(e);
            }
            return;
        }
    }

    @Override
    public void write(int udpPort, List<String> records) {
        this.write(udpPort, String.join((CharSequence)"\n", records));
    }

    @Override
    public QueryResult query(Query query) {
        return this.execute(this.callQuery(query));
    }

    @Override
    public void query(Query query, final Consumer<QueryResult> onSuccess, final Consumer<Throwable> onFailure) {
        Call<QueryResult> call = this.callQuery(query);
        call.enqueue((Callback)new Callback<QueryResult>(){

            public void onResponse(Call<QueryResult> call, Response<QueryResult> response) {
                onSuccess.accept(response.body());
            }

            public void onFailure(Call<QueryResult> call, Throwable throwable) {
                onFailure.accept(throwable);
            }
        });
    }

    @Override
    public void query(Query query, int chunkSize, final Consumer<QueryResult> consumer) {
        if (this.version().startsWith("0.") || this.version().startsWith("1.0")) {
            throw new UnsupportedOperationException("chunking not supported");
        }
        Call<ResponseBody> call = null;
        if (query instanceof BoundParameterQuery) {
            BoundParameterQuery boundParameterQuery = (BoundParameterQuery)query;
            call = this.influxDBService.query(this.username, this.password, query.getDatabase(), query.getCommandWithUrlEncoded(), chunkSize, boundParameterQuery.getParameterJsonWithUrlEncoded());
        } else {
            call = this.influxDBService.query(this.username, this.password, query.getDatabase(), query.getCommandWithUrlEncoded(), chunkSize);
        }
        call.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                try {
                    if (response.isSuccessful()) {
                        BufferedSource source = ((ResponseBody)response.body()).source();
                        while (true) {
                            QueryResult result;
                            if ((result = (QueryResult)InfluxDBImpl.this.adapter.fromJson(source)) == null) {
                                continue;
                            }
                            consumer.accept(result);
                        }
                    }
                    ResponseBody errorBody = response.errorBody();
                    Throwable result = null;
                    try {
                        try {
                            throw new InfluxDBException(errorBody.string());
                        }
                        catch (Throwable throwable) {
                            result = throwable;
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        if (errorBody != null) {
                            if (result != null) {
                                try {
                                    errorBody.close();
                                }
                                catch (Throwable throwable2) {
                                    result.addSuppressed(throwable2);
                                }
                            } else {
                                errorBody.close();
                            }
                        }
                        throw throwable;
                    }
                }
                catch (EOFException e) {
                    QueryResult queryResult = new QueryResult();
                    queryResult.setError("DONE");
                    consumer.accept(queryResult);
                }
                catch (IOException e) {
                    QueryResult queryResult = new QueryResult();
                    queryResult.setError(e.toString());
                    consumer.accept(queryResult);
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                throw new InfluxDBException(t);
            }
        });
    }

    @Override
    public QueryResult query(Query query, TimeUnit timeUnit) {
        Call<QueryResult> call = null;
        if (query instanceof BoundParameterQuery) {
            BoundParameterQuery boundParameterQuery = (BoundParameterQuery)query;
            call = this.influxDBService.query(this.username, this.password, query.getDatabase(), TimeUtil.toTimePrecision(timeUnit), query.getCommandWithUrlEncoded(), boundParameterQuery.getParameterJsonWithUrlEncoded());
        } else {
            call = this.influxDBService.query(this.username, this.password, query.getDatabase(), TimeUtil.toTimePrecision(timeUnit), query.getCommandWithUrlEncoded());
        }
        return this.execute(call);
    }

    @Override
    public void createDatabase(String name) {
        Preconditions.checkNonEmptyString(name, "name");
        String createDatabaseQueryString = String.format("CREATE DATABASE \"%s\"", name);
        if (this.version().startsWith("0.")) {
            createDatabaseQueryString = String.format("CREATE DATABASE IF NOT EXISTS \"%s\"", name);
        }
        this.execute(this.influxDBService.postQuery(this.username, this.password, Query.encode(createDatabaseQueryString)));
    }

    @Override
    public void deleteDatabase(String name) {
        this.execute(this.influxDBService.postQuery(this.username, this.password, Query.encode("DROP DATABASE \"" + name + "\"")));
    }

    @Override
    public List<String> describeDatabases() {
        QueryResult result = this.execute(this.influxDBService.query(this.username, this.password, SHOW_DATABASE_COMMAND_ENCODED));
        List<List<Object>> databaseNames = result.getResults().get(0).getSeries().get(0).getValues();
        ArrayList<String> databases = new ArrayList<String>();
        if (databaseNames != null) {
            for (List<Object> database : databaseNames) {
                databases.add(database.get(0).toString());
            }
        }
        return databases;
    }

    @Override
    public boolean databaseExists(String name) {
        List<String> databases = this.describeDatabases();
        for (String databaseName : databases) {
            if (!databaseName.trim().equals(name)) continue;
            return true;
        }
        return false;
    }

    private Call<QueryResult> callQuery(Query query) {
        Call<QueryResult> call;
        if (query instanceof BoundParameterQuery) {
            BoundParameterQuery boundParameterQuery = (BoundParameterQuery)query;
            call = this.influxDBService.postQuery(this.username, this.password, query.getDatabase(), query.getCommandWithUrlEncoded(), boundParameterQuery.getParameterJsonWithUrlEncoded());
        } else {
            call = query.requiresPost() ? this.influxDBService.postQuery(this.username, this.password, query.getDatabase(), query.getCommandWithUrlEncoded()) : this.influxDBService.query(this.username, this.password, query.getDatabase(), query.getCommandWithUrlEncoded());
        }
        return call;
    }

    private <T> T execute(Call<T> call) {
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return (T)response.body();
            }
            ResponseBody errorBody = response.errorBody();
            Throwable throwable = null;
            try {
                try {
                    throw InfluxDBException.buildExceptionForErrorState(errorBody.string());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (errorBody != null) {
                    if (throwable != null) {
                        try {
                            errorBody.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        errorBody.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new InfluxDBIOException(e);
        }
    }

    @Override
    public void flush() {
        if (!this.batchEnabled.get()) {
            throw new IllegalStateException("BatchProcessing is not enabled.");
        }
        this.batchProcessor.flush();
    }

    @Override
    public void close() {
        try {
            this.disableBatch();
        }
        finally {
            if (this.datagramSocket != null && !this.datagramSocket.isClosed()) {
                this.datagramSocket.close();
            }
        }
    }

    @Override
    public InfluxDB setConsistency(InfluxDB.ConsistencyLevel consistency) {
        this.consistency = consistency;
        return this;
    }

    @Override
    public InfluxDB setDatabase(String database) {
        this.database = database;
        return this;
    }

    @Override
    public InfluxDB setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    @Override
    public void createRetentionPolicy(String rpName, String database, String duration, String shardDuration, int replicationFactor, boolean isDefault) {
        Preconditions.checkNonEmptyString(rpName, "retentionPolicyName");
        Preconditions.checkNonEmptyString(database, "database");
        Preconditions.checkNonEmptyString(duration, "retentionDuration");
        Preconditions.checkDuration(duration, "retentionDuration");
        if (shardDuration != null && !shardDuration.isEmpty()) {
            Preconditions.checkDuration(shardDuration, "shardDuration");
        }
        Preconditions.checkPositiveNumber(replicationFactor, "replicationFactor");
        StringBuilder queryBuilder = new StringBuilder("CREATE RETENTION POLICY \"");
        queryBuilder.append(rpName).append("\" ON \"").append(database).append("\" DURATION ").append(duration).append(" REPLICATION ").append(replicationFactor);
        if (shardDuration != null && !shardDuration.isEmpty()) {
            queryBuilder.append(" SHARD DURATION ");
            queryBuilder.append(shardDuration);
        }
        if (isDefault) {
            queryBuilder.append(" DEFAULT");
        }
        this.execute(this.influxDBService.postQuery(this.username, this.password, Query.encode(queryBuilder.toString())));
    }

    @Override
    public void createRetentionPolicy(String rpName, String database, String duration, int replicationFactor, boolean isDefault) {
        this.createRetentionPolicy(rpName, database, duration, null, replicationFactor, isDefault);
    }

    @Override
    public void createRetentionPolicy(String rpName, String database, String duration, String shardDuration, int replicationFactor) {
        this.createRetentionPolicy(rpName, database, duration, null, replicationFactor, false);
    }

    @Override
    public void dropRetentionPolicy(String rpName, String database) {
        Preconditions.checkNonEmptyString(rpName, "retentionPolicyName");
        Preconditions.checkNonEmptyString(database, "database");
        StringBuilder queryBuilder = new StringBuilder("DROP RETENTION POLICY \"");
        queryBuilder.append(rpName).append("\" ON \"").append(database).append("\"");
        this.execute(this.influxDBService.postQuery(this.username, this.password, Query.encode(queryBuilder.toString())));
    }

    static class ErrorMessage {
        public String error;

        ErrorMessage() {
        }
    }
}

