/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Generated;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.Version;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoSchema;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.processor.AnnotatedClassScanner;
import org.infinispan.protostream.annotations.impl.processor.AnnotationProcessingException;
import org.infinispan.protostream.annotations.impl.processor.CompileTimeProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.processor.GeneratedFilesWriter;
import org.infinispan.protostream.annotations.impl.processor.OriginatingClasses;
import org.infinispan.protostream.annotations.impl.processor.ProtoSchemaAnnotation;
import org.infinispan.protostream.annotations.impl.processor.ServiceLoaderFileGenerator;
import org.infinispan.protostream.annotations.impl.processor.dependency.CompileTimeDependency;
import org.infinispan.protostream.annotations.impl.processor.types.HasModelElement;
import org.infinispan.protostream.annotations.impl.processor.types.MirrorTypeFactory;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XMethod;

@SupportedOptions(value={"protostream.debug", "protostream.fullyqualifiedannotations"})
@SupportedAnnotationTypes(value={"org.infinispan.protostream.annotations.AutoProtoSchemaBuilder", "org.infinispan.protostream.annotations.ProtoSchema"})
@AutoService(value={Processor.class})
public final class AutoProtoSchemaBuilderAnnotationProcessor
extends AbstractProcessor {
    public static final String DEBUG_OPTION = "protostream.debug";
    public static final String FULLY_QUALIFIED_ANNOTATIONS = "protostream.fullyqualifiedannotations";
    private final ServiceLoaderFileGenerator serviceLoaderFileGenerator = new ServiceLoaderFileGenerator(SerializationContextInitializer.class);
    private GeneratedFilesWriter generatedFilesWriter;
    private boolean isDebugEnabled;
    private MirrorTypeFactory typeFactory;
    private final Set<String> processedElementsFQN = new HashSet<String>();
    private Types types;
    private Elements elements;
    private Filer filer;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.isDebugEnabled = Boolean.parseBoolean(processingEnv.getOptions().get(DEBUG_OPTION));
        this.typeFactory = new MirrorTypeFactory(processingEnv);
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.generatedFilesWriter = new GeneratedFilesWriter(this.filer);
        this.ensureRequiredEnv();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void reportError(AnnotationProcessingException ex) {
        if (ex.getLocation() != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ex.getFormattedMessage(), ex.getLocation());
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ex.getFormattedMessage());
        }
    }

    private void reportError(Element e, String message, Object ... msgParams) {
        String formatted = String.format(message, msgParams);
        if (e != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, formatted, e);
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, formatted);
        }
    }

    private void reportWarning(Element e, String message, Object ... msgParams) {
        String formatted = String.format(message, msgParams);
        if (e != null) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, formatted, e);
        } else {
            this.messager.printMessage(Diagnostic.Kind.WARNING, formatted);
        }
    }

    private void logDebug(String message, Object ... msgParams) {
        if (this.isDebugEnabled) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(message, msgParams));
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.isDebugEnabled) {
            this.logDebug("%s annotations=%s, rootElements=%s", this.getClass().getSimpleName(), annotations, roundEnv.getRootElements());
        }
        try {
            for (TypeElement typeElement : annotations) {
                for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                    ProtoSchemaAnnotation builderAnnotation = this.getBuilderAnnotation(element);
                    SerializationContext serCtx = ProtobufUtil.newSerializationContext();
                    try {
                        this.processElement(roundEnv, serCtx, element, builderAnnotation, new ProcessorContext());
                    }
                    catch (DescriptorParserException | ProtoSchemaBuilderException e) {
                        throw new AnnotationProcessingException(e, element, "%s", AutoProtoSchemaBuilderAnnotationProcessor.getStackTraceAsString(e));
                    }
                }
            }
            if (roundEnv.processingOver()) {
                this.serviceLoaderFileGenerator.writeServiceFile(this.filer);
            }
        }
        catch (AnnotationProcessingException e) {
            if (this.isDebugEnabled) {
                this.logDebug("%s threw an exception: %s", this.getClass().getSimpleName(), AutoProtoSchemaBuilderAnnotationProcessor.getStackTraceAsString(e));
            }
            this.reportError(e);
        }
        catch (Exception e) {
            this.reportError(null, "%s threw a fatal exception: %s", this.getClass().getSimpleName(), AutoProtoSchemaBuilderAnnotationProcessor.getStackTraceAsString(e));
        }
        return !annotations.isEmpty();
    }

    private ProtoSchemaAnnotation getBuilderAnnotation(Element annotatedElement) {
        try {
            ProtoSchema psAnnotation = annotatedElement.getAnnotation(ProtoSchema.class);
            if (psAnnotation != null) {
                return new ProtoSchemaAnnotation(psAnnotation);
            }
            return new ProtoSchemaAnnotation(annotatedElement.getAnnotation(AutoProtoSchemaBuilder.class));
        }
        catch (ClassCastException e) {
            this.reportError(annotatedElement, "Some of the classes referenced by the ProtoSchema/AutoProtoSchemaBuilder annotation do not exist, possibly due to compilation errors in your source code or due to incremental compilation issues caused by your build system. Please try a clean rebuild.", new Object[0]);
            return null;
        }
    }

    private void ensureRequiredEnv() {
        Version procVersion = Version.getVersion(ProtoSchema.class);
        if (Version.getVersion().compareTo(procVersion) != 0) {
            this.reportWarning(null, "Version mismatch! protostream (%s) and protostream-processor (%s) are expected to be the same version. Mixing different versions is unsupported and can lead to unintended consequences.", Version.getVersion(), procVersion);
        }
    }

    private static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private void processElement(RoundEnvironment roundEnv, SerializationContext serCtx, Element annotatedElement, ProtoSchemaAnnotation annotation, ProcessorContext processorContext) throws IOException {
        if (annotatedElement.getKind() != ElementKind.PACKAGE && annotatedElement.getKind() != ElementKind.INTERFACE && annotatedElement.getKind() != ElementKind.CLASS) {
            throw new AnnotationProcessingException(annotatedElement, String.valueOf(annotation) + " annotation can only be applied to classes, interfaces and packages.", new Object[0]);
        }
        AnnotatedClassScanner classScanner = new AnnotatedClassScanner(this.messager, this.elements, this.types, this.typeFactory, annotatedElement, annotation);
        classScanner.discoverClasses(roundEnv);
        this.logDebug("AnnotatedClassScanner.discoverClasses returned: %s", classScanner.getClasses());
        if (classScanner.getClasses().isEmpty()) {
            this.reportWarning(annotatedElement, "No ProtoStream annotated classes found matching the criteria. Please review the 'includeClasses' / 'basePackages' attribute of the @AutoProtoSchemaBuilder annotation.", new Object[0]);
        }
        if (annotatedElement.getKind() == ElementKind.PACKAGE) {
            this.processPackage(roundEnv, serCtx, (PackageElement)annotatedElement, annotation, classScanner, processorContext);
        } else {
            this.processClass(roundEnv, serCtx, (TypeElement)annotatedElement, annotation, classScanner, processorContext);
        }
    }

    private void processPackage(RoundEnvironment roundEnv, SerializationContext serCtx, PackageElement packageElement, ProtoSchemaAnnotation builderAnnotation, AnnotatedClassScanner classScanner, ProcessorContext processorContext) throws IOException {
        String initializerClassName = builderAnnotation.className();
        if (initializerClassName.isEmpty()) {
            throw new AnnotationProcessingException(packageElement, String.valueOf(builderAnnotation) + ".className is required when annotating a package.", new Object[0]);
        }
        if (!SourceVersion.isIdentifier(initializerClassName) || SourceVersion.isKeyword(initializerClassName)) {
            throw new AnnotationProcessingException(packageElement, String.valueOf(builderAnnotation) + ".className annotation attribute must be a valid Java identifier and must not be fully qualified.", new Object[0]);
        }
        String initializerPackageName = packageElement.isUnnamed() ? null : packageElement.getQualifiedName().toString();
        String initializerFQN = initializerPackageName != null ? initializerPackageName + "." + initializerClassName : initializerClassName;
        String protobufPackageName = builderAnnotation.schemaPackageName().isEmpty() ? null : builderAnnotation.schemaPackageName();
        String protobufFileName = this.getProtobufFileName(packageElement, builderAnnotation);
        ProcessorContext dependencies = this.processDependencies(roundEnv, serCtx, packageElement, builderAnnotation);
        Set<XClass> xclasses = classScanner.getXClasses();
        CompileTimeProtoSchemaGenerator protoSchemaGenerator = new CompileTimeProtoSchemaGenerator(this.typeFactory, this.generatedFilesWriter, serCtx, initializerPackageName, protobufFileName, protobufPackageName, dependencies.marshalledClasses, xclasses, builderAnnotation.autoImportClasses(), builderAnnotation.syntax(), builderAnnotation.allowNullFields(), classScanner);
        String schemaSrc = protoSchemaGenerator.generateAndRegister();
        this.writeSerializationContextInitializer(packageElement, packageElement.getQualifiedName().toString(), builderAnnotation, dependencies.initializerClassNames, classScanner.getClasses(), protoSchemaGenerator.getGeneratedMarshallerClasses(), initializerPackageName, initializerClassName, initializerFQN, protobufFileName, protobufPackageName, schemaSrc);
        processorContext.add(classScanner.getInitializerFQClassName(), protobufFileName, protoSchemaGenerator);
    }

    private void processClass(RoundEnvironment roundEnv, SerializationContext serCtx, TypeElement typeElement, ProtoSchemaAnnotation annotation, AnnotatedClassScanner classScanner, ProcessorContext processorContext) throws IOException {
        if (typeElement.getNestingKind() == NestingKind.LOCAL || typeElement.getNestingKind() == NestingKind.ANONYMOUS) {
            throw new AnnotationProcessingException(typeElement, "Classes or interfaces annotated with @%s must not be local or anonymous.", annotation.getAnnotationName());
        }
        if (typeElement.getNestingKind() == NestingKind.MEMBER && !typeElement.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new AnnotationProcessingException(typeElement, "Nested classes or interfaces annotated with @%s must be static.", annotation.getAnnotationName());
        }
        if (typeElement.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new AnnotationProcessingException(typeElement, "Classes annotated with @%s must not be final.", annotation.getAnnotationName());
        }
        if (!(annotation.className().isEmpty() || SourceVersion.isIdentifier(annotation.className()) && !SourceVersion.isKeyword(annotation.className()))) {
            throw new AnnotationProcessingException(typeElement, "@%s.className annotation attribute must be a valid Java identifier and must not be fully qualified.", annotation.getAnnotationName());
        }
        TypeMirror serializationContextInitializerTypeMirror = this.elements.getTypeElement(SerializationContextInitializer.class.getName()).asType();
        if (!this.types.isSubtype(typeElement.asType(), serializationContextInitializerTypeMirror)) {
            throw new AnnotationProcessingException(typeElement, "Classes or interfaces annotated with @%s must implement/extend %s", annotation.getAnnotationName(), SerializationContextInitializer.class.getName());
        }
        PackageElement packageElement = this.elements.getPackageOf(typeElement);
        String initializerPackageName = packageElement.isUnnamed() ? null : packageElement.getQualifiedName().toString();
        String initializerClassName = classScanner.getInitializerClassName();
        String initializerFQN = classScanner.getInitializerFQClassName();
        String protobufPackageName = annotation.schemaPackageName().isEmpty() ? null : annotation.schemaPackageName();
        String protobufFileName = this.getProtobufFileName(typeElement, annotation);
        ProcessorContext dependencies = this.processDependencies(roundEnv, serCtx, typeElement, annotation);
        this.warnOverrideExistingMethods(typeElement);
        Set<XClass> xclasses = classScanner.getXClasses();
        CompileTimeProtoSchemaGenerator protoSchemaGenerator = new CompileTimeProtoSchemaGenerator(this.typeFactory, this.generatedFilesWriter, serCtx, typeElement.getQualifiedName().toString(), protobufFileName, protobufPackageName, dependencies.marshalledClasses, xclasses, annotation.autoImportClasses(), annotation.syntax(), annotation.allowNullFields(), classScanner);
        String schemaSrc = protoSchemaGenerator.generateAndRegister();
        this.writeSerializationContextInitializer(typeElement, typeElement.getQualifiedName().toString(), annotation, dependencies.initializerClassNames, classScanner.getClasses(), protoSchemaGenerator.getGeneratedMarshallerClasses(), initializerPackageName, initializerClassName, initializerFQN, protobufFileName, protobufPackageName, schemaSrc);
        processorContext.add(classScanner.getInitializerFQClassName(), protobufFileName, protoSchemaGenerator);
    }

    private String getProtobufFileName(Element element, ProtoSchemaAnnotation annotation) {
        if (annotation.schemaFileName().isEmpty()) {
            return String.valueOf(element.getSimpleName()) + ".proto";
        }
        if (!annotation.schemaFileName().endsWith(".proto")) {
            this.reportWarning(element, "@%s.schemaFileName should end with '.proto' : %s", annotation.getAnnotationName(), annotation.schemaFileName());
        }
        return annotation.schemaFileName();
    }

    private ProcessorContext processDependencies(RoundEnvironment roundEnv, SerializationContext serCtx, Element annotatedElement, ProtoSchemaAnnotation builderAnnotation) throws IOException {
        List<? extends TypeMirror> dependencies = builderAnnotation.dependsOn();
        ProcessorContext processorContext = new ProcessorContext();
        XClass xClass = this.typeFactory.fromClass(WrappedMessage.class);
        processorContext.marshalledClasses.put(xClass, new CompileTimeDependency("org/infinispan/protostream/message-wrapping.proto", xClass));
        for (TypeMirror typeMirror : dependencies) {
            TypeElement dependencyElement = (TypeElement)this.types.asElement(typeMirror);
            String dependencyFQN = dependencyElement.getQualifiedName().toString();
            ProtoSchemaAnnotation dependencyAnnotation = this.getBuilderAnnotation(dependencyElement);
            if (dependencyAnnotation == null) {
                throw new AnnotationProcessingException(annotatedElement, "Dependency %s is not annotated with %s annotation", dependencyFQN, builderAnnotation);
            }
            if (!this.processedElementsFQN.add(dependencyFQN)) {
                throw new AnnotationProcessingException(annotatedElement, "Illegal recursive dependency on %s", dependencyFQN);
            }
            boolean wasGenerationEnabled = this.generatedFilesWriter.isEnabled();
            this.generatedFilesWriter.setEnabled(false);
            this.processElement(roundEnv, serCtx, dependencyElement, dependencyAnnotation, processorContext);
            this.generatedFilesWriter.setEnabled(wasGenerationEnabled);
            this.processedElementsFQN.remove(dependencyFQN);
        }
        return processorContext;
    }

    private void warnOverrideExistingMethods(TypeElement typeElement) {
        XClass annotatedType = this.typeFactory.fromTypeMirror(typeElement.asType());
        this.warnOverrideExistingMethod(annotatedType, "getProtoFileName", new XClass[0]);
        this.warnOverrideExistingMethod(annotatedType, "getProtoFile", new XClass[0]);
        XClass serializationContextClass = this.typeFactory.fromClass(SerializationContext.class);
        this.warnOverrideExistingMethod(annotatedType, "registerSchema", serializationContextClass);
        this.warnOverrideExistingMethod(annotatedType, "registerMarshallers", serializationContextClass);
    }

    private void warnOverrideExistingMethod(XClass xclass, String methodName, XClass ... argTypes) {
        XMethod method = xclass.getMethod(methodName, argTypes);
        if (method != null && !method.isAbstract()) {
            this.reportWarning(((HasModelElement)method).getElement(), "Code generated by the Protostream processor will override your %s.%s method.", method.getDeclaringClass().getName(), method.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeSerializationContextInitializer(Element annotatedElement, String annotatedElementFQN, ProtoSchemaAnnotation annotation, Set<String> serCtxInitDeps, Collection<? extends TypeMirror> classes, Set<String> generatedMarshallerClasses, String packageName, String initializerClassName, String initializerFQN, String fileName, String protobufPackageName, String schemaSrc) throws IOException {
        void var16_27;
        String string;
        Element[] originatingElements = new Element[classes.size() + 1];
        originatingElements[0] = annotatedElement;
        int i = 1;
        for (TypeMirror typeMirror : classes) {
            originatingElements[i++] = this.types.asElement(typeMirror);
        }
        boolean marshallersOnly = annotation.marshallersOnly();
        if (marshallersOnly && annotatedElement.getKind() != ElementKind.PACKAGE) {
            TypeMirror typeMirror = this.elements.getTypeElement(GeneratedSchema.class.getName()).asType();
            if (this.types.isSubtype(annotatedElement.asType(), typeMirror)) {
                this.reportError(annotatedElement, String.valueOf(annotation) + ".marshallersOnly cannot be set to 'true' when the annotated element is a subtype of %s", GeneratedSchema.class.getName());
            }
        }
        if ((string = annotation.schemaFilePath()).isEmpty()) {
            Object var16_21 = null;
        } else {
            void var16_25;
            void var16_23;
            if (marshallersOnly) {
                this.reportError(annotatedElement, "@%s.schemaFilePath cannot be set if @%s.marshallersOnly was set to 'true'", annotation.getAnnotationName(), annotation.getAnnotationName());
            }
            if (!string.startsWith("/")) {
                String string2 = "/" + string;
            }
            if (!var16_23.endsWith("/")) {
                String string3 = (String)var16_23 + "/";
            }
            String string4 = (String)var16_25 + (fileName.startsWith("/") ? fileName.substring(1) : fileName);
            this.generatedFilesWriter.addSchemaResourceFile(string4, schemaSrc, originatingElements);
        }
        if (annotation.service()) {
            this.serviceLoaderFileGenerator.addProvider(initializerFQN, annotatedElement);
        }
        String initializerSrc = this.generateSerializationContextInitializer(annotatedElement, annotatedElementFQN, annotation, serCtxInitDeps, classes, generatedMarshallerClasses, packageName, initializerClassName, fileName, protobufPackageName, marshallersOnly ? null : schemaSrc, (String)var16_27);
        this.generatedFilesWriter.addInitializerSourceFile(initializerFQN, initializerSrc, originatingElements);
    }

    private String generateSerializationContextInitializer(Element annotatedElement, String annotatedElementFQN, ProtoSchemaAnnotation annotation, Set<String> serCtxInitDeps, Collection<? extends TypeMirror> classes, Set<String> generatedMarshallerClasses, String packageName, String initializerClassName, String fileName, String protobufPackageName, String schemaSrc, String schemaResource) {
        int j;
        StringWriter sw = new StringWriter();
        IndentWriter iw = new IndentWriter((Writer)sw);
        iw.append((CharSequence)"/*\n");
        iw.append((CharSequence)" Generated by ").append((CharSequence)this.getClass().getName()).append((CharSequence)"\n");
        iw.append((CharSequence)(annotatedElement.getKind() == ElementKind.PACKAGE ? " for package " : " for class ")).append((CharSequence)annotatedElementFQN).append((CharSequence)"\n");
        iw.append((CharSequence)" annotated with ").append((CharSequence)String.valueOf(annotation)).append((CharSequence)"\n");
        iw.append((CharSequence)" */\n\n");
        if (packageName != null) {
            iw.append((CharSequence)"package ").append((CharSequence)packageName).append((CharSequence)";\n\n");
        }
        this.addGeneratedClassHeader(iw, classes);
        AutoProtoSchemaBuilderAnnotationProcessor.addSchemaBuilderAnnotation(iw, initializerClassName, fileName, annotation, protobufPackageName, classes, serCtxInitDeps, schemaSrc == null);
        iw.append((CharSequence)"@SuppressWarnings(\"unchecked\")\n");
        iw.append((CharSequence)"public class ").append((CharSequence)initializerClassName);
        if (annotatedElement.getKind() == ElementKind.PACKAGE) {
            iw.append((CharSequence)" implements ").append((CharSequence)(schemaSrc == null ? SerializationContextInitializer.class.getName() : GeneratedSchema.class.getName()));
        } else {
            iw.append((CharSequence)(annotatedElement.getKind() == ElementKind.INTERFACE ? " implements " : " extends ")).append((CharSequence)annotatedElementFQN);
            if (schemaSrc != null) {
                TypeMirror generatedSchemaType = this.elements.getTypeElement(GeneratedSchema.class.getName()).asType();
                if (!this.types.isSubtype(annotatedElement.asType(), generatedSchemaType)) {
                    iw.append((CharSequence)(annotatedElement.getKind() == ElementKind.INTERFACE ? ", " : " implements ")).append((CharSequence)GeneratedSchema.class.getName());
                }
            }
        }
        iw.append((CharSequence)" {\n\n");
        iw.inc();
        if (schemaSrc != null && schemaResource == null) {
            iw.append((CharSequence)"private static final String PROTO_SCHEMA = ").append((CharSequence)this.makeStringLiteral(schemaSrc)).append((CharSequence)";\n\n");
        }
        int k = 0;
        for (String s : serCtxInitDeps) {
            iw.append((CharSequence)"private final ").append((CharSequence)s).append((CharSequence)" dep").append((CharSequence)String.valueOf(k++)).append((CharSequence)" = new ").append((CharSequence)s).append((CharSequence)"();\n\n");
        }
        if (schemaSrc != null) {
            iw.append((CharSequence)"@Override\npublic String getProtoFileName() { return \"").append((CharSequence)fileName).append((CharSequence)"\"; }\n\n");
            iw.append((CharSequence)"@Override\npublic String getProtoFile() { return ");
            if (schemaResource == null) {
                iw.append((CharSequence)"PROTO_SCHEMA");
            } else {
                iw.append((CharSequence)"org.infinispan.protostream.impl.ResourceUtils.getResourceAsString(getClass(), \"").append((CharSequence)schemaResource).append((CharSequence)"\")");
            }
            iw.append((CharSequence)"; }\n\n");
            if (schemaResource != null) {
                iw.append((CharSequence)"@Override\npublic java.io.Reader getProtoFileReader() { return ");
                iw.append((CharSequence)"org.infinispan.protostream.impl.ResourceUtils.getResourceAsReader(getClass(), \"").append((CharSequence)schemaResource).append((CharSequence)"\")");
                iw.append((CharSequence)"; }\n\n");
            }
        } else {
            iw.append((CharSequence)"@Override\npublic String getProtoFileName() { /* DUMMY! */ return \"").append((CharSequence)fileName).append((CharSequence)"\"; }\n\n");
            iw.append((CharSequence)"@Override\npublic String getProtoFile() { /* DUMMY! */ return \"// ").append((CharSequence)fileName).append((CharSequence)"\"; }\n\n");
        }
        iw.append((CharSequence)"@Override\n");
        iw.append((CharSequence)"public void registerSchema(org.infinispan.protostream.SerializationContext serCtx) {\n");
        iw.inc();
        for (j = 0; j < serCtxInitDeps.size(); ++j) {
            iw.append((CharSequence)"dep").append((CharSequence)String.valueOf(j)).append((CharSequence)".registerSchema(serCtx);\n");
        }
        if (schemaSrc != null) {
            iw.append((CharSequence)"serCtx.registerProtoFiles(org.infinispan.protostream.FileDescriptorSource.fromString(getProtoFileName(), getProtoFile()));\n");
        }
        iw.dec();
        iw.append((CharSequence)"}\n\n");
        iw.append((CharSequence)"@Override\n");
        iw.append((CharSequence)"public void registerMarshallers(org.infinispan.protostream.SerializationContext serCtx) {\n");
        iw.inc();
        for (j = 0; j < serCtxInitDeps.size(); ++j) {
            iw.append((CharSequence)"dep").append((CharSequence)String.valueOf(j)).append((CharSequence)".registerMarshallers(serCtx);\n");
        }
        for (String name : generatedMarshallerClasses) {
            iw.append((CharSequence)"serCtx.registerMarshaller(new ").append((CharSequence)name).append((CharSequence)"());\n");
        }
        iw.dec();
        iw.append((CharSequence)"}\n");
        iw.dec();
        iw.append((CharSequence)"}\n");
        return sw.toString();
    }

    static void addGeneratedClassHeader(IndentWriter iw, String ... classes) {
        iw.append((CharSequence)"/**\n * WARNING: Generated code! Do not edit!\n").append((CharSequence)" */\n");
        iw.append('@').append((CharSequence)Generated.class.getName()).append((CharSequence)"(\n   value = \"").append((CharSequence)AutoProtoSchemaBuilderAnnotationProcessor.class.getName()).append((CharSequence)"\",\n   comments = \"Please do not edit this file!\"\n)\n");
        if (classes.length > 0) {
            iw.append('@').append((CharSequence)OriginatingClasses.class.getName()).append((CharSequence)"({\n");
            iw.inc();
            for (int i = 0; i < classes.length; ++i) {
                if (i != 0) {
                    iw.append((CharSequence)",\n");
                }
                iw.append((CharSequence)classes[i]).append((CharSequence)".class");
            }
            iw.append('\n');
            iw.dec();
            iw.append((CharSequence)"})\n");
        }
    }

    private void addGeneratedClassHeader(IndentWriter iw, Collection<? extends TypeMirror> classes) {
        String[] names = new String[classes.size()];
        int i = 0;
        for (TypeMirror typeMirror : classes) {
            Name name = ((TypeElement)this.types.asElement(typeMirror)).getQualifiedName();
            names[i++] = name.toString();
        }
        AutoProtoSchemaBuilderAnnotationProcessor.addGeneratedClassHeader(iw, names);
    }

    private static void addSchemaBuilderAnnotation(IndentWriter iw, String className, String schemaFileName, ProtoSchemaAnnotation annotation, String schemaPackageName, Collection<? extends TypeMirror> classes, Set<String> dependsOn, boolean marshallersOnly) {
        boolean first;
        iw.append((CharSequence)"/*@").append((CharSequence)annotation.toString()).append((CharSequence)"(\n");
        iw.inc();
        iw.append((CharSequence)"className = \"").append((CharSequence)className).append((CharSequence)"\",\n");
        iw.append((CharSequence)"schemaFileName = \"").append((CharSequence)schemaFileName).append((CharSequence)"\",\n");
        if (annotation.schemaFilePath() != null) {
            iw.append((CharSequence)"schemaFilePath = \"").append((CharSequence)annotation.schemaFilePath()).append((CharSequence)"\",\n");
        }
        if (schemaPackageName != null) {
            iw.append((CharSequence)"schemaPackageName = \"").append((CharSequence)schemaPackageName).append((CharSequence)"\",\n");
        }
        if (!dependsOn.isEmpty()) {
            iw.append((CharSequence)"dependsOn = {\n");
            iw.inc();
            first = true;
            for (String string : dependsOn) {
                if (first) {
                    first = false;
                } else {
                    iw.append(',');
                }
                iw.append('\n').append((CharSequence)string).append((CharSequence)".class");
            }
            iw.append('\n');
            iw.dec();
            iw.append((CharSequence)"},\n");
        }
        iw.append((CharSequence)"service = ").append((CharSequence)String.valueOf(annotation.service())).append((CharSequence)",\n");
        iw.append((CharSequence)"marshallersOnly = ").append((CharSequence)String.valueOf(marshallersOnly)).append((CharSequence)",\n");
        iw.append((CharSequence)"autoImportClasses = ").append((CharSequence)String.valueOf(annotation.autoImportClasses())).append((CharSequence)",\n");
        iw.append((CharSequence)"includeClasses = {");
        iw.inc();
        first = true;
        for (TypeMirror typeMirror : classes) {
            if (first) {
                first = false;
            } else {
                iw.append(',');
            }
            iw.append('\n').append((CharSequence)typeMirror.toString()).append((CharSequence)".class");
        }
        iw.append('\n');
        iw.dec();
        iw.append((CharSequence)"}\n");
        iw.dec();
        iw.append((CharSequence)")*/\n");
    }

    private String makeStringLiteral(String s) {
        return "\"\"\"\n" + s + "\n\"\"\"";
    }

    private String makeNestedClassName(TypeElement e, String className) {
        Element enclosingElement = e.getEnclosingElement();
        if (enclosingElement instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)enclosingElement;
            return packageElement.isUnnamed() ? className : String.valueOf(packageElement.getQualifiedName()) + "." + className;
        }
        TypeElement typeElement = (TypeElement)enclosingElement;
        return this.makeNestedClassName(typeElement, String.valueOf(typeElement.getSimpleName()) + "$" + className);
    }

    private static final class ProcessorContext {
        final Set<String> initializerClassNames = new LinkedHashSet<String>();
        final Map<XClass, CompileTimeDependency> marshalledClasses = new HashMap<XClass, CompileTimeDependency>();

        private ProcessorContext() {
        }

        void add(String initializerFQN, String protobufFileName, CompileTimeProtoSchemaGenerator schemaGenerator) {
            this.initializerClassNames.add(initializerFQN);
            for (XClass marshalledClass : schemaGenerator.getMarshalledClasses()) {
                XClass adapter = schemaGenerator.getOriginalClass(marshalledClass);
                this.marshalledClasses.put(marshalledClass, new CompileTimeDependency(protobufFileName, adapter));
            }
        }
    }
}

