/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoEnum;
import org.infinispan.protostream.annotations.ProtoEnumValue;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoMessage;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.impl.processor.AnnotationProcessingException;

final class AnnotatedClassScanner {
    private final Elements elements;
    private final Element builderElement;
    private final AutoProtoSchemaBuilder builderAnnotation;

    AnnotatedClassScanner(Elements elements, Element builderElement, AutoProtoSchemaBuilder builderAnnotation) {
        this.elements = elements;
        this.builderElement = builderElement;
        this.builderAnnotation = builderAnnotation;
    }

    Collection<? extends TypeMirror> discoverClasses(RoundEnvironment roundEnv) throws AnnotationProcessingException {
        Set<String> packages = this.getBasePackages();
        Set<TypeMirror> includedClasses = this.getIncludedClasses();
        Set<TypeMirror> excludedClasses = this.getExcludedClasses();
        PackageElement packageOfInitializer = this.elements.getPackageOf(this.builderElement);
        TreeMap<String, TypeMirror> classes = new TreeMap<String, TypeMirror>();
        if (includedClasses.isEmpty()) {
            TypeElement typeElement;
            Element enclosingElement;
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoField.class)) {
                enclosingElement = element.getEnclosingElement();
                if (enclosingElement.getKind() != ElementKind.CLASS && enclosingElement.getKind() != ElementKind.INTERFACE) continue;
                TypeElement typeElement2 = (TypeElement)enclosingElement;
                this.filterByPackage(classes, typeElement2, excludedClasses, packages, packageOfInitializer);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoEnumValue.class)) {
                enclosingElement = element.getEnclosingElement();
                if (element.getKind() != ElementKind.ENUM_CONSTANT || enclosingElement.getKind() != ElementKind.ENUM) {
                    throw new AnnotationProcessingException(element, "@ProtoEnumValue can only be applied to enum constants.", new Object[0]);
                }
                TypeElement typeElement2 = (TypeElement)enclosingElement;
                this.filterByPackage(classes, typeElement2, excludedClasses, packages, packageOfInitializer);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoEnum.class)) {
                if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) {
                    throw new AnnotationProcessingException(element, "@ProtoEnum can only be applied to enums.", new Object[0]);
                }
                typeElement = (TypeElement)element;
                this.filterByPackage(classes, typeElement, excludedClasses, packages, packageOfInitializer);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoMessage.class)) {
                if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) {
                    throw new AnnotationProcessingException(element, "@ProtoMessage can only be applied to classes and interfaces.", new Object[0]);
                }
                typeElement = (TypeElement)element;
                this.filterByPackage(classes, typeElement, excludedClasses, packages, packageOfInitializer);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoName.class)) {
                if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE && element.getKind() != ElementKind.ENUM) {
                    throw new AnnotationProcessingException(element, "@ProtoName can only be applied to classes, interfaces and enums.", new Object[0]);
                }
                typeElement = (TypeElement)element;
                this.filterByPackage(classes, typeElement, excludedClasses, packages, packageOfInitializer);
            }
        } else {
            for (TypeMirror typeMirror : includedClasses) {
                TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                this.filterByPackage(classes, typeElement, excludedClasses, packages, packageOfInitializer);
            }
        }
        return classes.values();
    }

    private Set<String> getBasePackages() {
        if (this.builderAnnotation.value().length == 0 && this.builderAnnotation.basePackages().length == 0) {
            return Collections.emptySet();
        }
        if (this.builderAnnotation.value().length != 0 && this.builderAnnotation.basePackages().length != 0) {
            throw new AnnotationProcessingException(this.builderElement, "@AutoProtoSchemaBuilder.value and @AutoProtoSchemaBuilder.basePackages are mutually exclusive", new Object[0]);
        }
        boolean usingAlias = true;
        String[] basePackages = this.builderAnnotation.value();
        if (basePackages.length == 0) {
            usingAlias = false;
            basePackages = this.builderAnnotation.basePackages();
        }
        HashSet<String> packages = new HashSet<String>(basePackages.length);
        for (String p : basePackages) {
            if (!SourceVersion.isName(p)) {
                throw new AnnotationProcessingException(this.builderElement, "@AutoProtoSchemaBuilder.%s contains an invalid package name : \"%s\"", usingAlias ? "value" : "basePackages", p);
            }
            packages.add(p);
        }
        return packages;
    }

    private Set<TypeMirror> getIncludedClasses() {
        List<Object> classes = Collections.emptyList();
        try {
            this.builderAnnotation.includeClasses();
        }
        catch (MirroredTypesException mte) {
            classes = mte.getTypeMirrors();
        }
        return new LinkedHashSet<TypeMirror>(classes);
    }

    private Set<TypeMirror> getExcludedClasses() {
        List<Object> classes = Collections.emptyList();
        try {
            this.builderAnnotation.excludeClasses();
        }
        catch (MirroredTypesException mte) {
            classes = mte.getTypeMirrors();
        }
        return new LinkedHashSet<TypeMirror>(classes);
    }

    private void filterByPackage(Map<String, TypeMirror> collectedClasses, TypeElement typeElement, Set<TypeMirror> excludedClasses, Set<String> packages, PackageElement packageOfInitializer) {
        String packageName;
        if (typeElement.getKind() == ElementKind.INTERFACE || typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        PackageElement packageOfElement = this.elements.getPackageOf(typeElement);
        if (packageOfElement.isUnnamed() && !packageOfInitializer.isUnnamed()) {
            return;
        }
        if (!this.isPublicElement(typeElement) && !packageOfElement.equals(packageOfInitializer)) {
            return;
        }
        TypeMirror type = typeElement.asType();
        if (excludedClasses.contains(type)) {
            return;
        }
        if (!packages.isEmpty() && !this.isPackageIncluded(packages, packageName = packageOfElement.getQualifiedName().toString())) {
            return;
        }
        collectedClasses.putIfAbsent(typeElement.getQualifiedName().toString(), type);
    }

    private boolean isPublicElement(TypeElement typeElement) {
        for (Element e = typeElement; e != null; e = e.getEnclosingElement()) {
            if (e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            return false;
        }
        return true;
    }

    private boolean isPackageIncluded(Set<String> packages, String packageName) {
        String p = packageName;
        while (true) {
            if (packages.contains(p)) {
                return true;
            }
            int pos = p.lastIndexOf(46);
            if (pos == -1) break;
            p = p.substring(0, pos);
        }
        return false;
    }
}

