/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

class SourceFileWriter {
    private final Map<String, GeneratedSourceFile> generatedClasses = new LinkedHashMap<String, GeneratedSourceFile>();

    SourceFileWriter() {
    }

    public void writeSourceFile(String className, String classSource, Element originatingElement) {
        this.generatedClasses.put(className, new GeneratedSourceFile(className, classSource, originatingElement));
    }

    private void writeFile(Filer filer, String className, String classSource, Element originatingElement) throws IOException {
        try {
            JavaFileObject file = filer.createSourceFile(className, originatingElement);
            try (PrintWriter out = new PrintWriter(file.openWriter());){
                out.print(classSource);
            }
        }
        catch (FilerException filerException) {
            // empty catch block
        }
    }

    public void writeFiles(Filer filer) throws IOException {
        for (GeneratedSourceFile f : this.generatedClasses.values()) {
            this.writeFile(filer, f.className, f.classSource, f.originatingElement);
        }
    }

    public Set<String> getGeneratedMarshallerClasses() {
        return this.generatedClasses.keySet();
    }

    private static class GeneratedSourceFile {
        private final String className;
        private final String classSource;
        private final Element originatingElement;

        GeneratedSourceFile(String className, String classSource, Element originatingElement) {
            this.className = className;
            this.classSource = classSource;
            this.originatingElement = originatingElement;
        }
    }
}

