/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.impl.AbstractMarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.GeneratedMarshallerBase;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoFieldMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.processor.AutoProtoSchemaBuilderAnnotationProcessor;
import org.infinispan.protostream.annotations.impl.processor.types.HasModelElement;
import org.infinispan.protostream.annotations.impl.types.UnifiedTypeFactory;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.EnumMarshallerDelegate;
import org.infinispan.protostream.impl.Log;

final class MarshallerSourceCodeGenerator
extends AbstractMarshallerCodeGenerator {
    private static final Log log = Log.LogFactory.getLog(MarshallerSourceCodeGenerator.class);
    private final ProcessingEnvironment processingEnv;
    private final Set<String> generatedClasses;

    MarshallerSourceCodeGenerator(ProcessingEnvironment processingEnv, UnifiedTypeFactory typeFactory, String protobufSchemaPackage, Set<String> generatedClasses) {
        super(typeFactory, protobufSchemaPackage);
        this.processingEnv = processingEnv;
        this.generatedClasses = generatedClasses;
    }

    public void generateMarshaller(SerializationContext serCtx, ProtoTypeMetadata ptm) throws IOException {
        if (ptm instanceof ProtoMessageTypeMetadata) {
            this.generateMessageMarshaller((ProtoMessageTypeMetadata)ptm);
        } else if (ptm instanceof ProtoEnumTypeMetadata) {
            this.generateEnumMarshaller((ProtoEnumTypeMetadata)ptm);
        }
    }

    protected String makeUniqueMarshallerClassName() {
        return "_Marshaller" + MarshallerSourceCodeGenerator.nextMarshallerClassId();
    }

    private void generateEnumMarshaller(ProtoEnumTypeMetadata petm) throws IOException {
        String fqn;
        String marshallerClassName = petm.getJavaClass().getSimpleName() + '$' + this.makeUniqueMarshallerClassName();
        if (log.isTraceEnabled()) {
            log.tracef("Generating enum marshaller %s for %s", (Object)marshallerClassName, (Object)petm.getJavaClass().getName());
        }
        IndentWriter iw = new IndentWriter();
        if (petm.getJavaClass().getPackageName() != null) {
            fqn = petm.getJavaClass().getPackageName() + '.' + marshallerClassName;
            iw.append((CharSequence)"package ").append((CharSequence)petm.getJavaClass().getPackageName()).append((CharSequence)";\n\n");
        } else {
            fqn = marshallerClassName;
        }
        iw.append((CharSequence)"public final class ").append((CharSequence)marshallerClassName).append((CharSequence)" implements ").append((CharSequence)EnumMarshaller.class.getName()).append('<').append((CharSequence)petm.getJavaClassName()).append((CharSequence)"> {\n\n");
        iw.inc();
        iw.append((CharSequence)"@Override\npublic Class<").append((CharSequence)petm.getJavaClassName()).append((CharSequence)"> getJavaClass() { return ").append((CharSequence)petm.getJavaClassName()).append((CharSequence)".class; }\n\n");
        iw.append((CharSequence)"@Override\npublic String getTypeName() { return \"").append((CharSequence)this.makeQualifiedTypeName(petm.getFullName())).append((CharSequence)"\"; }\n\n");
        String decodeSrc = this.generateEnumDecodeMethod(petm);
        String decodeSig = "public " + petm.getJavaClassName() + " decode(int $1)";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)decodeSig, (Object)decodeSrc);
        }
        iw.append((CharSequence)"@Override\n").append((CharSequence)decodeSig).append(' ').append((CharSequence)decodeSrc).append('\n');
        String encodeSrc = this.generateEnumEncodeMethod(petm);
        String encodeSig = "public int encode(" + petm.getJavaClassName() + " $1) throws IllegalArgumentException";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)encodeSig, (Object)encodeSrc);
        }
        iw.append((CharSequence)"@Override\n").append((CharSequence)encodeSig).append(' ').append((CharSequence)encodeSrc);
        iw.dec();
        iw.append((CharSequence)"}\n");
        this.writeSourceFile(fqn, iw.toString(), ((HasModelElement)petm.getJavaClass()).getElement());
    }

    private void generateMessageMarshaller(ProtoMessageTypeMetadata pmtm) throws IOException {
        String fqn;
        String marshallerClassName = pmtm.getJavaClass().getSimpleName() + '$' + this.makeUniqueMarshallerClassName();
        if (log.isTraceEnabled()) {
            log.tracef("Generating message marshaller %s for %s", (Object)marshallerClassName, (Object)pmtm.getJavaClass().getName());
        }
        IndentWriter iw = new IndentWriter();
        if (pmtm.getJavaClass().getPackageName() != null) {
            fqn = pmtm.getJavaClass().getPackageName() + '.' + marshallerClassName;
            iw.append((CharSequence)"package ").append((CharSequence)pmtm.getJavaClass().getPackageName()).append((CharSequence)";\n\n");
        } else {
            fqn = marshallerClassName;
        }
        AutoProtoSchemaBuilderAnnotationProcessor.addGeneratedBy(iw);
        iw.append((CharSequence)"public final class ").append((CharSequence)marshallerClassName).append((CharSequence)" extends ").append((CharSequence)GeneratedMarshallerBase.class.getName()).append((CharSequence)" implements ").append((CharSequence)RawProtobufMarshaller.class.getName()).append('<').append((CharSequence)pmtm.getJavaClassName()).append('>').append((CharSequence)" {\n\n");
        iw.inc();
        this.addMarshallerDelegateFields(iw, pmtm);
        iw.append((CharSequence)"@Override\npublic Class<").append((CharSequence)pmtm.getJavaClassName()).append((CharSequence)"> getJavaClass() { return ").append((CharSequence)pmtm.getJavaClassName()).append((CharSequence)".class; }\n\n");
        iw.append((CharSequence)"@Override\npublic String getTypeName() { return \"").append((CharSequence)this.makeQualifiedTypeName(pmtm.getFullName())).append((CharSequence)"\"; }\n\n");
        String readFromSrc = this.generateReadFromMethod(pmtm);
        String readFromSig = "public " + pmtm.getJavaClassName() + " readFrom(" + ImmutableSerializationContext.class.getName() + " $1, " + RawProtoStreamReader.class.getName() + " $2) throws java.io.IOException";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)readFromSig, (Object)readFromSrc);
        }
        iw.append((CharSequence)"@Override\n").append((CharSequence)readFromSig).append(' ').append((CharSequence)readFromSrc).append('\n');
        String writeToSrc = this.generateWriteToMethod(pmtm);
        String writeToSig = "public void writeTo(" + ImmutableSerializationContext.class.getName() + " $1, " + RawProtoStreamWriter.class.getName() + " $2, " + pmtm.getJavaClassName() + " $3) throws java.io.IOException";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)writeToSig, (Object)writeToSrc);
        }
        iw.append((CharSequence)"@Override\n").append((CharSequence)writeToSig).append(' ').append((CharSequence)writeToSrc);
        iw.dec();
        iw.append((CharSequence)"}\n");
        this.writeSourceFile(fqn, iw.toString(), ((HasModelElement)pmtm.getJavaClass()).getElement());
    }

    private void addMarshallerDelegateFields(IndentWriter iw, ProtoMessageTypeMetadata messageTypeMetadata) {
        HashSet<String> addedFields = new HashSet<String>();
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            switch (fieldMetadata.getProtobufType()) {
                case GROUP: 
                case MESSAGE: 
                case ENUM: {
                    String fieldName = this.makeMarshallerDelegateFieldName(fieldMetadata);
                    if (!addedFields.add(fieldName)) break;
                    Class marshallerDelegateClass = fieldMetadata.getJavaType().isEnum() ? EnumMarshallerDelegate.class : BaseMarshallerDelegate.class;
                    iw.append((CharSequence)"private ").append((CharSequence)marshallerDelegateClass.getName()).append(' ').append((CharSequence)fieldName).append((CharSequence)";\n\n");
                }
            }
        }
    }

    private void writeSourceFile(String className, String classSource, Element typeElement) throws IOException {
        JavaFileObject file = this.processingEnv.getFiler().createSourceFile(className, typeElement);
        this.generatedClasses.add(className);
        try (PrintWriter out = new PrintWriter(file.openWriter());){
            out.print(classSource);
        }
    }
}

