/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.integrationtests.processor;

import com.google.common.io.Resources;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.Compiler;
import com.google.testing.compile.JavaFileObjects;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.annotation.processing.Processor;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import org.infinispan.protostream.processor.ProtoSchemaAnnotationProcessor;

public final class CompilationUtils {
    private static final String JAVA_SUFFIX = ".java";

    public static boolean checkFileContainsString(FileObject file, String string) {
        String src;
        if (file == null) {
            throw new IllegalArgumentException("The file argument must not be null");
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("The string argument must not be null or empty");
        }
        try {
            src = file.getCharContent(true).toString();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        return src.contains(string);
    }

    public static Compilation compile(String ... resourceNames) {
        if (resourceNames == null || resourceNames.length == 0) {
            throw new IllegalArgumentException("resourceNames argument must not be null or empty");
        }
        ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>(resourceNames.length);
        for (String resourceName : resourceNames) {
            files.add(CompilationUtils.createJavaFileObject(resourceName));
        }
        return Compiler.javac().withProcessors(new Processor[]{new ProtoSchemaAnnotationProcessor()}).compile(files);
    }

    private static JavaFileObject createJavaFileObject(String resourceName) {
        String source;
        if (!resourceName.endsWith(JAVA_SUFFIX)) {
            throw new IllegalArgumentException("The resource must be a Java source file and the file name must end with '.java' suffix");
        }
        String fullyQualifiedName = resourceName.substring(0, resourceName.length() - JAVA_SUFFIX.length()).replace('/', '.');
        try {
            source = Resources.asByteSource((URL)Resources.getResource((String)resourceName)).asCharSource(StandardCharsets.UTF_8).read();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        return JavaFileObjects.forSourceString((String)fullyQualifiedName, (String)source);
    }
}

