/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.sampledomain;

import java.util.Objects;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.protostream.annotations.ProtoField;

public class Address {
    private String street;
    private String postCode;
    private int number;
    private boolean isCommercial;

    public Address() {
    }

    public Address(String street, String postCode, int number) {
        this(street, postCode, number, false);
    }

    public Address(String street, String postCode, int number, boolean isCommercial) {
        this.street = street;
        this.postCode = postCode;
        this.number = number;
        this.isCommercial = isCommercial;
    }

    @Basic(projectable=true)
    @ProtoField(value=1)
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    @Basic(projectable=true)
    @ProtoField(value=2)
    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    @Basic(projectable=true)
    @ProtoField(value=3, defaultValue="0")
    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    @ProtoField(value=4, defaultValue="false")
    public boolean isCommercial() {
        return this.isCommercial;
    }

    public void setCommercial(boolean isCommercial) {
        this.isCommercial = isCommercial;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.number == address.number && this.isCommercial == address.isCommercial && Objects.equals(this.street, address.street) && Objects.equals(this.postCode, address.postCode);
    }

    public int hashCode() {
        return Objects.hash(this.street, this.postCode, this.number, this.isCommercial);
    }

    public String toString() {
        return "Address{street='" + this.street + "', postCode='" + this.postCode + "', number=" + this.number + ", isCommercial=" + this.isCommercial + "}";
    }
}

