/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.sampledomain;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Embedded;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.sampledomain.Address;

@Indexed
public class User {
    private int id;
    private String name;
    private String surname;
    private String salutation;
    private Set<Integer> accountIds;
    private List<Address> addresses;
    private Integer age;
    private Gender gender;
    private String notes;
    private Instant creationDate;
    private Instant passwordExpirationDate;

    @Basic(projectable=true, sortable=true)
    @ProtoField(number=1, defaultValue="0")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Basic(projectable=true)
    @ProtoField(value=2, collectionImplementation=HashSet.class)
    public Set<Integer> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(Set<Integer> accountIds) {
        this.accountIds = accountIds;
    }

    @Basic(projectable=true, sortable=true)
    @ProtoField(value=3)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Basic(projectable=true, sortable=true, indexNullAs="_null_")
    @ProtoField(value=4)
    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    @Basic(projectable=true, indexNullAs="_null_")
    @ProtoField(value=5)
    public String getSalutation() {
        return this.salutation;
    }

    public void setSalutation(String salutation) {
        this.salutation = salutation;
    }

    @Embedded
    @ProtoField(value=6, collectionImplementation=ArrayList.class)
    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    @Basic(sortable=true, indexNullAs="-1")
    @ProtoField(value=7)
    public Integer getAge() {
        return this.age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    @Basic(projectable=true)
    @ProtoField(value=8)
    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    @ProtoField(value=9)
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Basic(projectable=true, sortable=true, indexNullAs="-1")
    @ProtoField(value=10)
    public Instant getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Instant creationDate) {
        this.creationDate = creationDate;
    }

    @ProtoField(value=11)
    public Instant getPasswordExpirationDate() {
        return this.passwordExpirationDate;
    }

    public void setPasswordExpirationDate(Instant passwordExpirationDate) {
        this.passwordExpirationDate = passwordExpirationDate;
    }

    public String toString() {
        return "User{id=" + this.id + ", name='" + this.name + "', surname='" + this.surname + "', salutation='" + this.salutation + "', accountIds=" + String.valueOf(this.accountIds) + ", addresses=" + String.valueOf(this.addresses) + ", age=" + this.age + ", gender=" + String.valueOf((Object)this.gender) + ", notes=" + this.notes + ", creationDate='" + String.valueOf(this.creationDate) + "', passwordExpirationDate='" + String.valueOf(this.passwordExpirationDate) + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.id == user.id && Objects.equals(this.name, user.name) && Objects.equals(this.surname, user.surname) && Objects.equals(this.salutation, user.salutation) && Objects.equals(this.accountIds, user.accountIds) && Objects.equals(this.addresses, user.addresses) && Objects.equals(this.age, user.age) && this.gender == user.gender && Objects.equals(this.notes, user.notes) && Objects.equals(this.creationDate, user.creationDate) && Objects.equals(this.passwordExpirationDate, user.passwordExpirationDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.surname, this.salutation, this.accountIds, this.addresses, this.age, this.gender, this.notes, this.creationDate, this.passwordExpirationDate});
    }

    public static enum Gender {
        MALE,
        FEMALE;

    }
}

