/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.tasks.admin;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.Server;
import org.infinispan.server.core.admin.AdminServerTask;
import org.infinispan.tasks.TaskExecutionMode;

public class LoggingSetTask
extends AdminServerTask<byte[]> {
    private static final Set<String> PARAMETERS = Stream.of("loggerName", "level", "appenders", "create").collect(Collectors.toSet());

    public String getTaskContextName() {
        return "logging";
    }

    public String getTaskOperationName() {
        return "set";
    }

    public TaskExecutionMode getExecutionMode() {
        return TaskExecutionMode.ALL_NODES;
    }

    public Set<String> getParameters() {
        return PARAMETERS;
    }

    protected byte[] execute(EmbeddedCacheManager cacheManager, Map<String, List<String>> parameters, EnumSet<CacheContainerAdmin.AdminFlag> adminFlags) {
        LoggerConfig loggerConfig;
        Level level;
        SecurityActions.checkPermission((EmbeddedCacheManager)cacheManager, (AuthorizationPermission)AuthorizationPermission.ADMIN);
        String loggerName = this.getParameter(parameters, "loggerName");
        List<String> appenders = parameters.get("appenders");
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        String pLevel = this.getParameter(parameters, "level");
        if (pLevel == null) {
            level = null;
        } else {
            level = Level.getLevel((String)pLevel);
            if (level == null) {
                throw Server.log.invalidLevel(pLevel);
            }
        }
        Configuration configuration = context.getConfiguration();
        LoggerConfig loggerConfig2 = loggerConfig = loggerName == null ? configuration.getRootLogger() : configuration.getLoggerConfig(loggerName);
        if (level == null) {
            level = loggerConfig.getLevel();
        }
        LoggerConfig specificConfig = loggerConfig;
        if (loggerName != null && !loggerConfig.getName().equals(loggerName)) {
            specificConfig = new LoggerConfig(loggerName, level, true);
            specificConfig.setParent(loggerConfig);
            configuration.addLogger(loggerName, specificConfig);
        }
        if (appenders != null) {
            Map rootAppenders = context.getRootLogger().getAppenders();
            Map loggerAppenders = specificConfig.getAppenders();
            loggerAppenders.keySet().removeAll(appenders);
            for (String appender : loggerAppenders.keySet()) {
                specificConfig.removeAppender(appender);
            }
            for (String appender : appenders) {
                Appender app = (Appender)rootAppenders.get(appender);
                if (app != null) {
                    specificConfig.addAppender(app, level, null);
                    continue;
                }
                throw Server.log.unknownAppender(appender);
            }
        }
        specificConfig.setLevel(level);
        context.updateLoggers();
        return null;
    }
}

