/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.function.BiConsumer;

public class Loader {
    public static final String INFINISPAN_SERVER_HOME_PATH = "infinispan.server.home.path";
    public static final String INFINISPAN_SERVER_ROOT_PATH = "infinispan.server.root.path";
    public static final String INFINISPAN_SERVER_LIB_PATH = "infinispan.server.lib.path";
    public static final String DEFAULT_SERVER_ROOT_DIR = "server";

    public static void main(String[] args) {
        Loader.run(args, System.getProperties());
    }

    public static void run(String[] args, Properties properties) {
        String lib;
        if (args.length == 0) {
            System.err.println("You must specify a classname to launch");
        }
        String root = null;
        String propertyFile = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-s".equals(args[i]) && i < args.length - 1) {
                root = args[i + 1];
                break;
            }
            if (args[i].startsWith("--server-root=")) {
                root = args[i].substring(args[i].indexOf(61) + 1);
                break;
            }
            if ("-P".equals(args[i]) && i < args.length - 1) {
                propertyFile = args[i + 1];
                break;
            }
            if (!args[i].startsWith("--properties=")) continue;
            propertyFile = args[i].substring(args[i].indexOf(61) + 1);
            break;
        }
        if (propertyFile != null) {
            try (BufferedReader r = Files.newBufferedReader(Paths.get(propertyFile, new String[0]));){
                Properties loaded = new Properties();
                loaded.load(r);
                loaded.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)properties::putIfAbsent));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        String home = properties.getProperty(INFINISPAN_SERVER_HOME_PATH, properties.getProperty("user.dir"));
        ClassLoader bootClassLoader = Loader.class.getClassLoader();
        ClassLoader serverClassLoader = Loader.classLoaderFromPath(Paths.get(home, "lib"), bootClassLoader);
        if (root == null) {
            root = properties.getProperty(INFINISPAN_SERVER_ROOT_PATH, Paths.get(home, DEFAULT_SERVER_ROOT_DIR).toString());
        }
        if ((lib = properties.getProperty(INFINISPAN_SERVER_LIB_PATH)) != null) {
            for (String item : lib.split(File.pathSeparator)) {
                serverClassLoader = Loader.classLoaderFromPath(Paths.get(item, new String[0]), serverClassLoader);
            }
        } else {
            serverClassLoader = Loader.classLoaderFromPath(Paths.get(root, "lib"), serverClassLoader);
        }
        Thread.currentThread().setContextClassLoader(serverClassLoader);
        try {
            Class<?> mainClass = serverClassLoader.loadClass(args[0]);
            Method mainMethod = mainClass.getMethod("main", String[].class);
            String[] mainArgs = new String[args.length - 1];
            System.arraycopy(args, 1, mainArgs, 0, mainArgs.length);
            mainMethod.invoke(null, new Object[]{mainArgs});
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public static ClassLoader classLoaderFromPath(Path path, ClassLoader parent) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                return parent;
            }
            final LinkedHashMap urls = new LinkedHashMap();
            Files.walkFileTree(path, Collections.singleton(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path p, BasicFileAttributes attrs) throws IOException {
                    urls.put(p.toString(), p.toUri().toURL());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path p, BasicFileAttributes attrs) throws IOException {
                    if (p.toString().endsWith(".jar")) {
                        String artifact = Loader.extractArtifactName(p.getFileName().toString());
                        if (urls.containsKey(artifact)) {
                            throw new IllegalArgumentException("Duplicate JARs:\n" + String.valueOf(p.toAbsolutePath().normalize()) + "\n" + String.valueOf(urls.get(artifact)));
                        }
                        urls.put(artifact, p.toUri().toURL());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path p, IOException exc) {
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path p, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
            URL[] array = urls.values().toArray(new URL[0]);
            if (parent == null) {
                return new URLClassLoader(array);
            }
            return new URLClassLoader(array, parent);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String extractArtifactName(String filename) {
        int l = filename.length();
        for (int i = 0; i < l; ++i) {
            char c = filename.charAt(i);
            if (c != '-' || i >= l - 1 || (c = filename.charAt(i + 1)) < '0' || c > '9') continue;
            return filename.substring(0, i);
        }
        return filename;
    }
}

