/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLContextBuilder;

public class SSLEngineConfiguration
extends ConfigurationElement<SSLEngineConfiguration> {
    static final AttributeDefinition<String[]> ENABLED_PROTOCOLS = AttributeDefinition.builder((Enum)Attribute.ENABLED_PROTOCOLS, null, String[].class).serializer(AttributeSerializer.STRING_ARRAY).immutable().build();
    static final AttributeDefinition<String> ENABLED_CIPHERSUITES = AttributeDefinition.builder((Enum)Attribute.ENABLED_CIPHERSUITES, (Object)"DEFAULT", String.class).immutable().build();
    static final AttributeDefinition<String> ENABLED_CIPHERSUITES_13 = AttributeDefinition.builder((Enum)Attribute.ENABLED_CIPHERSUITES_TLS13, (Object)"TLS_AES_256_GCM_SHA384:TLS_CHACHA20_POLY1305_SHA256:TLS_AES_128_GCM_SHA256", String.class).immutable().build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SSLEngineConfiguration.class, new AttributeDefinition[]{ENABLED_PROTOCOLS, ENABLED_CIPHERSUITES, ENABLED_CIPHERSUITES_13});
    }

    SSLEngineConfiguration(AttributeSet attributes) {
        super((Enum)Element.ENGINE, attributes, new ConfigurationElement[0]);
    }

    void build(SSLContextBuilder builder) {
        this.attributes.attribute(ENABLED_PROTOCOLS).apply(protocols -> {
            ProtocolSelector protocolSelector = ProtocolSelector.empty();
            for (String protocol : protocols) {
                protocolSelector = protocolSelector.add(protocol);
            }
            builder.setProtocolSelector(protocolSelector);
        });
        CipherSuiteSelector cipherSuiteFilter = CipherSuiteSelector.fromString((String)((String)this.attributes.attribute(ENABLED_CIPHERSUITES).get()));
        String cipherSuiteNames = (String)this.attributes.attribute(ENABLED_CIPHERSUITES_13).get();
        builder.setCipherSuiteSelector(CipherSuiteSelector.aggregate((CipherSuiteSelector)(cipherSuiteNames != null ? CipherSuiteSelector.fromNamesString((String)cipherSuiteNames) : null), (CipherSuiteSelector)cipherSuiteFilter));
    }
}

