/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.io.FileWatcher;
import org.infinispan.commons.util.ReloadingX509KeyManager;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.ServerConfigurationSerializer;
import org.infinispan.server.configuration.security.CredentialStoresConfiguration;
import org.infinispan.server.security.KeyStoreUtils;
import org.infinispan.server.security.ServerSecurityRealm;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.keystore.AliasFilter;
import org.wildfly.security.keystore.FilteringKeyStore;
import org.wildfly.security.keystore.KeyStoreUtil;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.ssl.SSLContextBuilder;

public class KeyStoreConfiguration
extends ConfigurationElement<KeyStoreConfiguration> {
    static final AttributeDefinition<String> ALIAS = AttributeDefinition.builder((Enum)Attribute.ALIAS, null, String.class).build();
    static final AttributeDefinition<String> GENERATE_SELF_SIGNED_CERTIFICATE_HOST = AttributeDefinition.builder((Enum)Attribute.GENERATE_SELF_SIGNED_CERTIFICATE_HOST, null, String.class).build();
    @Deprecated(forRemoval=true, since="14.0")
    static final AttributeDefinition<Supplier<CredentialSource>> KEY_PASSWORD = AttributeDefinition.builder((Enum)Attribute.KEY_PASSWORD, null, Supplier.class).serializer((AttributeSerializer)ServerConfigurationSerializer.CREDENTIAL).build();
    static final AttributeDefinition<Supplier<CredentialSource>> KEYSTORE_PASSWORD = AttributeDefinition.builder((Enum)Attribute.PASSWORD, null, Supplier.class).serializer((AttributeSerializer)ServerConfigurationSerializer.CREDENTIAL).build();
    static final AttributeDefinition<String> PATH = AttributeDefinition.builder((Enum)Attribute.PATH, null, String.class).build();
    static final AttributeDefinition<String> RELATIVE_TO = AttributeDefinition.builder((Enum)Attribute.RELATIVE_TO, (Object)"infinispan.server.config.path", String.class).autoPersist(false).build();
    static final AttributeDefinition<String> PROVIDER = AttributeDefinition.builder((Enum)Attribute.PROVIDER, null, String.class).build();
    static final AttributeDefinition<String> TYPE = AttributeDefinition.builder((Enum)Attribute.TYPE, null, String.class).build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(KeyStoreConfiguration.class, new AttributeDefinition[]{ALIAS, GENERATE_SELF_SIGNED_CERTIFICATE_HOST, PATH, RELATIVE_TO, PROVIDER, KEY_PASSWORD, KEYSTORE_PASSWORD, TYPE});
    }

    KeyStoreConfiguration(AttributeSet attributes) {
        super((Enum)Element.KEYSTORE, attributes, new ConfigurationElement[0]);
    }

    public void build(SSLContextBuilder builder, Properties properties, EnumSet<ServerSecurityRealm.Feature> features) {
        if (this.attributes.isModified()) {
            X509ExtendedKeyManager keyManager;
            Provider[] providers = SslContextFactory.discoverSecurityProviders((ClassLoader)Thread.currentThread().getContextClassLoader());
            String providerName = (String)this.attributes.attribute(PROVIDER).get();
            String type = (String)this.attributes.attribute(TYPE).get();
            if (this.attributes.attribute(PATH).isNull()) {
                try {
                    keyManager = this.keyManagerFromStore(KeyStoreUtils.buildFilelessKeyStore(providers, providerName, type), providers, providerName);
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
            } else {
                String keyStoreFileName = ParseUtils.resolvePath((String)((String)this.attributes.attribute(PATH).get()), (String)properties.getProperty((String)this.attributes.attribute(RELATIVE_TO).get()));
                FileWatcher watcher = (FileWatcher)properties.get("infinispan.file.watcher");
                if (watcher == null) {
                    try {
                        keyManager = this.keyManagerFromStore(this.buildKeyStore(providers, properties), providers, providerName);
                    }
                    catch (IOException | GeneralSecurityException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    keyManager = new ReloadingX509KeyManager(watcher, Paths.get(keyStoreFileName, new String[0]), p -> {
                        try {
                            return this.keyManagerFromStore(this.buildKeyStore(providers, properties), providers, providerName);
                        }
                        catch (IOException | GeneralSecurityException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
            }
            builder.setKeyManager(keyManager);
            features.add(ServerSecurityRealm.Feature.ENCRYPT);
        }
    }

    private X509ExtendedKeyManager keyManagerFromStore(KeyStore keyStore, Provider[] providers, String providerName) throws GeneralSecurityException {
        String algorithm = KeyManagerFactory.getDefaultAlgorithm();
        Provider provider = ProviderUtil.findProvider((Provider[])providers, (String)providerName, KeyManagerFactory.class, (String)algorithm);
        KeyManagerFactory keyManagerFactory = provider != null ? KeyManagerFactory.getInstance(algorithm, provider) : KeyManagerFactory.getInstance(algorithm);
        char[] keyStorePassword = CredentialStoresConfiguration.resolvePassword((org.infinispan.commons.configuration.attributes.Attribute<Supplier<CredentialSource>>)this.attributes.attribute(KEYSTORE_PASSWORD));
        char[] keyPassword = CredentialStoresConfiguration.resolvePassword((org.infinispan.commons.configuration.attributes.Attribute<Supplier<CredentialSource>>)this.attributes.attribute(KEY_PASSWORD));
        keyManagerFactory.init(keyStore, keyPassword != null ? keyPassword : keyStorePassword);
        for (KeyManager keyManager : keyManagerFactory.getKeyManagers()) {
            if (!(keyManager instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)keyManager;
        }
        throw Server.log.noDefaultKeyManager();
    }

    private KeyStore buildKeyStore(Provider[] providers, Properties properties) throws GeneralSecurityException, IOException {
        String keyStoreFileName = ParseUtils.resolvePath((String)((String)this.attributes.attribute(PATH).get()), (String)properties.getProperty((String)this.attributes.attribute(RELATIVE_TO).get()));
        String generateSelfSignedHost = (String)this.attributes.attribute(GENERATE_SELF_SIGNED_CERTIFICATE_HOST).get();
        String provider = (String)this.attributes.attribute(PROVIDER).get();
        char[] keyStorePassword = CredentialStoresConfiguration.resolvePassword((org.infinispan.commons.configuration.attributes.Attribute<Supplier<CredentialSource>>)this.attributes.attribute(KEYSTORE_PASSWORD));
        char[] keyPassword = CredentialStoresConfiguration.resolvePassword((org.infinispan.commons.configuration.attributes.Attribute<Supplier<CredentialSource>>)this.attributes.attribute(KEY_PASSWORD));
        String keyAlias = (String)this.attributes.attribute(ALIAS).get();
        if (!new File(keyStoreFileName).exists() && generateSelfSignedHost != null) {
            KeyStoreUtils.generateSelfSignedCertificate(keyStoreFileName, provider, keyStorePassword, keyPassword, keyAlias, generateSelfSignedHost);
        }
        KeyStore keyStore = KeyStoreUtil.loadKeyStore(() -> providers, (String)provider, (FileInputStream)new FileInputStream(keyStoreFileName), (String)keyStoreFileName, (char[])keyStorePassword);
        if (keyAlias != null) {
            if (!keyStore.containsAlias(keyAlias)) {
                throw Server.log.aliasNotInKeystore(keyAlias, keyStoreFileName);
            }
            keyStore = FilteringKeyStore.filteringKeyStore((KeyStore)keyStore, (Predicate)AliasFilter.fromString((String)keyAlias));
        }
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (keyStore.isKeyEntry(alias)) {
                this.verifyCertificateHasSAN((X509Certificate)keyStore.getCertificateChain(alias)[0], keyStoreFileName, alias);
                continue;
            }
            if (!keyStore.isCertificateEntry(alias)) continue;
            this.verifyCertificateHasSAN((X509Certificate)keyStore.getCertificate(alias), keyStoreFileName, alias);
        }
        return keyStore;
    }

    private void verifyCertificateHasSAN(X509Certificate certificate, String keyStoreFileName, String alias) {
        Set<String> critical = certificate.getCriticalExtensionOIDs();
        Set<String> nonCritical = certificate.getNonCriticalExtensionOIDs();
        if (!(critical != null && critical.contains("2.5.29.17") || nonCritical != null && nonCritical.contains("2.5.29.17"))) {
            Server.log.serverCertificateWithoutSAN(keyStoreFileName, alias);
        }
    }
}

