/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.DataSourceConfiguration;
import org.infinispan.server.configuration.DataSourcesConfiguration;
import org.infinispan.server.configuration.InterfaceConfiguration;
import org.infinispan.server.configuration.InterfacesConfiguration;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationSerializer;
import org.infinispan.server.configuration.SocketBindingConfiguration;
import org.infinispan.server.configuration.SocketBindingsConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointsConfiguration;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.configuration.security.ServerTransportConfiguration;

@BuiltBy(value=ServerConfigurationBuilder.class)
@SerializedWith(value=ServerConfigurationSerializer.class, scope=ParserScope.GLOBAL)
public class ServerConfiguration {
    final InterfacesConfiguration interfaces;
    final SocketBindingsConfiguration socketBindings;
    final SecurityConfiguration security;
    final DataSourcesConfiguration dataSources;
    final EndpointsConfiguration endpoints;
    final ServerTransportConfiguration transport;
    private Server server;

    ServerConfiguration(InterfacesConfiguration interfaces, SocketBindingsConfiguration socketBindings, SecurityConfiguration security, DataSourcesConfiguration dataSources, EndpointsConfiguration endpoints, ServerTransportConfiguration transport) {
        this.interfaces = interfaces;
        this.socketBindings = socketBindings;
        this.security = security;
        this.dataSources = dataSources;
        this.endpoints = endpoints;
        this.transport = transport;
    }

    public Map<String, InterfaceConfiguration> networkInterfaces() {
        return this.interfaces.interfaces();
    }

    public Map<String, SocketBindingConfiguration> socketBindings() {
        return this.socketBindings.socketBindings();
    }

    public SecurityConfiguration security() {
        return this.security;
    }

    public Map<String, DataSourceConfiguration> dataSources() {
        return this.dataSources.dataSources().stream().collect(Collectors.toMap(DataSourceConfiguration::name, Function.identity()));
    }

    public EndpointsConfiguration endpoints() {
        return this.endpoints;
    }

    public ServerTransportConfiguration transport() {
        return this.transport;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }
}

