/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.CredentialStoreConfiguration;
import org.infinispan.server.security.PasswordCredentialSource;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

public class CredentialStoresConfiguration
extends ConfigurationElement<CredentialStoresConfiguration> {
    private final Map<String, CredentialStoreConfiguration> credentialStores;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(CredentialStoresConfiguration.class, new AttributeDefinition[0]);
    }

    CredentialStoresConfiguration(AttributeSet attributes, Map<String, CredentialStoreConfiguration> credentialStores, Properties properties) {
        super((Enum)Element.CREDENTIAL_STORES, attributes, new ConfigurationElement[0]);
        attributes.checkProtection();
        this.credentialStores = credentialStores;
        this.init(properties);
    }

    public Map<String, CredentialStoreConfiguration> credentialStores() {
        return this.credentialStores;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CredentialSource getCredentialSource(String store, String alias) {
        CredentialStoreConfiguration credentialStoreConfiguration;
        if (store == null) {
            if (this.credentialStores.size() != 1) throw Server.log.missingCredentialStoreName();
            credentialStoreConfiguration = this.credentialStores.values().iterator().next();
        } else {
            credentialStoreConfiguration = this.credentialStores.get(store);
        }
        if (credentialStoreConfiguration == null) {
            throw Server.log.unknownCredentialStore(store);
        }
        PasswordCredential credential = credentialStoreConfiguration.getCredential(alias, PasswordCredential.class);
        if (credential != null) return new PasswordCredentialSource(credential);
        throw Server.log.unknownCredential(alias, store);
    }

    private void init(Properties properties) {
        for (CredentialStoreConfiguration cs : this.credentialStores.values()) {
            cs.init(properties);
        }
    }

    public static char[] resolvePassword(Attribute<Supplier<CredentialSource>> attribute) {
        return attribute.isNull() ? null : CredentialStoresConfiguration.resolvePassword((Supplier)attribute.get());
    }

    public static char[] resolvePassword(Supplier<CredentialSource> supplier) {
        try {
            CredentialSource credentialSource = supplier.get();
            return ((ClearPassword)((PasswordCredential)credentialSource.getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword();
        }
        catch (IOException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }
}

