/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.KeyStoreConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.SSLConfiguration;
import org.infinispan.server.configuration.security.SSLEngineConfigurationBuilder;
import org.infinispan.server.configuration.security.TrustStoreConfigurationBuilder;

public class SSLConfigurationBuilder
implements Builder<SSLConfiguration> {
    private final KeyStoreConfigurationBuilder keyStore;
    private final TrustStoreConfigurationBuilder trustStore;
    private final SSLEngineConfigurationBuilder engine;

    SSLConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.keyStore = new KeyStoreConfigurationBuilder(realmBuilder);
        this.trustStore = new TrustStoreConfigurationBuilder(realmBuilder);
        this.engine = new SSLEngineConfigurationBuilder(realmBuilder);
    }

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public KeyStoreConfigurationBuilder keyStore() {
        return this.keyStore;
    }

    public TrustStoreConfigurationBuilder trustStore() {
        return this.trustStore;
    }

    public SSLEngineConfigurationBuilder engine() {
        return this.engine;
    }

    public SSLConfiguration create() {
        return new SSLConfiguration(this.keyStore.create(), this.trustStore.create(), this.engine.create());
    }

    public SSLConfigurationBuilder read(SSLConfiguration template, Combine combine) {
        this.keyStore.read(template.keyStore(), combine);
        this.trustStore.read(template.trustStore(), combine);
        this.engine.read(template.engine(), combine);
        return this;
    }
}

