/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.hotrod;

import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationParser;
import org.infinispan.server.core.configuration.EncryptionConfigurationBuilder;
import org.infinispan.server.core.configuration.SaslAuthenticationConfigurationBuilder;
import org.infinispan.server.core.configuration.SniConfigurationBuilder;
import org.infinispan.server.core.security.sasl.SaslAuthenticator;
import org.infinispan.server.hotrod.configuration.Attribute;
import org.infinispan.server.hotrod.configuration.Element;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.security.ElytronSASLAuthenticator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(root="hotrod-connector"), @Namespace(uri="urn:infinispan:server:*", root="hotrod-connector")})
public class HotRodServerConfigurationParser
implements ConfigurationParser {
    private static final Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        if (!holder.inScope("ENDPOINTS")) {
            throw coreLog.invalidScope("ENDPOINTS", holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName((String)reader.getLocalName());
        switch (element) {
            case HOTROD_CONNECTOR: {
                ServerConfigurationBuilder serverBuilder = (ServerConfigurationBuilder)builder.module(ServerConfigurationBuilder.class);
                if (serverBuilder == null) break;
                this.parseHotRodConnector(reader, serverBuilder, serverBuilder.endpoints().current().addConnector(HotRodServerConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseHotRodConnector(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, HotRodServerConfigurationBuilder builder) {
        boolean dedicatedSocketBinding = false;
        String securityRealm = null;
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeName(i));
            switch (attribute) {
                case EXTERNAL_HOST: {
                    builder.proxyHost(value);
                    continue block13;
                }
                case EXTERNAL_PORT: {
                    builder.proxyPort(Integer.parseInt(value));
                    continue block13;
                }
                case NAME: {
                    builder.name(value);
                    continue block13;
                }
                case SOCKET_BINDING: {
                    builder.socketBinding(value);
                    builder.startTransport(true);
                    dedicatedSocketBinding = true;
                    continue block13;
                }
                case SECURITY_REALM: {
                    builder.authentication().securityRealm(value);
                    continue block13;
                }
                case NETWORK_PREFIX_OVERRIDE: {
                    builder.topologyNetworkPrefixOverride(Boolean.parseBoolean(value));
                    continue block13;
                }
                default: {
                    ServerConfigurationParser.parseCommonConnectorAttributes(reader, i, serverBuilder, builder);
                }
            }
        }
        if (!dedicatedSocketBinding) {
            ((HotRodServerConfigurationBuilder)builder.socketBinding(serverBuilder.endpoints().current().singlePort().socketBinding())).startTransport(false);
        }
        block14: while (reader.inTag()) {
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case TOPOLOGY_STATE_TRANSFER: {
                    this.parseTopologyStateTransfer(reader, builder);
                    continue block14;
                }
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, serverBuilder, builder.authentication().enable(), securityRealm);
                    continue block14;
                }
                case ENCRYPTION: {
                    if (!dedicatedSocketBinding) {
                        throw Server.log.cannotConfigureProtocolEncryptionUnderSinglePort();
                    }
                    this.parseEncryption(reader, serverBuilder, builder.encryption(), securityRealm);
                    continue block14;
                }
            }
            ServerConfigurationParser.parseCommonConnectorElements(reader, builder);
        }
    }

    private void parseEncryption(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, EncryptionConfigurationBuilder encryption, String securityRealm) {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeName(i));
            switch (attribute) {
                case REQUIRE_SSL_CLIENT_AUTH: {
                    encryption.requireClientAuth(Boolean.parseBoolean(value));
                    continue block7;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        if (securityRealm == null) {
            throw Server.log.encryptionWithoutSecurityRealm();
        }
        encryption.realm(securityRealm).sslContext(serverBuilder.serverSSLContextSupplier(securityRealm));
        block8: while (reader.inTag((Enum)Element.ENCRYPTION)) {
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SNI: {
                    if (reader.getAttributeCount() <= 0) continue block8;
                    this.parseSni(reader, serverBuilder, encryption.addSni());
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseSni(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, SniConfigurationBuilder sni) {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeName(i));
            switch (attribute) {
                case HOST_NAME: {
                    sni.host(value);
                    continue block4;
                }
                case SECURITY_REALM: {
                    sni.realm(value);
                    sni.sslContext(serverBuilder.serverSSLContextSupplier(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseAuthentication(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, SaslAuthenticationConfigurationBuilder builder, String securityRealm) {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        if (securityRealm == null) {
            securityRealm = serverBuilder.endpoints().current().securityRealm();
        }
        if (securityRealm == null) {
            throw Server.log.authenticationWithoutSecurityRealm();
        }
        builder.sasl().addMechProperty("com.sun.security.sasl.digest.realm", securityRealm);
        String serverPrincipal = null;
        block7: while (reader.inTag()) {
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SASL: {
                    serverPrincipal = ServerConfigurationParser.parseSasl(reader, builder.sasl());
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
        builder.securityRealm(securityRealm);
        builder.sasl().authenticator((SaslAuthenticator)new ElytronSASLAuthenticator(securityRealm, serverPrincipal, builder.sasl().mechanisms()));
    }

    private void parseTopologyStateTransfer(ConfigurationReader reader, HotRodServerConfigurationBuilder builder) {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeName(i));
            switch (attribute) {
                case LOCK_TIMEOUT: {
                    builder.topologyLockTimeout(value);
                    continue block6;
                }
                case AWAIT_INITIAL_RETRIEVAL: {
                    builder.topologyAwaitInitialTransfer(Boolean.parseBoolean(value));
                    continue block6;
                }
                case REPLICATION_TIMEOUT: {
                    builder.topologyReplTimeout(value);
                    continue block6;
                }
                case LAZY_RETRIEVAL: {
                    if (reader.getSchema().since(11, 0)) {
                        Server.log.warnHotRodLazyRetrievalDeprecated();
                    }
                    builder.topologyStateTransfer(!Boolean.parseBoolean(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }
}

