/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.JwtConfiguration;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.security.HostnameVerificationPolicy;
import org.wildfly.security.auth.realm.token.validator.JwtValidator;

public class JwtConfigurationBuilder
implements Builder<JwtConfiguration> {
    private final AttributeSet attributes;
    private final JwtValidator.Builder validatorBuilder = JwtValidator.builder();
    private final RealmConfigurationBuilder realmBuilder;

    JwtConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
        this.attributes = JwtConfiguration.attributeDefinitionSet();
    }

    boolean isChanged() {
        return this.attributes.isModified();
    }

    public JwtConfigurationBuilder audience(String[] audience) {
        this.attributes.attribute(JwtConfiguration.AUDIENCE).set(Arrays.asList(audience));
        this.validatorBuilder.audience(audience);
        return this;
    }

    public JwtConfigurationBuilder clientSSLContext(String value) {
        this.attributes.attribute(JwtConfiguration.CLIENT_SSL_CONTEXT).set((Object)value);
        this.validatorBuilder.useSslContext(this.realmBuilder.realmsBuilder().getSSLContext(value));
        return this;
    }

    public JwtConfigurationBuilder hostNameVerificationPolicy(String value) {
        this.attributes.attribute(JwtConfiguration.HOST_NAME_VERIFICATION_POLICY).set((Object)value);
        HostnameVerifier verifier = HostnameVerificationPolicy.valueOf(value).getVerifier();
        this.validatorBuilder.useSslHostnameVerifier(verifier);
        return this;
    }

    public JwtConfigurationBuilder issuers(String[] issuers) {
        this.attributes.attribute(JwtConfiguration.ISSUER).set(Arrays.asList(issuers));
        this.validatorBuilder.issuer(issuers);
        return this;
    }

    public JwtConfigurationBuilder jkuTimeout(long timeout) {
        this.attributes.attribute(JwtConfiguration.JKU_TIMEOUT).set((Object)timeout);
        this.validatorBuilder.setJkuTimeout(timeout);
        return this;
    }

    public JwtConfigurationBuilder publicKey(String publicKey) {
        this.attributes.attribute(JwtConfiguration.PUBLIC_KEY).set((Object)publicKey);
        this.validatorBuilder.publicKey(publicKey.getBytes(StandardCharsets.UTF_8));
        return this;
    }

    JwtValidator.Builder getValidatorBuilder() {
        return this.validatorBuilder;
    }

    public void validate() {
    }

    public JwtConfiguration create() {
        return new JwtConfiguration(this.attributes.protect());
    }

    public JwtConfigurationBuilder read(JwtConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

