/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.AddressType;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.DataSourceConfigurationBuilder;
import org.infinispan.server.configuration.DataSourcesConfigurationBuilder;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.InterfaceConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.SocketBindingsConfigurationBuilder;
import org.infinispan.server.configuration.endpoint.EndpointsConfigurationBuilder;
import org.infinispan.server.configuration.security.FileSystemRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.GroupsPropertiesConfigurationBuilder;
import org.infinispan.server.configuration.security.JwtConfigurationBuilder;
import org.infinispan.server.configuration.security.KerberosSecurityFactoryConfigurationBuilder;
import org.infinispan.server.configuration.security.KeyStoreConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapAttributeConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapAttributeMappingConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapIdentityMappingConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapUserPasswordMapperConfigurationBuilder;
import org.infinispan.server.configuration.security.LocalRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.OAuth2ConfigurationBuilder;
import org.infinispan.server.configuration.security.PropertiesRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmsConfigurationBuilder;
import org.infinispan.server.configuration.security.SSLConfigurationBuilder;
import org.infinispan.server.configuration.security.SSLEngineConfigurationBuilder;
import org.infinispan.server.configuration.security.ServerIdentitiesConfigurationBuilder;
import org.infinispan.server.configuration.security.TokenRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.TrustStoreRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.UserPropertiesConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.util.RegexNameRewriter;

@Namespaces(value={@Namespace(root="server"), @Namespace(uri="urn:infinispan:server:*", root="server")})
public class ServerConfigurationParser
implements ConfigurationParser {
    private static Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);
    public static String ENDPOINTS_SCOPE = "ENDPOINTS";

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    public static Element nextElement(XMLStreamReader reader) throws XMLStreamException {
        if (reader.nextTag() == 2) {
            return null;
        }
        return Element.forName(reader.getLocalName());
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (!holder.inScope((Enum)ParserScope.GLOBAL)) {
            throw coreLog.invalidScope(ParserScope.GLOBAL.name(), holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case SERVER: {
                ((PrivateGlobalConfigurationBuilder)builder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
                ServerConfigurationBuilder serverConfigurationBuilder = (ServerConfigurationBuilder)builder.addModule(ServerConfigurationBuilder.class);
                this.parseServerElements(reader, holder, serverConfigurationBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseServerElements(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ServerConfigurationBuilder builder) throws XMLStreamException {
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, builder);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.SOCKET_BINDINGS) {
            this.parseSocketBindings(reader, builder);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.SECURITY) {
            this.parseSecurity(reader, builder);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.DATA_SOURCES) {
            this.parseDataSources(reader, builder);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.ENDPOINTS) {
            this.parseEndpoints(reader, holder, builder);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader, (Enum)element);
        }
    }

    private void parseSocketBindings(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        SocketBindingsConfigurationBuilder socketBindings = builder.socketBindings();
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.DEFAULT_INTERFACE, Attribute.PORT_OFFSET});
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    socketBindings.defaultInterface(attributes[0]).offset(Integer.parseInt(attributes[1]));
                    this.parseSocketBinding(reader, socketBindings);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSocketBinding(XMLExtendedStreamReader reader, SocketBindingsConfigurationBuilder builder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.NAME, Attribute.PORT});
        String name = attributes[0];
        int port = Integer.parseInt(attributes[1]);
        String interfaceName = builder.defaultInterface();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: 
                case PORT: {
                    continue block4;
                }
                case INTERFACE: {
                    interfaceName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        builder.socketBinding(name, port, interfaceName);
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseInterfaces(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERFACE: {
                    this.parseInterface(reader, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseInterface(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.NAME});
        String name = attributes[0];
        InterfaceConfigurationBuilder iface = builder.interfaces().addInterface(name);
        boolean matched = false;
        CacheConfigurationException cce = Server.log.invalidNetworkConfiguration();
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            try {
                switch (element) {
                    case INET_ADDRESS: {
                        String value = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.VALUE);
                        ParseUtils.requireNoContent((XMLStreamReader)reader);
                        if (matched) break;
                        iface.address(AddressType.INET_ADDRESS, value);
                        break;
                    }
                    case LINK_LOCAL: {
                        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                        ParseUtils.requireNoContent((XMLStreamReader)reader);
                        if (matched) break;
                        iface.address(AddressType.LINK_LOCAL, null);
                        break;
                    }
                    case GLOBAL: {
                        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                        ParseUtils.requireNoContent((XMLStreamReader)reader);
                        if (matched) break;
                        iface.address(AddressType.GLOBAL, null);
                        break;
                    }
                    case LOOPBACK: {
                        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                        ParseUtils.requireNoContent((XMLStreamReader)reader);
                        if (matched) break;
                        iface.address(AddressType.LOOPBACK, null);
                        break;
                    }
                    case NON_LOOPBACK: {
                        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                        ParseUtils.requireNoContent((XMLStreamReader)reader);
                        if (matched) break;
                        iface.address(AddressType.NON_LOOPBACK, null);
                        break;
                    }
                    case SITE_LOCAL: {
                        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                        ParseUtils.requireNoContent((XMLStreamReader)reader);
                        if (matched) break;
                        iface.address(AddressType.SITE_LOCAL, null);
                        break;
                    }
                    case MATCH_INTERFACE: {
                        String value = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.VALUE);
                        ParseUtils.requireNoContent((XMLStreamReader)reader);
                        if (matched) break;
                        iface.address(AddressType.MATCH_INTERFACE, value);
                        break;
                    }
                    case MATCH_ADDRESS: {
                        String value = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.VALUE);
                        ParseUtils.requireNoContent((XMLStreamReader)reader);
                        if (matched) break;
                        iface.address(AddressType.MATCH_ADDRESS, value);
                        break;
                    }
                    case MATCH_HOST: {
                        String value = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.VALUE);
                        ParseUtils.requireNoContent((XMLStreamReader)reader);
                        if (matched) break;
                        iface.address(AddressType.MATCH_HOST, value);
                        break;
                    }
                    case ANY_ADDRESS: {
                        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
                        ParseUtils.requireNoContent((XMLStreamReader)reader);
                        if (matched) break;
                        iface.address(AddressType.ANY_ADDRESS, null);
                        break;
                    }
                    default: {
                        throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
                    }
                }
                matched = true;
            }
            catch (IOException e) {
                cce.addSuppressed((Throwable)e);
            }
        }
        if (!matched) {
            throw cce;
        }
    }

    private void parseSecurity(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element == Element.SECURITY_REALMS) {
            this.parseSecurityRealms(reader, builder);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader, (Enum)element);
        }
    }

    private void parseSecurityRealms(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        RealmsConfigurationBuilder realms = builder.security().realms();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SECURITY_REALM: {
                    this.parseSecurityRealm(reader, builder, realms);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSecurityRealm(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder, RealmsConfigurationBuilder realms) throws XMLStreamException {
        String name = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.NAME})[0];
        RealmConfigurationBuilder securityRealmBuilder = realms.addSecurityRealm(name);
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element == Element.SERVER_IDENTITIES) {
            this.parseServerIdentities(reader, securityRealmBuilder);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.FILESYSTEM_REALM) {
            this.parseFileSystemRealm(reader, securityRealmBuilder.fileSystemConfiguration());
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.LDAP_REALM) {
            this.parseLdapRealm(reader, securityRealmBuilder.ldapConfiguration());
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.LOCAL_REALM) {
            this.parseLocalRealm(reader, securityRealmBuilder.localConfiguration());
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.PROPERTIES_REALM) {
            this.parsePropertiesRealm(reader, securityRealmBuilder.propertiesRealm());
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.TOKEN_REALM) {
            this.parseTokenRealm(reader, builder, securityRealmBuilder.tokenConfiguration());
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.TRUSTSTORE_REALM) {
            this.parseTrustStoreRealm(reader, securityRealmBuilder.trustStoreConfiguration());
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader, (Enum)element);
        }
    }

    private void parseFileSystemRealm(XMLExtendedStreamReader reader, FileSystemRealmConfigurationBuilder fileRealmBuilder) throws XMLStreamException {
        String name = "filesystem";
        String path = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.PATH})[0];
        fileRealmBuilder.path(path);
        String relativeTo = (String)reader.getProperty("infinispan.server.data.path");
        boolean encoded = true;
        int levels = 0;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    fileRealmBuilder.name(name);
                    continue block7;
                }
                case ENCODED: {
                    encoded = Boolean.parseBoolean(value);
                    fileRealmBuilder.encoded(encoded);
                    continue block7;
                }
                case LEVELS: {
                    levels = Integer.parseInt(value);
                    fileRealmBuilder.levels(levels);
                    continue block7;
                }
                case PATH: {
                    continue block7;
                }
                case RELATIVE_TO: {
                    relativeTo = ParseUtils.requireAttributeProperty((XMLStreamReader)reader, (int)i);
                    fileRealmBuilder.relativeTo(relativeTo);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        fileRealmBuilder.name(name).path(path).relativeTo(relativeTo).levels(levels).encoded(encoded).build();
    }

    private void parseTokenRealm(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder, TokenRealmConfigurationBuilder tokenRealmConfigBuilder) throws XMLStreamException {
        String[] required = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.NAME, Attribute.AUTH_SERVER_URL, Attribute.CLIENT_ID});
        tokenRealmConfigBuilder.name(required[0]).authServerUrl(required[1]).clientId(required[2]);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: 
                case AUTH_SERVER_URL: 
                case CLIENT_ID: {
                    continue block4;
                }
                case PRINCIPAL_CLAIM: {
                    tokenRealmConfigBuilder.principalClaim(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element == Element.JWT) {
            this.parseJWT(reader, serverBuilder, tokenRealmConfigBuilder.jwtConfiguration());
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        } else if (element == Element.OAUTH2_INTROSPECTION) {
            this.parseOauth2Introspection(reader, serverBuilder, tokenRealmConfigBuilder.oauth2Configuration());
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        tokenRealmConfigBuilder.build();
    }

    private void parseJWT(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder, JwtConfigurationBuilder jwtBuilder) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISSUER: {
                    jwtBuilder.issuers(reader.getListAttributeValue(i));
                    continue block8;
                }
                case AUDIENCE: {
                    jwtBuilder.audience(reader.getListAttributeValue(i));
                    continue block8;
                }
                case PUBLIC_KEY: {
                    jwtBuilder.publicKey(value);
                    continue block8;
                }
                case JKU_TIMEOUT: {
                    jwtBuilder.jkuTimeout(Long.parseLong(value));
                    continue block8;
                }
                case CLIENT_SSL_CONTEXT: {
                    jwtBuilder.clientSSLContext(value);
                    continue block8;
                }
                case HOST_NAME_VERIFICATION_POLICY: {
                    jwtBuilder.hostNameVerificationPolicy(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseOauth2Introspection(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder, OAuth2ConfigurationBuilder oauthBuilder) throws XMLStreamException {
        String[] required = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.CLIENT_ID, Attribute.CLIENT_SECRET, Attribute.INTROSPECTION_URL});
        oauthBuilder.clientId(required[0]).clientSecret(required[1]).introspectionUrl(required[2]);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLIENT_ID: 
                case CLIENT_SECRET: 
                case INTROSPECTION_URL: {
                    continue block5;
                }
                case CLIENT_SSL_CONTEXT: {
                    oauthBuilder.clientSSLContext(value);
                    continue block5;
                }
                case HOST_NAME_VERIFICATION_POLICY: {
                    oauthBuilder.hostVerificationPolicy(value);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseLdapRealm(XMLExtendedStreamReader reader, LdapRealmConfigurationBuilder ldapRealmConfigBuilder) throws XMLStreamException {
        ldapRealmConfigBuilder.name("ldap");
        block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    ldapRealmConfigBuilder.name(value);
                    continue block14;
                }
                case URL: {
                    ldapRealmConfigBuilder.url(value);
                    continue block14;
                }
                case PRINCIPAL: {
                    ldapRealmConfigBuilder.principal(value);
                    continue block14;
                }
                case CREDENTIAL: {
                    ldapRealmConfigBuilder.credential(value);
                    continue block14;
                }
                case DIRECT_VERIFICATION: {
                    ldapRealmConfigBuilder.directEvidenceVerification(Boolean.parseBoolean(value));
                    continue block14;
                }
                case PAGE_SIZE: {
                    ldapRealmConfigBuilder.pageSize(Integer.parseInt(value));
                    continue block14;
                }
                case SEARCH_DN: {
                    ldapRealmConfigBuilder.searchDn(value);
                    continue block14;
                }
                case RDN_IDENTIFIER: {
                    ldapRealmConfigBuilder.rdnIdentifier(value);
                    continue block14;
                }
                case CONNECTION_POOLING: {
                    ldapRealmConfigBuilder.connectionPooling(Boolean.parseBoolean(value));
                    continue block14;
                }
                case CONNECTION_TIMEOUT: {
                    ldapRealmConfigBuilder.connectionTimeout(Integer.parseInt(value));
                    continue block14;
                }
                case READ_TIMEOUT: {
                    ldapRealmConfigBuilder.readTimeout(Integer.parseInt(value));
                    continue block14;
                }
                case REFERRAL_MODE: {
                    ldapRealmConfigBuilder.referralMode(DirContextFactory.ReferralMode.valueOf((String)value.toUpperCase()));
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element == Element.NAME_REWRITER) {
            this.parseNameRewriter(reader, ldapRealmConfigBuilder);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        while (element == Element.IDENTITY_MAPPING) {
            this.parseLdapIdentityMapping(reader, ldapRealmConfigBuilder.addIdentityMap());
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        ldapRealmConfigBuilder.build();
    }

    private void parseNameRewriter(XMLExtendedStreamReader reader, LdapRealmConfigurationBuilder builder) throws XMLStreamException {
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        switch (element) {
            case REGEX_PRINCIPAL_TRANSFORMER: {
                String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.NAME, Attribute.PATTERN, Attribute.REPLACEMENT});
                boolean replaceAll = false;
                block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: 
                        case PATTERN: 
                        case REPLACEMENT: {
                            continue block7;
                        }
                        case REPLACE_ALL: {
                            replaceAll = Boolean.parseBoolean(value);
                            continue block7;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                        }
                    }
                }
                builder.nameRewriter((NameRewriter)new RegexNameRewriter(Pattern.compile(attributes[1]), attributes[2], replaceAll));
                ParseUtils.requireNoContent((XMLStreamReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseLdapIdentityMapping(XMLExtendedStreamReader reader, LdapIdentityMappingConfigurationBuilder identityMapBuilder) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SEARCH_DN: {
                    identityMapBuilder.searchBaseDn(value);
                    continue block8;
                }
                case RDN_IDENTIFIER: {
                    identityMapBuilder.rdnIdentifier(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        LdapUserPasswordMapperConfigurationBuilder userMapperBuilder = identityMapBuilder.addUserPasswordMapper();
        LdapAttributeMappingConfigurationBuilder attributeMapperBuilder = identityMapBuilder.addAttributeMapping();
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ATTRIBUTE_MAPPING: {
                    this.parseLdapAttributeMapping(reader, attributeMapperBuilder);
                    continue block9;
                }
                case USER_PASSWORD_MAPPER: {
                    this.parseLdapUserPasswordMapper(reader, userMapperBuilder);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseLdapUserPasswordMapper(XMLExtendedStreamReader reader, LdapUserPasswordMapperConfigurationBuilder userMapperBuilder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FROM: {
                    userMapperBuilder.from(value);
                    continue block5;
                }
                case WRITABLE: {
                    boolean booleanVal = Boolean.parseBoolean(value);
                    userMapperBuilder.writable(booleanVal);
                    continue block5;
                }
                case VERIFIABLE: {
                    boolean booleanVal = Boolean.parseBoolean(value);
                    userMapperBuilder.verifiable(booleanVal);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        userMapperBuilder.build();
    }

    private void parseLdapAttributeMapping(XMLExtendedStreamReader reader, LdapAttributeMappingConfigurationBuilder attributeMapperBuilder) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ATTRIBUTE: {
                    this.parseLdapAttributeFilter(reader, attributeMapperBuilder.addAttribute());
                    continue block4;
                }
                case ATTRIBUTE_REFERENCE: {
                    this.parseLdapAttributeReference(reader, attributeMapperBuilder.addAttribute());
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseLdapAttributeFilter(XMLExtendedStreamReader reader, LdapAttributeConfigurationBuilder attributeBuilder) throws XMLStreamException {
        String filter = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.FILTER})[0];
        this.parseLdapAttribute(reader, attributeBuilder.filter(filter));
    }

    private void parseLdapAttributeReference(XMLExtendedStreamReader reader, LdapAttributeConfigurationBuilder attributeBuilder) throws XMLStreamException {
        String reference = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.REFERENCE})[0];
        this.parseLdapAttribute(reader, attributeBuilder.reference(reference));
    }

    private void parseLdapAttribute(XMLExtendedStreamReader reader, LdapAttributeConfigurationBuilder attributeBuilder) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REFERENCE: 
                case FILTER: {
                    continue block10;
                }
                case FROM: {
                    attributeBuilder.from(value);
                    continue block10;
                }
                case TO: {
                    attributeBuilder.to(value);
                    continue block10;
                }
                case FILTER_DN: {
                    attributeBuilder.filterBaseDn(value);
                    continue block10;
                }
                case SEARCH_RECURSIVE: {
                    attributeBuilder.searchRecursive(Boolean.parseBoolean(value));
                    continue block10;
                }
                case ROLE_RECURSION: {
                    attributeBuilder.roleRecursion(Integer.parseInt(value));
                    continue block10;
                }
                case ROLE_RECURSION_NAME: {
                    attributeBuilder.roleRecursionName(value);
                    continue block10;
                }
                case EXTRACT_RDN: {
                    attributeBuilder.extractRdn(value);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        attributeBuilder.build();
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseLocalRealm(XMLExtendedStreamReader reader, LocalRealmConfigurationBuilder localBuilder) throws XMLStreamException {
        String name = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.NAME})[0];
        localBuilder.name(name);
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parsePropertiesRealm(XMLExtendedStreamReader reader, PropertiesRealmConfigurationBuilder propertiesBuilder) throws XMLStreamException {
        int i;
        String relativeTo;
        String path;
        String name = "properties";
        boolean plainText = false;
        String realmName = name;
        String groupsAttribute = "groups";
        propertiesBuilder.groupAttribute(groupsAttribute);
        UserPropertiesConfigurationBuilder userPropertiesBuilder = propertiesBuilder.userProperties();
        GroupsPropertiesConfigurationBuilder groupsBuilder = propertiesBuilder.groupProperties();
        userPropertiesBuilder.digestRealmName(name).plainText(false);
        block13: for (int i2 = 0; i2 < reader.getAttributeCount(); ++i2) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i2);
            String value = reader.getAttributeValue(i2);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i2));
            switch (attribute) {
                case GROUPS_ATTRIBUTE: {
                    groupsAttribute = value;
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i2);
                }
            }
        }
        propertiesBuilder.groupAttribute(groupsAttribute);
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element == Element.USER_PROPERTIES) {
            path = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.PATH})[0];
            relativeTo = (String)reader.getProperty("infinispan.server.config.path");
            block14: for (i = 0; i < reader.getAttributeCount(); ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case PATH: {
                        continue block14;
                    }
                    case RELATIVE_TO: {
                        relativeTo = ParseUtils.requireAttributeProperty((XMLStreamReader)reader, (int)i);
                        continue block14;
                    }
                    case DIGEST_REALM_NAME: {
                        realmName = value;
                        continue block14;
                    }
                    case PLAIN_TEXT: {
                        plainText = Boolean.parseBoolean(value);
                        continue block14;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                    }
                }
            }
            userPropertiesBuilder.path(path).relativeTo(relativeTo).plainText(plainText).digestRealmName(realmName);
            ParseUtils.requireNoContent((XMLStreamReader)reader);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.GROUP_PROPERTIES) {
            path = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.PATH})[0];
            relativeTo = (String)reader.getProperty("infinispan.server.config.path");
            block15: for (i = 0; i < reader.getAttributeCount(); ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case PATH: {
                        continue block15;
                    }
                    case RELATIVE_TO: {
                        relativeTo = ParseUtils.requireAttributeProperty((XMLStreamReader)reader, (int)i);
                        continue block15;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                    }
                }
            }
            groupsBuilder.path(path).relativeTo(relativeTo);
            ParseUtils.requireNoContent((XMLStreamReader)reader);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader, (Enum)element);
        }
        propertiesBuilder.build();
    }

    private void parseServerIdentities(XMLExtendedStreamReader reader, RealmConfigurationBuilder securityRealmBuilder) throws XMLStreamException {
        ServerIdentitiesConfigurationBuilder identitiesBuilder = securityRealmBuilder.serverIdentitiesConfiguration();
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element == Element.SSL) {
            this.parseSSL(reader, identitiesBuilder);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        while (element == Element.KERBEROS) {
            this.parseKerberos(reader, identitiesBuilder);
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader, (Enum)element);
        }
    }

    private void parseSSL(XMLExtendedStreamReader reader, ServerIdentitiesConfigurationBuilder identitiesBuilder) throws XMLStreamException {
        SSLConfigurationBuilder serverIdentitiesBuilder = identitiesBuilder.addSslConfiguration();
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element == Element.KEYSTORE) {
            this.parseKeyStore(reader, serverIdentitiesBuilder.keyStore());
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element == Element.ENGINE) {
            this.parseSSLEngine(reader, serverIdentitiesBuilder.engine());
            element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader, (Enum)element);
        }
    }

    private void parseSSLEngine(XMLExtendedStreamReader reader, SSLEngineConfigurationBuilder engine) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED_PROTOCOLS: {
                    engine.enabledProtocols(reader.getListAttributeValue(i));
                    continue block4;
                }
                case ENABLED_CIPHERSUITES: {
                    engine.enabledCiphersuites(reader.getAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseKeyStore(XMLExtendedStreamReader reader, KeyStoreConfigurationBuilder keyStoreBuilder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.PATH});
        keyStoreBuilder.path(attributes[0]);
        String relativeTo = (String)reader.getProperty("infinispan.server.config.path");
        keyStoreBuilder.relativeTo(relativeTo);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    continue block9;
                }
                case PROVIDER: {
                    keyStoreBuilder.provider(value);
                    continue block9;
                }
                case RELATIVE_TO: {
                    relativeTo = ParseUtils.requireAttributeProperty((XMLStreamReader)reader, (int)i);
                    keyStoreBuilder.relativeTo(relativeTo);
                    continue block9;
                }
                case KEYSTORE_PASSWORD: {
                    keyStoreBuilder.keyStorePassword(value.toCharArray());
                    continue block9;
                }
                case ALIAS: {
                    keyStoreBuilder.alias(value);
                    continue block9;
                }
                case KEY_PASSWORD: {
                    keyStoreBuilder.keyPassword(value.toCharArray());
                    continue block9;
                }
                case GENERATE_SELF_SIGNED_CERTIFICATE_HOST: {
                    keyStoreBuilder.generateSelfSignedCertificateHost(value);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        keyStoreBuilder.build();
    }

    private void parseTrustStoreRealm(XMLExtendedStreamReader reader, TrustStoreRealmConfigurationBuilder trustStoreBuilder) throws XMLStreamException {
        String name = "trust";
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.PATH});
        String path = attributes[0];
        String relativeTo = (String)reader.getProperty("infinispan.server.config.path");
        String keyStoreProvider = null;
        char[] keyStorePassword = null;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                case PATH: {
                    continue block7;
                }
                case PROVIDER: {
                    keyStoreProvider = value;
                    continue block7;
                }
                case KEYSTORE_PASSWORD: {
                    keyStorePassword = value.toCharArray();
                    continue block7;
                }
                case RELATIVE_TO: {
                    relativeTo = ParseUtils.requireAttributeProperty((XMLStreamReader)reader, (int)i);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        trustStoreBuilder.name(name).path(path).relativeTo(relativeTo).keyStorePassword(keyStorePassword).provider(keyStoreProvider);
        ParseUtils.requireNoContent((XMLStreamReader)reader);
        trustStoreBuilder.build();
    }

    private void parseKerberos(XMLExtendedStreamReader reader, ServerIdentitiesConfigurationBuilder identitiesBuilder) throws XMLStreamException {
        KerberosSecurityFactoryConfigurationBuilder builder = identitiesBuilder.addKerberosConfiguration();
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.KEYTAB_PATH, Attribute.PRINCIPAL});
        builder.keyTabPath(attributes[0]).relativeTo((String)reader.getProperty("infinispan.server.config.path"));
        builder.principal(attributes[1]);
        block17: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PRINCIPAL: 
                case KEYTAB_PATH: {
                    continue block17;
                }
                case RELATIVE_TO: {
                    builder.relativeTo(ParseUtils.requireAttributeProperty((XMLStreamReader)reader, (int)i));
                    continue block17;
                }
                case DEBUG: {
                    builder.debug(Boolean.parseBoolean(value));
                    continue block17;
                }
                case FAIL_CACHE: {
                    builder.failCache(Long.parseLong(value));
                    continue block17;
                }
                case MECHANISM_NAMES: {
                    for (String name : ParseUtils.getListAttributeValue((String)value)) {
                        builder.addMechanismName(name);
                    }
                    continue block17;
                }
                case MECHANISM_OIDS: {
                    for (String oid : ParseUtils.getListAttributeValue((String)value)) {
                        builder.addMechanismOid(oid);
                    }
                    continue block17;
                }
                case MINIMUM_REMAINING_LIFETIME: {
                    builder.minimumRemainingLifetime(Integer.parseInt(value));
                    continue block17;
                }
                case OBTAIN_KERBEROS_TICKET: {
                    builder.obtainKerberosTicket(Boolean.parseBoolean(value));
                    continue block17;
                }
                case REQUEST_LIFETIME: {
                    builder.requestLifetime(Integer.parseInt(value));
                    continue block17;
                }
                case REQUIRED: {
                    builder.checkKeyTab(Boolean.parseBoolean(value));
                    continue block17;
                }
                case SERVER: {
                    builder.server(Boolean.parseBoolean(value));
                    continue block17;
                }
                case WRAP_GSS_CREDENTIAL: {
                    builder.wrapGssCredential(Boolean.parseBoolean(value));
                    continue block17;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block20: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case OPTION: {
                    String[] option = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.NAME, Attribute.VALUE});
                    builder.addOption(option[0], option[1]);
                    continue block20;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseDataSources(XMLExtendedStreamReader reader, ServerConfigurationBuilder builder) throws XMLStreamException {
        DataSourcesConfigurationBuilder dataSources = builder.dataSources();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DATA_SOURCE: {
                    this.parseDataSource(reader, dataSources);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseDataSource(XMLExtendedStreamReader reader, DataSourcesConfigurationBuilder dataSourcesBuilder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.NAME, Attribute.JNDI_NAME});
        String name = attributes[0];
        String jndiName = attributes[1];
        DataSourceConfigurationBuilder dataSourceBuilder = dataSourcesBuilder.dataSource(name, jndiName);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: 
                case JNDI_NAME: {
                    continue block4;
                }
                case STATISTICS: {
                    dataSourceBuilder.statistics(Boolean.parseBoolean(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        Element element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element != Element.CONNECTION_FACTORY) {
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader, (Enum)element);
        }
        this.parseDataSourceConnectionFactory(reader, dataSourceBuilder);
        element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element != Element.CONNECTION_POOL) {
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader, (Enum)element);
        }
        this.parseDataSourceConnectionPool(reader, dataSourceBuilder);
        element = ServerConfigurationParser.nextElement((XMLStreamReader)reader);
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader, (Enum)element);
        }
    }

    private void parseDataSourceConnectionFactory(XMLExtendedStreamReader reader, DataSourceConfigurationBuilder dataSourceBuilder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.DRIVER});
        dataSourceBuilder.driver(attributes[0]);
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DRIVER: {
                    continue block11;
                }
                case USERNAME: {
                    dataSourceBuilder.username(value);
                    continue block11;
                }
                case PASSWORD: {
                    dataSourceBuilder.password(value);
                    continue block11;
                }
                case URL: {
                    dataSourceBuilder.url(value);
                    continue block11;
                }
                case TRANSACTION_ISOLATION: {
                    dataSourceBuilder.transactionIsolation(AgroalConnectionFactoryConfiguration.TransactionIsolation.valueOf((String)value));
                    continue block11;
                }
                case NEW_CONNECTION_SQL: {
                    dataSourceBuilder.newConnectionSql(value);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTION_PROPERTY: {
                    dataSourceBuilder.addProperty(ParseUtils.requireSingleAttribute((XMLStreamReader)reader, (Enum)Attribute.NAME), reader.getElementText());
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseDataSourceConnectionPool(XMLExtendedStreamReader reader, DataSourceConfigurationBuilder dataSourceBuilder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.MAX_SIZE});
        dataSourceBuilder.maxSize(Integer.parseInt(attributes[0]));
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_SIZE: {
                    continue block9;
                }
                case MIN_SIZE: {
                    dataSourceBuilder.minSize(Integer.parseInt(value));
                    continue block9;
                }
                case INITIAL_SIZE: {
                    dataSourceBuilder.initialSize(Integer.parseInt(value));
                    continue block9;
                }
                case BLOCKING_TIMEOUT: {
                    dataSourceBuilder.blockingTimeout(Integer.parseInt(value));
                    continue block9;
                }
                case BACKGROUND_VALIDATION: {
                    dataSourceBuilder.backgroundValidation(Long.parseLong(value));
                    continue block9;
                }
                case LEAK_DETECTION: {
                    dataSourceBuilder.leakDetection(Long.parseLong(value));
                    continue block9;
                }
                case IDLE_REMOVAL: {
                    dataSourceBuilder.idleRemoval(Integer.parseInt(value));
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseEndpoints(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ServerConfigurationBuilder builder) throws XMLStreamException {
        EndpointsConfigurationBuilder endpoints = builder.endpoints();
        holder.pushScope(ENDPOINTS_SCOPE);
        String socketBinding = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.SOCKET_BINDING})[0];
        endpoints.socketBinding(socketBinding);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case SOCKET_BINDING: {
                    continue block4;
                }
                case SECURITY_REALM: {
                    endpoints.securityRealm(value).implicitConnectorSecurity(reader.getSchema().since(11, 0));
                }
                default: {
                    ServerConfigurationParser.parseCommonConnectorAttributes(reader, i, builder, builder.endpoint());
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            reader.handleAny(holder);
        }
        holder.popScope();
    }

    public static void parseCommonConnectorAttributes(XMLExtendedStreamReader reader, int index, ServerConfigurationBuilder serverBuilder, ProtocolServerConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        if (ParseUtils.isNoNamespaceAttribute((XMLStreamReader)reader, (int)index)) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(index));
            String value = reader.getAttributeValue(index);
            switch (attribute) {
                case CACHE_CONTAINER: {
                    break;
                }
                case IDLE_TIMEOUT: {
                    builder.idleTimeout(Integer.parseInt(value));
                    break;
                }
                case IO_THREADS: {
                    builder.ioThreads(Integer.parseInt(value));
                    break;
                }
                case RECEIVE_BUFFER_SIZE: {
                    builder.recvBufSize(Integer.parseInt(value));
                    break;
                }
                case REQUIRE_SSL_CLIENT_AUTH: {
                    builder.ssl().requireClientAuth(Boolean.parseBoolean(value));
                    break;
                }
                case SECURITY_REALM: {
                    if (!serverBuilder.hasSSLContext(value)) break;
                    builder.ssl().enable().sslContext(serverBuilder.getSSLContext(value));
                    break;
                }
                case SEND_BUFFER_SIZE: {
                    builder.sendBufSize(Integer.parseInt(value));
                    break;
                }
                case TCP_KEEPALIVE: {
                    builder.tcpKeepAlive(Boolean.parseBoolean(value));
                    break;
                }
                case TCP_NODELAY: {
                    builder.tcpNoDelay(Boolean.parseBoolean(value));
                    break;
                }
                case WORKER_THREADS: {
                    builder.workerThreads(Integer.parseInt(value));
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)index);
                }
            }
        }
    }
}

