/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.DataSourceConfiguration;
import org.infinispan.server.configuration.DataSourcesConfiguration;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.InterfacesConfiguration;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.SocketBindingConfiguration;
import org.infinispan.server.configuration.SocketBindingsConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointsConfiguration;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.network.SocketBinding;

@BuiltBy(value=ServerConfigurationBuilder.class)
public class ServerConfiguration
implements ConfigurationInfo {
    private final InterfacesConfiguration interfaces;
    private final SocketBindingsConfiguration socketBindings;
    private final SecurityConfiguration security;
    private final DataSourcesConfiguration dataSources;
    private final EndpointsConfiguration endpoints;
    private Server server;
    private final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.SERVER.toString(), true, false);
    private final List<ConfigurationInfo> elements = new ArrayList<ConfigurationInfo>();

    ServerConfiguration(InterfacesConfiguration interfaces, SocketBindingsConfiguration socketBindings, SecurityConfiguration security, DataSourcesConfiguration dataSources, EndpointsConfiguration endpoints) {
        this.interfaces = interfaces;
        this.socketBindings = socketBindings;
        this.security = security;
        this.dataSources = dataSources;
        this.endpoints = endpoints;
        this.elements.add(interfaces);
        this.elements.add(socketBindings);
        this.elements.add(security);
        this.elements.add(dataSources);
        this.elements.add(endpoints);
    }

    public ElementDefinition getElementDefinition() {
        return this.ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.elements;
    }

    public Map<String, NetworkAddress> networkInterfaces() {
        return this.interfaces.getAddressMap();
    }

    public Map<String, SocketBinding> socketBindings() {
        return this.socketBindings.socketBindings().stream().collect(Collectors.toMap(SocketBindingConfiguration::name, SocketBindingConfiguration::getSocketBinding));
    }

    public SecurityConfiguration security() {
        return this.security;
    }

    public Map<String, DataSourceConfiguration> dataSources() {
        return this.dataSources.dataSources().stream().collect(Collectors.toMap(DataSourceConfiguration::name, Function.identity()));
    }

    public EndpointsConfiguration endpoints() {
        return this.endpoints;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }
}

