/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.DataSourceConfiguration;
import org.infinispan.server.configuration.DataSourceConfigurationBuilder;
import org.infinispan.server.configuration.DataSourcesConfiguration;
import org.infinispan.server.configuration.ServerConfigurationBuilder;

public class DataSourcesConfigurationBuilder
implements Builder<DataSourcesConfiguration> {
    private final AttributeSet attributes;
    private final ServerConfigurationBuilder server;
    private final Map<String, DataSourceConfigurationBuilder> dataSources = new LinkedHashMap<String, DataSourceConfigurationBuilder>(2);
    private final Set<String> jndiNames = new HashSet<String>(2);

    DataSourcesConfigurationBuilder(ServerConfigurationBuilder server) {
        this.server = server;
        this.attributes = DataSourcesConfiguration.attributeDefinitionSet();
    }

    DataSourceConfigurationBuilder dataSource(String name, String jndiName) {
        if (this.dataSources.containsKey(name)) {
            throw Server.log.duplicateDataSource(name);
        }
        if (this.jndiNames.contains(jndiName)) {
            throw Server.log.duplicateJndiName(jndiName);
        }
        DataSourceConfigurationBuilder builder = new DataSourceConfigurationBuilder(this.server, name, jndiName);
        this.dataSources.put(name, builder);
        this.jndiNames.add(jndiName);
        return builder;
    }

    public void validate() {
    }

    public DataSourcesConfiguration create() {
        List<DataSourceConfiguration> list = this.dataSources.values().stream().map(DataSourceConfigurationBuilder::create).collect(Collectors.toList());
        return new DataSourcesConfiguration(this.attributes.protect(), list);
    }

    public DataSourcesConfigurationBuilder read(DataSourcesConfiguration template) {
        this.attributes.read(template.attributes());
        this.dataSources.clear();
        return this;
    }
}

