/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing.aggregator;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.query.remote.impl.indexing.IndexingMessageContext;
import org.infinispan.query.remote.impl.indexing.aggregator.TypeAggregator;

public class BigDecimalAggregator
implements TypeAggregator {
    private final IndexFieldReference<?> fieldReference;
    private byte[] unscaledValue;
    private int scale;

    public BigDecimalAggregator(IndexFieldReference<?> fieldReference) {
        this.fieldReference = fieldReference;
    }

    @Override
    public void add(FieldDescriptor fieldDescriptor, Object tagValue) {
        if (Type.BYTES.equals((Object)fieldDescriptor.getType())) {
            this.unscaledValue = (byte[])tagValue;
        } else if (Type.INT32.equals((Object)fieldDescriptor.getType())) {
            this.scale = (Integer)tagValue;
        }
    }

    @Override
    public void addValue(IndexingMessageContext document) {
        if (this.unscaledValue != null) {
            document.addValue(this.fieldReference, new BigDecimal(new BigInteger(this.unscaledValue), this.scale));
        }
    }
}

