/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.logging.processor.report;

import java.io.BufferedWriter;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.logging.annotations.Description;
import org.infinispan.logging.processor.report.IndentingXmlWriter;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

public class XmlReportWriter
implements AutoCloseable {
    private final XMLStreamWriter xmlWriter;

    public XmlReportWriter(BufferedWriter writer) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.xmlWriter = new IndentingXmlWriter(factory.createXMLStreamWriter(writer));
    }

    public void writeHeader(String title) throws XMLStreamException {
        this.xmlWriter.writeStartDocument();
        this.xmlWriter.writeStartElement("report");
        if (title != null) {
            this.xmlWriter.writeAttribute("class", title);
        }
        this.xmlWriter.writeComment("DescriptionDocumentation");
        this.xmlWriter.writeStartElement("logs");
    }

    public void writeDetail(Element element) throws XMLStreamException {
        MessageLogger messageLogger = element.getEnclosingElement().getAnnotation(MessageLogger.class);
        if (messageLogger == null || messageLogger.projectCode().isEmpty()) {
            return;
        }
        Description description = element.getAnnotation(Description.class);
        Message message = element.getAnnotation(Message.class);
        LogMessage logMessage = element.getAnnotation(LogMessage.class);
        String strMsgId = String.valueOf(message.id());
        int padding = messageLogger.length() - strMsgId.length();
        String prjCode = messageLogger.projectCode() + "0".repeat(Math.max(0, padding)) + strMsgId;
        this.xmlWriter.writeStartElement("log");
        this.writeCharacters("id", prjCode);
        this.writeCharacters("message", message.value());
        if (description != null) {
            this.writeCharacters("description", description.value());
        }
        this.writeCharacters("level", logMessage == null ? "EXCEPTION" : logMessage.level().name());
        this.xmlWriter.writeEndElement();
    }

    private void writeCharacters(String elementName, String elementValue) throws XMLStreamException {
        this.xmlWriter.writeStartElement(elementName);
        this.xmlWriter.writeCharacters(elementValue);
        this.xmlWriter.writeEndElement();
    }

    public void writeFooter() throws XMLStreamException {
        this.xmlWriter.writeEndElement();
        this.xmlWriter.writeEndElement();
        this.xmlWriter.writeEndDocument();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.xmlWriter != null) {
                this.xmlWriter.close();
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }
}

