/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.marshall.protostream.impl.MarshallableArray;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.BlockingManager;

@ProtoTypeId(value=7703)
public class EndInvalidationCommand
extends BaseRpcCommand {
    private final Object[] keys;
    private final Object lockOwner;

    public EndInvalidationCommand(ByteString cacheName, Object[] keys, Object lockOwner) {
        super(cacheName);
        this.keys = keys;
        this.lockOwner = lockOwner;
    }

    @ProtoFactory
    EndInvalidationCommand(ByteString cacheName, MarshallableArray<Object> keys, MarshallableObject<Object> lockOwner) {
        this(cacheName, MarshallableArray.unwrap(keys), MarshallableObject.unwrap(lockOwner));
    }

    @ProtoField(value=2)
    MarshallableArray<Object> getKeys() {
        return MarshallableArray.create((Object[])this.keys);
    }

    @ProtoField(value=3)
    MarshallableObject<Object> getLockOwner() {
        return MarshallableObject.create((Object)this.lockOwner);
    }

    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) {
        BlockingManager bm = (BlockingManager)componentRegistry.getGlobalComponentRegistry().getComponent(BlockingManager.class);
        PutFromLoadValidator putFromLoadValidator = (PutFromLoadValidator)componentRegistry.getComponent(PutFromLoadValidator.class);
        return bm.runBlocking(() -> {
            for (Object key : this.keys) {
                putFromLoadValidator.endInvalidatingKey(this.lockOwner, key);
            }
        }, (Object)"end-invalidation");
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EndInvalidationCommand that = (EndInvalidationCommand)((Object)o);
        return Objects.deepEquals(this.keys, that.keys) && Objects.equals(this.lockOwner, that.lockOwner) && Objects.equals(this.cacheName, that.cacheName);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.keys), this.lockOwner, this.cacheName);
    }

    public boolean isReturnValueExpected() {
        return false;
    }

    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "EndInvalidationCommand{cacheName=" + String.valueOf(this.cacheName) + ", keys=" + Arrays.toString(this.keys) + ", sessionTransactionId=" + String.valueOf(this.lockOwner) + "}";
    }
}

