/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.util.CompletableFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=7704)
public class Tombstone
implements Function<EntryView.ReadWriteEntryView<Object, Object>, Void>,
InjectableComponent,
CompletableFunction {
    public static final ExcludeTombstonesFilter EXCLUDE_TOMBSTONES = new ExcludeTombstonesFilter();
    @ProtoField(value=1)
    final long[] data;
    private transient InfinispanDataRegion region;
    private transient boolean complete;

    public Tombstone(UUID uuid, long timestamp) {
        this.data = new long[]{timestamp, uuid.getLeastSignificantBits(), uuid.getMostSignificantBits()};
    }

    @ProtoFactory
    Tombstone(long[] data) {
        this.data = data;
    }

    public long getLastTimestamp() {
        long max = this.data[0];
        for (int i = 3; i < this.data.length; i += 3) {
            max = Math.max(max, this.data[i]);
        }
        return max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Tombstone{");
        for (int i = 0; i < this.data.length; i += 3) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(new UUID(this.data[i + 2], this.data[i + 1])).append('=').append(this.data[i]);
        }
        sb.append('}');
        return sb.toString();
    }

    public Tombstone merge(Tombstone update) {
        assert (update != null);
        assert (update.data.length == 3);
        int toRemove = 0;
        for (int i = 0; i < this.data.length; i += 3) {
            if (this.data[i] < update.data[0]) {
                toRemove += 3;
                continue;
            }
            if (update.data[1] != this.data[i + 1] || update.data[2] != this.data[i + 2]) continue;
            toRemove += 3;
        }
        if (this.data.length == toRemove) {
            return update;
        }
        long[] newData = new long[this.data.length - toRemove + 3];
        int j = 0;
        boolean uuidMatch = false;
        for (int i = 0; i < this.data.length; i += 3) {
            if (this.data[i] < update.data[0]) continue;
            if (update.data[1] == this.data[i + 1] && update.data[2] == this.data[i + 2]) {
                System.arraycopy(update.data, 0, newData, j, 3);
                uuidMatch = true;
                j += 3;
                continue;
            }
            System.arraycopy(this.data, i, newData, j, 3);
            j += 3;
        }
        assert (uuidMatch && j == newData.length || !uuidMatch && j == newData.length - 3);
        if (!uuidMatch) {
            System.arraycopy(update.data, 0, newData, j, 3);
        }
        return new Tombstone(newData);
    }

    public Object applyUpdate(UUID uuid, long timestamp, Object value) {
        int toRemove = 0;
        for (int i = 0; i < this.data.length; i += 3) {
            if (this.data[i] < timestamp) {
                toRemove += 3;
                continue;
            }
            if (uuid.getLeastSignificantBits() != this.data[i + 1] || uuid.getMostSignificantBits() != this.data[i + 2]) continue;
            toRemove += 3;
        }
        if (this.data.length == toRemove) {
            if (value == null) {
                return new Tombstone(uuid, timestamp);
            }
            return value;
        }
        long[] newData = new long[this.data.length - toRemove + 3];
        int j = 0;
        boolean uuidMatch = false;
        for (int i = 0; i < this.data.length; i += 3) {
            if (this.data[i] < timestamp) continue;
            if (uuid.getLeastSignificantBits() == this.data[i + 1] && uuid.getMostSignificantBits() == this.data[i + 2]) {
                newData[j] = timestamp;
                newData[j + 1] = uuid.getLeastSignificantBits();
                newData[j + 2] = uuid.getMostSignificantBits();
                uuidMatch = true;
                j += 3;
                continue;
            }
            System.arraycopy(this.data, i, newData, j, 3);
            j += 3;
        }
        assert (uuidMatch && j == newData.length || !uuidMatch && j == newData.length - 3);
        if (!uuidMatch) {
            newData[j] = timestamp;
            newData[j + 1] = uuid.getLeastSignificantBits();
            newData[j + 2] = uuid.getMostSignificantBits();
        }
        return new Tombstone(newData);
    }

    public int size() {
        return this.data.length / 3;
    }

    @Override
    public Void apply(EntryView.ReadWriteEntryView<Object, Object> view) {
        Object storedValue = view.find().orElse(null);
        MetaParam.MetaLifespan expiringMetaParam = this.region.getExpiringMetaParam();
        if (storedValue instanceof Tombstone) {
            view.set((Object)((Tombstone)storedValue).merge(this), new MetaParam.Writable[]{expiringMetaParam});
        } else {
            view.set((Object)this, new MetaParam.Writable[]{expiringMetaParam});
        }
        return null;
    }

    public void inject(ComponentRegistry registry) {
        this.region = (InfinispanDataRegion)registry.getComponent(InfinispanDataRegion.class);
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void markComplete() {
        this.complete = true;
    }

    @ProtoTypeId(value=7705)
    public static class ExcludeTombstonesFilter
    implements Predicate<Map.Entry<Object, Object>> {
        @ProtoFactory
        ExcludeTombstonesFilter() {
        }

        @Override
        public boolean test(Map.Entry<Object, Object> entry) {
            return !(entry.getValue() instanceof Tombstone);
        }
    }
}

