/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.util.UUID;
import java.util.function.Function;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.util.Tombstone;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=7706)
public class TombstoneUpdate<T>
implements Function<EntryView.ReadWriteEntryView<Object, Object>, Void>,
InjectableComponent {
    private static final UUID ZERO = new UUID(0L, 0L);
    private final long timestamp;
    private final T value;
    private transient InfinispanDataRegion region;

    public TombstoneUpdate(long timestamp, T value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    @ProtoFactory
    TombstoneUpdate(long timestamp, MarshallableObject<T> wrappedValue) {
        this(timestamp, MarshallableObject.unwrap(wrappedValue));
    }

    @ProtoField(value=1)
    public long getTimestamp() {
        return this.timestamp;
    }

    public T getValue() {
        return this.value;
    }

    @ProtoField(number=2, name="value")
    MarshallableObject<T> getWrappedValue() {
        return MarshallableObject.create(this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TombstoneUpdate{");
        sb.append("timestamp=").append(this.timestamp);
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Void apply(EntryView.ReadWriteEntryView<Object, Object> view) {
        Object storedValue = view.find().orElse(null);
        if (this.value == null) {
            if (storedValue != null && !(storedValue instanceof Tombstone)) {
                view.set((Object)new Tombstone(ZERO, this.timestamp), new MetaParam.Writable[]{this.region.getExpiringMetaParam()});
            }
        } else if (storedValue instanceof Tombstone) {
            Tombstone tombstone = storedValue;
            if (tombstone.getLastTimestamp() < this.timestamp) {
                view.set(this.value, new MetaParam.Writable[0]);
            }
        } else if (storedValue == null) {
            if (this.region.getLastRegionInvalidation() < this.timestamp) {
                view.set(this.value, new MetaParam.Writable[0]);
            }
        } else {
            view.set(storedValue, new MetaParam.Writable[]{(MetaParam.Writable)view.findMetaParam(MetaParam.MetaLifespan.class).get()});
        }
        return null;
    }

    public void inject(ComponentRegistry registry) {
        this.region = (InfinispanDataRegion)registry.getComponent(InfinispanDataRegion.class);
    }
}

