/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.util.UUID;
import java.util.function.Function;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.util.Tombstone;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=7701)
public class FutureUpdate
implements Function<EntryView.ReadWriteEntryView<Object, Object>, Void>,
InjectableComponent {
    private final UUID uuid;
    private final long timestamp;
    private final Object value;
    private transient InfinispanDataRegion region;

    public FutureUpdate(UUID uuid, long timestamp, Object value) {
        this.uuid = uuid;
        this.timestamp = timestamp;
        this.value = value;
    }

    @ProtoFactory
    FutureUpdate(UUID uuid, long timestamp, MarshallableObject<?> value) {
        this(uuid, timestamp, MarshallableObject.unwrap(value));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FutureUpdate{");
        sb.append("uuid=").append(this.uuid);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    @ProtoField(value=1)
    public UUID getUuid() {
        return this.uuid;
    }

    @ProtoField(value=2)
    public long getTimestamp() {
        return this.timestamp;
    }

    @ProtoField(value=3)
    public MarshallableObject<?> getValue() {
        return MarshallableObject.create((Object)this.value);
    }

    @Override
    public Void apply(EntryView.ReadWriteEntryView<Object, Object> view) {
        Object storedValue = view.find().orElse(null);
        if (storedValue instanceof Tombstone) {
            Tombstone tombstone = storedValue;
            Object result = tombstone.applyUpdate(this.uuid, this.timestamp, this.value);
            if (result instanceof Tombstone) {
                view.set(result, new MetaParam.Writable[]{this.region.getExpiringMetaParam()});
            } else {
                view.set(result, new MetaParam.Writable[0]);
            }
        }
        return null;
    }

    public void inject(ComponentRegistry registry) {
        this.region = (InfinispanDataRegion)registry.getComponent(InfinispanDataRegion.class);
    }
}

