/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.hibernate.cache.commons.access.BaseInvalidationInterceptor;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class TxInvalidationInterceptor
extends BaseInvalidationInterceptor {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(TxInvalidationInterceptor.class);
    private static final Log ispnLog = LogFactory.getLog(TxInvalidationInterceptor.class);
    private final InvocationSuccessFunction<ClearCommand> broadcastClearIfNotLocal = this::broadcastClearIfNotLocal;
    private final InvocationSuccessFunction<PrepareCommand> broadcastInvalidateForPrepare = this::broadcastInvalidateForPrepare;
    private final InvocationSuccessFunction<CommitCommand> handleCommit = this::handleCommit;

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        if (!this.isPutForExternalRead((FlagAffectedCommand)command)) {
            return this.handleInvalidate(ctx, (WriteCommand)command, command.getKey());
        }
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        return this.handleInvalidate(ctx, (WriteCommand)command, command.getKey());
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        return this.handleInvalidate(ctx, (WriteCommand)command, command.getKey());
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        return this.invokeNextThenApply(ctx, (VisitableCommand)command, this.broadcastClearIfNotLocal);
    }

    private Object broadcastClearIfNotLocal(InvocationContext rCtx, ClearCommand rCommand, Object rv) {
        if (!this.isLocalModeForced((FlagAffectedCommand)rCommand) && rCtx.isOriginLocal()) {
            rCommand.setTopologyId(this.rpcManager.getTopologyId());
            if (this.isSynchronous((FlagAffectedCommand)rCommand)) {
                return TxInvalidationInterceptor.asyncValue((CompletionStage)this.rpcManager.invokeCommandOnAll((CacheRpcCommand)rCommand, (ResponseCollector)VoidResponseCollector.ignoreLeavers(), this.syncRpcOptions));
            }
            this.rpcManager.sendToAll((CacheRpcCommand)rCommand, DeliverOrder.NONE);
        }
        return rv;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        return this.handleInvalidate(ctx, (WriteCommand)command, command.getMap().keySet().toArray());
    }

    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
        return this.invokeNextThenApply((InvocationContext)ctx, (VisitableCommand)command, this.broadcastInvalidateForPrepare);
    }

    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.shouldInvokeRemoteTxCommand(ctx)) {
            return this.invokeNext((InvocationContext)ctx, (VisitableCommand)command);
        }
        return this.invokeNextThenApply((InvocationContext)ctx, (VisitableCommand)command, this.handleCommit);
    }

    private Object handleCommit(InvocationContext ctx, CommitCommand command, Object ignored) {
        CompletionStage remoteInvocation = this.rpcManager.invokeCommandOnAll((CacheRpcCommand)command, (ResponseCollector)VoidResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
        return TxInvalidationInterceptor.asyncValue((CompletionStage)remoteInvocation);
    }

    private Object broadcastInvalidateForPrepare(InvocationContext rCtx, PrepareCommand prepareCmd, Object rv) throws Throwable {
        log.tracef("Entering InvalidationInterceptor's prepare phase", new Object[0]);
        TxInvocationContext txCtx = (TxInvocationContext)rCtx;
        if (this.shouldInvokeRemoteTxCommand(txCtx)) {
            if (txCtx.getTransaction() == null) {
                throw new IllegalStateException("We must have an associated transaction");
            }
            CompletionStage<Void> completion = this.broadcastInvalidateForPrepare(prepareCmd, (InvocationContext)txCtx);
            if (completion != null) {
                return TxInvalidationInterceptor.asyncValue(completion);
            }
            return rv;
        }
        log.tracef("Nothing to invalidate - no modifications in the transaction.", new Object[0]);
        return rv;
    }

    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) {
        Object retVal = this.invokeNext((InvocationContext)ctx, (VisitableCommand)command);
        if (ctx.isOriginLocal()) {
            boolean sync = !command.isUnlock();
            List<Address> members = this.getMembers();
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(members);
            command.setTopologyId(this.rpcManager.getTopologyId());
            if (sync) {
                return TxInvalidationInterceptor.asyncValue((CompletionStage)this.rpcManager.invokeCommandOnAll((CacheRpcCommand)command, (ResponseCollector)VoidResponseCollector.ignoreLeavers(), this.syncRpcOptions));
            }
            this.rpcManager.sendToAll((CacheRpcCommand)command, DeliverOrder.NONE);
        }
        return retVal;
    }

    private Object handleInvalidate(InvocationContext ctx, WriteCommand command, Object ... keys) {
        return this.invokeNextThenApply(ctx, (VisitableCommand)command, (rCtx, writeCmd, rv) -> {
            if (!writeCmd.isSuccessful() || rCtx.isInTxScope()) {
                return rv;
            }
            if (keys == null || keys.length == 0) {
                return rv;
            }
            if (this.isLocalModeForced((FlagAffectedCommand)writeCmd)) {
                return rv;
            }
            CompletionStage<Void> completion = this.invalidateAcrossCluster(this.isSynchronous((FlagAffectedCommand)writeCmd), keys, rCtx, true, this.rpcManager.getTopologyId());
            return completion != null ? TxInvalidationInterceptor.asyncValue(completion) : rv;
        });
    }

    private CompletionStage<Void> broadcastInvalidateForPrepare(PrepareCommand prepareCmd, InvocationContext ctx) throws Throwable {
        if (ctx.isInTxScope()) {
            List modifications = prepareCmd.getModifications();
            if (modifications.isEmpty()) {
                return null;
            }
            InvalidationFilterVisitor filterVisitor = new InvalidationFilterVisitor(modifications.size());
            filterVisitor.visitCollection(null, modifications);
            if (filterVisitor.containsPutForExternalRead) {
                log.trace("Modification list contains a putForExternalRead operation.  Not invalidating.");
            } else if (filterVisitor.containsLocalModeFlag) {
                log.trace("Modification list contains a local mode flagged operation.  Not invalidating.");
            } else {
                try {
                    CompletionStage<Void> completion = this.invalidateAcrossCluster(this.defaultSynchronous, filterVisitor.result.toArray(), ctx, prepareCmd.isOnePhaseCommit(), prepareCmd.getTopologyId());
                    if (completion != null) {
                        return completion.exceptionally(t -> {
                            log.unableToRollbackInvalidationsDuringPrepare((Throwable)t);
                            throw CompletableFutures.asCompletionException((Throwable)t);
                        });
                    }
                }
                catch (Throwable t2) {
                    log.unableToRollbackInvalidationsDuringPrepare(t2);
                    throw t2;
                }
            }
        }
        return null;
    }

    protected Log getLog() {
        return ispnLog;
    }

    private CompletionStage<Void> invalidateAcrossCluster(boolean synchronous, Object[] keys, InvocationContext ctx, boolean onePhaseCommit, int topologyId) {
        InvalidateCommand invalidateCommand;
        this.incrementInvalidations();
        InvalidateCommand command = invalidateCommand = this.commandsFactory.buildInvalidateCommand(0L, keys);
        if (ctx.isInTxScope()) {
            TxInvocationContext txCtx = (TxInvocationContext)ctx;
            command = this.commandsFactory.buildPrepareCommand(txCtx.getGlobalTransaction(), Collections.singletonList(invalidateCommand), onePhaseCommit);
        }
        ((TopologyAffectedCommand)command).setTopologyId(topologyId);
        if (synchronous) {
            return this.rpcManager.invokeCommandOnAll((CacheRpcCommand)command, (ResponseCollector)VoidResponseCollector.ignoreLeavers(), this.syncRpcOptions);
        }
        this.rpcManager.sendToAll((CacheRpcCommand)command, DeliverOrder.NONE);
        return null;
    }

    public static class InvalidationFilterVisitor
    extends AbstractVisitor {
        Set<Object> result;
        public boolean containsPutForExternalRead = false;
        public boolean containsLocalModeFlag = false;

        public InvalidationFilterVisitor(int maxSetSize) {
            this.result = new HashSet<Object>(maxSetSize);
        }

        private void processCommand(FlagAffectedCommand command) {
            this.containsLocalModeFlag = this.containsLocalModeFlag || command.getFlags() != null && command.getFlags().contains(Flag.CACHE_MODE_LOCAL);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
            this.processCommand((FlagAffectedCommand)command);
            this.containsPutForExternalRead = this.containsPutForExternalRead || command.getFlags() != null && command.getFlags().contains(Flag.PUT_FOR_EXTERNAL_READ);
            this.result.add(command.getKey());
            return null;
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
            this.processCommand((FlagAffectedCommand)command);
            this.result.add(command.getKey());
            return null;
        }

        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
            this.processCommand((FlagAffectedCommand)command);
            this.result.addAll(command.getAffectedKeys());
            return null;
        }
    }
}

