/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.util.Arrays;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.marshall.protostream.impl.MarshallableArray;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=7703)
public class EndInvalidationCommand
extends BaseRpcCommand {
    private Object[] keys;
    private Object lockOwner;

    public EndInvalidationCommand(ByteString cacheName, Object[] keys, Object lockOwner) {
        super(cacheName);
        this.keys = keys;
        this.lockOwner = lockOwner;
    }

    @ProtoFactory
    EndInvalidationCommand(ByteString cacheName, MarshallableArray<Object> keys, MarshallableObject<Object> lockOwner) {
        this(cacheName, MarshallableArray.unwrap(keys), MarshallableObject.unwrap(lockOwner));
    }

    @ProtoField(value=2)
    MarshallableArray<Object> getKeys() {
        return MarshallableArray.create((Object[])this.keys);
    }

    @ProtoField(value=3)
    MarshallableObject<Object> getLockOwner() {
        return MarshallableObject.create((Object)this.lockOwner);
    }

    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) {
        for (Object key : this.keys) {
            PutFromLoadValidator putFromLoadValidator = (PutFromLoadValidator)componentRegistry.getComponent(PutFromLoadValidator.class);
            putFromLoadValidator.endInvalidatingKey(this.lockOwner, key);
        }
        return CompletableFutures.completedNull();
    }

    public boolean isReturnValueExpected() {
        return false;
    }

    public boolean canBlock() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndInvalidationCommand)) {
            return false;
        }
        EndInvalidationCommand that = (EndInvalidationCommand)((Object)o);
        if (this.cacheName == null ? this.cacheName != null : !this.cacheName.equals((Object)that.cacheName)) {
            return false;
        }
        if (!Arrays.equals(this.keys, that.keys)) {
            return false;
        }
        return !(this.lockOwner == null ? that.lockOwner != null : !this.lockOwner.equals(that.lockOwner));
    }

    public int hashCode() {
        int result = this.cacheName != null ? this.cacheName.hashCode() : 0;
        result = 31 * result + (this.keys != null ? Arrays.hashCode(this.keys) : 0);
        result = 31 * result + (this.lockOwner != null ? this.lockOwner.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EndInvalidationCommand{");
        sb.append("cacheName=").append(this.cacheName);
        sb.append(", keys=").append(Arrays.toString(this.keys));
        sb.append(", sessionTransactionId=").append(this.lockOwner);
        sb.append('}');
        return sb.toString();
    }
}

