/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.component.processor;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner8;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.infinispan.component.processor.AnnotationTypeValuesExtractor;
import org.infinispan.component.processor.Generator;
import org.infinispan.component.processor.Model;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.PostStart;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.jmx.annotations.Units;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"org.infinispan.factories.annotations.InfinispanModule", "org.infinispan.factories.annotations.DefaultFactoryFor", "org.infinispan.factories.annotations.SurvivesRestarts", "org.infinispan.factories.scopes.Scope", "org.infinispan.jmx.annotations.MBean", "org.infinispan.factories.annotations.Inject", "org.infinispan.factories.annotations.PostStart", "org.infinispan.factories.annotations.Start", "org.infinispan.factories.annotations.Stop", "org.infinispan.jmx.annotations.ManagedAttribute", "org.infinispan.jmx.annotations.ManagedOperation", "org.infinispan.jmx.annotations.Parameter"})
public class ComponentAnnotationProcessor
extends AbstractProcessor {
    static final String INFINISPAN_MODULE = "org.infinispan.factories.annotations.InfinispanModule";
    static final String DEFAULT_FACTORY_FOR = "org.infinispan.factories.annotations.DefaultFactoryFor";
    static final String SURVIVES_RESTARTS = "org.infinispan.factories.annotations.SurvivesRestarts";
    static final String SCOPE = "org.infinispan.factories.scopes.Scope";
    static final String MBEAN = "org.infinispan.jmx.annotations.MBean";
    static final String INJECT = "org.infinispan.factories.annotations.Inject";
    static final String POST_START = "org.infinispan.factories.annotations.PostStart";
    static final String START = "org.infinispan.factories.annotations.Start";
    static final String STOP = "org.infinispan.factories.annotations.Stop";
    static final String MANAGED_ATTRIBUTE = "org.infinispan.jmx.annotations.ManagedAttribute";
    static final String MANAGED_OPERATION = "org.infinispan.jmx.annotations.ManagedOperation";
    static final String MANAGED_OPERATION_PARAMETER = "org.infinispan.jmx.annotations.Parameter";
    private static final String FACTORY_CLASSES = "classes";
    private static final String COMPONENT_REF_CLASS = "org.infinispan.factories.impl.ComponentRef";
    private static final String AUTO_INSTANTIABLE_FACTORY_CLASS = "org.infinispan.factories.AutoInstantiableFactory";
    private static final Pattern MODULE_NAME_PATTERN = Pattern.compile("[a-zA-Z][-a-zA-Z0-9]*");
    private static final Pattern MODULE_NAME_SEPARATOR_PATTERN = Pattern.compile("-");
    private boolean errorReported = false;
    private ModelBuilder modelBuilder;
    private TypeMirror autoInstantiableType;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.modelBuilder = new ModelBuilder();
        try {
            this.parseGeneratedSources(this.modelBuilder);
        }
        catch (Throwable t) {
            this.uncaughtException(t);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            TypeElement autoInstantiableElement = this.elements().getTypeElement(AUTO_INSTANTIABLE_FACTORY_CLASS);
            if (autoInstantiableElement == null) {
                this.error(null, "Could not find type %s in the classpath, please rebuild", AUTO_INSTANTIABLE_FACTORY_CLASS);
                return false;
            }
            this.autoInstantiableType = autoInstantiableElement.asType();
            this.modelBuilder.scan(roundEnv.getRootElements(), null);
            if (roundEnv.processingOver()) {
                Model model = this.modelBuilder.getModel();
                if (this.modelBuilder.module == null) {
                    this.error(null, "@InfinispanModule annotation not found in any class, please perform a clean build. Found components %s", this.modelBuilder.annotatedTypes.keySet());
                    return true;
                }
                if (this.errorReported || roundEnv.errorRaised()) {
                    return true;
                }
                Generator generator = new Generator(model, this.filer());
                generator.writePackageClasses();
                TypeElement[] moduleSourceTypes = (TypeElement[])Stream.concat(model.annotatedTypes.values().stream().map(t -> t.typeElement), model.parsedTypes.values().stream().map(t -> t.typeElement)).toArray(TypeElement[]::new);
                generator.writeModuleClass(moduleSourceTypes);
                generator.writeServiceFile(moduleSourceTypes);
            }
        }
        catch (Throwable t2) {
            this.uncaughtException(t2);
        }
        return true;
    }

    private void parseGeneratedSources(ModelBuilder modelBuilder) throws IOException {
        InfinispanModule moduleAnnotation;
        modelBuilder.parsedTypes = Collections.emptyMap();
        String moduleImplementationName = Generator.readServiceFile(this.filer());
        if (moduleImplementationName == null) {
            return;
        }
        Map.Entry<String, Set<String>> moduleClassAndPackages = Generator.readModuleClass(this.filer(), moduleImplementationName);
        if (moduleClassAndPackages == null) {
            this.info(null, "Ignoring removed or renamed module implementation %s", moduleImplementationName);
            return;
        }
        TypeElement moduleClassElement = this.elements().getTypeElement(moduleClassAndPackages.getKey());
        InfinispanModule infinispanModule = moduleAnnotation = moduleClassElement != null ? this.getAnnotation(moduleClassElement, InfinispanModule.class) : null;
        if (moduleAnnotation == null) {
            this.error(null, "Ignoring invalid module implementation %s", moduleImplementationName);
            return;
        }
        String classPrefix = this.moduleToClassPrefix(moduleAnnotation.name());
        Set<String> packages = moduleClassAndPackages.getValue();
        HashMap<String, Model.ParsedType> parsedTypes = new HashMap<String, Model.ParsedType>();
        for (String packageName : packages) {
            Map<String, List<String>> packageSources = Generator.readPackageClass(this.filer(), packageName, classPrefix);
            if (packageSources == null) {
                this.info(null, "Ignoring removed or renamed package implementation %s", packageName);
                continue;
            }
            packageSources.forEach((qualifiedName, code) -> {
                TypeElement sourceType = this.elements().getTypeElement((CharSequence)qualifiedName);
                if (sourceType == null) {
                    this.info(null, "Ignoring removed component class %s", qualifiedName);
                } else {
                    parsedTypes.put((String)qualifiedName, new Model.ParsedType(sourceType, (String)qualifiedName, packageName, (List<String>)code));
                }
            });
        }
        modelBuilder.parsedTypes = parsedTypes;
        modelBuilder.setModuleClass(moduleClassElement, moduleAnnotation, classPrefix);
    }

    private <A extends Annotation> A getAnnotation(AnnotatedConstruct moduleClassElement, Class<A> annotationType) {
        try {
            return moduleClassElement.getAnnotation(annotationType);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private static String extractAttributeName(String setterOrGetter) {
        String name = null;
        if (setterOrGetter.startsWith("set") || setterOrGetter.startsWith("get")) {
            name = setterOrGetter.substring(3);
        } else if (setterOrGetter.startsWith("is")) {
            name = setterOrGetter.substring(2);
        }
        if (name != null && name.length() > 1) {
            return Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return null;
    }

    private void uncaughtException(Throwable t) {
        String stackTrace = Stream.of(t.getStackTrace()).map(Object::toString).collect(Collectors.joining("\n\tat ", "\tat ", ""));
        this.error(null, "ComponentAnnotationProcessor unexpected error: %s\n%s", t, stackTrace);
    }

    private void error(Element e, String format, Object ... params) {
        this.log(Diagnostic.Kind.ERROR, e, format, params);
        this.errorReported = true;
    }

    private void warn(Element e, String format, Object ... params) {
        this.log(Diagnostic.Kind.WARNING, e, format, params);
    }

    private void info(Element e, String format, Object ... params) {
        this.log(Diagnostic.Kind.NOTE, e, format, params);
    }

    private void log(Diagnostic.Kind level, Element e, String format, Object ... params) {
        String formatted = String.format(format, params);
        if (e != null) {
            this.processingEnv.getMessager().printMessage(level, formatted, e);
        } else {
            this.processingEnv.getMessager().printMessage(level, formatted);
        }
    }

    private Elements elements() {
        return this.processingEnv.getElementUtils();
    }

    private Types types() {
        return this.processingEnv.getTypeUtils();
    }

    private Filer filer() {
        return this.processingEnv.getFiler();
    }

    private String moduleToClassPrefix(CharSequence moduleName) {
        StringBuilder classPrefix = new StringBuilder();
        for (String element : MODULE_NAME_SEPARATOR_PATTERN.split(moduleName)) {
            classPrefix.append(Character.toUpperCase(element.charAt(0))).append(element.subSequence(1, element.length()));
        }
        return classPrefix.toString();
    }

    private class ModelBuilder
    extends ElementScanner8<Void, Void> {
        private Model.Module module;
        Map<String, Model.ParsedType> parsedTypes;
        private final Map<String, Model.AnnotatedType> annotatedTypes = new HashMap<String, Model.AnnotatedType>();
        private Model.AnnotatedType currentType;

        private ModelBuilder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitType(TypeElement e, Void ignored) {
            boolean survivesRestarts;
            Model.AnnotatedType savedType = this.currentType;
            String qualifiedName = e.getQualifiedName().toString();
            InfinispanModule moduleAnnotation = (InfinispanModule)ComponentAnnotationProcessor.this.getAnnotation(e, InfinispanModule.class);
            if (moduleAnnotation != null) {
                String classPrefix = ComponentAnnotationProcessor.this.moduleToClassPrefix(moduleAnnotation.name());
                this.setModuleClass(e, moduleAnnotation, classPrefix);
            }
            Scope scope = (Scope)ComponentAnnotationProcessor.this.getAnnotation(e, Scope.class);
            MBean mbean = (MBean)ComponentAnnotationProcessor.this.getAnnotation(e, MBean.class);
            boolean bl = survivesRestarts = ComponentAnnotationProcessor.this.getAnnotation(e, SurvivesRestarts.class) != null;
            if (!survivesRestarts) {
                this.requireAnnotationOnSubType(e, SurvivesRestarts.class);
            }
            if (scope != null || mbean != null) {
                String binaryName = this.binaryName(e);
                String packageName = ComponentAnnotationProcessor.this.elements().getPackageOf(e).getQualifiedName().toString();
                Model.AnnotatedType annotatedType = new Model.AnnotatedType(e, qualifiedName, binaryName, packageName);
                this.annotatedTypes.put(qualifiedName, annotatedType);
                this.currentType = annotatedType;
                if (scope != null) {
                    this.validatePackagePrivate(e, Scope.class);
                    this.requireSameScope(e, scope);
                    List<String> factoryComponentNames = this.getFactoryComponentNames(e);
                    boolean autoInstantiable = ComponentAnnotationProcessor.this.types().isAssignable(e.asType(), ComponentAnnotationProcessor.this.autoInstantiableType);
                    String superBinaryName = this.binaryName(this.getSuperClass(e, Scope.class));
                    annotatedType.component = new Model.Component(scope, survivesRestarts, factoryComponentNames, autoInstantiable, superBinaryName);
                } else {
                    this.requireAnnotationOnSubType(e, Scope.class);
                }
                if (mbean != null) {
                    String superMComponent = this.binaryName(this.getSuperClass(e, MBean.class));
                    annotatedType.mComponent = new Model.MComponent(mbean, superMComponent);
                } else {
                    this.requireAnnotationOnSubType(e, MBean.class);
                }
            }
            this.parsedTypes.remove(qualifiedName);
            try {
                Void void_ = (Void)super.visitType(e, ignored);
                return void_;
            }
            finally {
                this.currentType = savedType;
            }
        }

        private void setModuleClass(TypeElement e, InfinispanModule moduleAnnotation, String classPrefix) {
            this.validateModule(e, moduleAnnotation);
            String modulePackageName = ComponentAnnotationProcessor.this.elements().getPackageOf(e).getQualifiedName().toString();
            this.module = new Model.Module(moduleAnnotation, e.getQualifiedName().toString(), modulePackageName, classPrefix);
        }

        private void validateModule(TypeElement e, InfinispanModule moduleAnnotation) {
            String moduleName = moduleAnnotation.name();
            if (!MODULE_NAME_PATTERN.matcher(moduleName).matches()) {
                ComponentAnnotationProcessor.this.error(e, "@InfinispanModule name attribute must include only letters, digits or `-`", new Object[0]);
            }
            Name moduleClassName = e.getQualifiedName();
            if (this.module != null && !moduleClassName.contentEquals(this.module.moduleClassName)) {
                ComponentAnnotationProcessor.this.error(e, "@InfinispanModule allowed on a single class, already present on %s", new Object[]{this.module.moduleClassName});
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Void visitExecutable(ExecutableElement e, Void ignored) {
            String methodName = e.getSimpleName().toString();
            if (ComponentAnnotationProcessor.this.getAnnotation(e, Inject.class) != null) {
                this.validatePackagePrivate(e, Scope.class);
                if (this.isValidComponent(e, Inject.class)) {
                    List<Model.InjectField> parameters = e.getParameters().stream().map(this::makeInjectField).collect(Collectors.toList());
                    this.currentType.component.injectMethods.add(new Model.InjectMethod(methodName, parameters));
                }
            }
            this.addLifecycleMethod(e, Start.class, c -> c.startMethods, Start::priority);
            this.addLifecycleMethod(e, PostStart.class, c -> c.postStartMethods, PostStart::priority);
            this.addLifecycleMethod(e, Stop.class, c -> c.stopMethods, Stop::priority);
            if (ComponentAnnotationProcessor.this.getAnnotation(e, PostStart.class) != null) {
                ComponentAnnotationProcessor.this.warn(e, "The @PostStart annotation is deprecated and will be ignored in the future", new Object[0]);
            }
            if (ComponentAnnotationProcessor.this.getAnnotation(e, ManagedAttribute.class) != null && this.isValidMComponent(e, ManagedAttribute.class)) {
                void var7_12;
                String boxedType;
                TypeMirror t;
                String name;
                ManagedAttribute attribute = (ManagedAttribute)ComponentAnnotationProcessor.this.getAnnotation(e, ManagedAttribute.class);
                String string = name = attribute != null ? attribute.name() : "";
                if (name.isEmpty()) {
                    name = ComponentAnnotationProcessor.extractAttributeName(methodName);
                }
                boolean is = methodName.startsWith("is");
                if (methodName.startsWith("set")) {
                    t = e.getParameters().get(0).asType();
                    String string2 = ComponentAnnotationProcessor.this.types().erasure(t).toString();
                    boxedType = t.getKind().isPrimitive() ? ComponentAnnotationProcessor.this.types().boxedClass((PrimitiveType)t).toString() : string2;
                } else if (methodName.startsWith("get") || is) {
                    t = e.getReturnType();
                    String string3 = ComponentAnnotationProcessor.this.types().erasure(t).toString();
                    boxedType = t.getKind().isPrimitive() ? ComponentAnnotationProcessor.this.types().boxedClass((PrimitiveType)t).toString() : string3;
                } else {
                    ComponentAnnotationProcessor.this.error(e, "Method annotated with @ManagedAttribute does not start with `set`, `get`, or `is`", new Object[0]);
                    boxedType = "";
                    String string4 = "";
                }
                this.validateUnits(e, attribute);
                this.currentType.mComponent.attributes.add(new Model.MAttribute(name, methodName, attribute, true, (String)var7_12, boxedType, is));
            }
            if (ComponentAnnotationProcessor.this.getAnnotation(e, ManagedOperation.class) != null && this.isValidMComponent(e, ManagedOperation.class)) {
                ManagedOperation operation = (ManagedOperation)ComponentAnnotationProcessor.this.getAnnotation(e, ManagedOperation.class);
                ArrayList<Model.MParameter> parameters = new ArrayList<Model.MParameter>();
                for (VariableElement variableElement : e.getParameters()) {
                    Parameter parameterAnnotation = (Parameter)ComponentAnnotationProcessor.this.getAnnotation(variableElement, Parameter.class);
                    String name = parameterAnnotation != null && !parameterAnnotation.name().isEmpty() ? parameterAnnotation.name() : variableElement.getSimpleName().toString();
                    String type = ComponentAnnotationProcessor.this.types().erasure(variableElement.asType()).toString();
                    String description = parameterAnnotation != null ? parameterAnnotation.description() : null;
                    parameters.add(new Model.MParameter(name, type, description));
                }
                this.currentType.mComponent.operations.add(new Model.MOperation(methodName, operation, ComponentAnnotationProcessor.this.types().erasure(e.getReturnType()).toString(), parameters));
            }
            return (Void)super.visitExecutable(e, ignored);
        }

        private void validateUnits(Element e, ManagedAttribute attribute) {
            if (attribute.dataType() == DataType.TIMER && !Units.TIME_UNITS.contains(attribute.units())) {
                ComponentAnnotationProcessor.this.error(e, "@ManagedAttribute.units is expected to be a time unit since `dataType` is DataType.TIMER", new Object[0]);
            }
        }

        private <A extends Annotation> void addLifecycleMethod(ExecutableElement e, Class<A> annotationType, Function<Model.Component, List<Model.LifecycleMethod>> methodsExtractor, Function<A, Integer> priorityExtractor) {
            Annotation annotation = ComponentAnnotationProcessor.this.getAnnotation(e, annotationType);
            if (annotation == null) {
                return;
            }
            this.validateLifecycleMethod(e, annotationType);
            if (this.isValidComponent(e, annotationType)) {
                List<Model.LifecycleMethod> methodList = methodsExtractor.apply(this.currentType.component);
                Integer priority = priorityExtractor.apply(annotation);
                methodList.add(new Model.LifecycleMethod(e.getSimpleName().toString(), priority));
            }
        }

        private <A extends Annotation> void validateLifecycleMethod(ExecutableElement method, Class<A> annotationType) {
            this.validatePackagePrivate(method, annotationType);
            if (!method.getParameters().isEmpty()) {
                ComponentAnnotationProcessor.this.error(method, "Methods annotated @%s must have no parameters", new Object[]{annotationType.getSimpleName()});
            }
            if (this.existsInSuper(method, annotationType)) {
                ComponentAnnotationProcessor.this.error(method, "Inherited lifecycle methods should not be annotated with @%s", new Object[]{annotationType.getSimpleName()});
            }
        }

        private <A extends Annotation> boolean existsInSuper(ExecutableElement method, Class<A> annotationType) {
            TypeElement superAccessorType = this.getSuperClass(this.currentType.typeElement, Scope.class);
            while (superAccessorType != null) {
                for (Element element : superAccessorType.getEnclosedElements()) {
                    if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(method.getSimpleName()) || ComponentAnnotationProcessor.this.getAnnotation(element, annotationType) == null) continue;
                    return true;
                }
                superAccessorType = this.getSuperClass(superAccessorType, Scope.class);
            }
            return false;
        }

        @Override
        public Void visitVariable(VariableElement e, Void ignored) {
            ManagedAttribute attribute;
            if (ComponentAnnotationProcessor.this.getAnnotation(e, Inject.class) != null) {
                this.validatePackagePrivate(e, Scope.class);
                if (this.isValidComponent(e, Inject.class)) {
                    this.currentType.component.injectFields.add(this.makeInjectField(e));
                }
            }
            if ((attribute = (ManagedAttribute)ComponentAnnotationProcessor.this.getAnnotation(e, ManagedAttribute.class)) != null && this.isValidMComponent(e, ManagedAttribute.class)) {
                String name = e.getSimpleName().toString();
                TypeMirror t = e.asType();
                String type = ComponentAnnotationProcessor.this.types().erasure(t).toString();
                String boxedType = t.getKind().isPrimitive() ? ComponentAnnotationProcessor.this.types().boxedClass((PrimitiveType)t).toString() : type;
                this.validateUnits(e, attribute);
                this.currentType.mComponent.attributes.add(new Model.MAttribute(name, name, attribute, false, type, boxedType, false));
            }
            return (Void)super.visitVariable(e, ignored);
        }

        private Model.InjectField makeInjectField(VariableElement e) {
            String fieldName = e.getSimpleName().toString();
            TypeMirror componentType = this.getInjectedType(e);
            String binaryName = this.binaryName(componentType);
            String componentName = this.getComponentName(e, binaryName);
            String qualifiedTypeName = componentType.toString();
            boolean isComponentRef = this.isComponentRef(e);
            return new Model.InjectField(fieldName, qualifiedTypeName, componentName, isComponentRef);
        }

        private void requireSameScope(TypeElement e, Scope scope) {
            for (TypeMirror typeMirror : ComponentAnnotationProcessor.this.types().directSupertypes(e.asType())) {
                Element superTypeElement = ((DeclaredType)typeMirror).asElement();
                Scope superScope = (Scope)ComponentAnnotationProcessor.this.getAnnotation(superTypeElement, Scope.class);
                if (superScope == null || superScope.value() == Scopes.NONE || scope.value() == superScope.value()) continue;
                ComponentAnnotationProcessor.this.error(e, "Scope declared on class %s (%s) does not match scope inherited from %s (%s)", new Object[]{e.getSimpleName(), scope.value(), superTypeElement.getSimpleName(), superScope.value()});
            }
        }

        private boolean isValidComponent(Element methodOrField, Class<? extends Annotation> methodAnnotation) {
            boolean valid = true;
            if (this.currentType == null || this.currentType.component == null) {
                ComponentAnnotationProcessor.this.error(methodOrField, "When a method is annotated with @%s, the type must be annotated with @%s", new Object[]{methodAnnotation.getSimpleName(), Scope.class.getSimpleName()});
                valid = false;
            }
            if (!methodOrField.getEnclosingElement().getKind().isClass()) {
                ComponentAnnotationProcessor.this.error(methodOrField, "Interface methods must not be annotated with @%s", new Object[]{methodAnnotation.getSimpleName()});
                valid = false;
            }
            return valid;
        }

        private boolean isValidMComponent(Element methodOrField, Class<? extends Annotation> methodAnnotation) {
            boolean valid = true;
            if (this.currentType == null || this.currentType.mComponent == null) {
                ComponentAnnotationProcessor.this.error(methodOrField, "When a method is annotated with @%s, the class must be annotated with @%s", new Object[]{methodAnnotation.getSimpleName(), MBean.class.getSimpleName()});
                valid = false;
            }
            if (!methodOrField.getEnclosingElement().getKind().isClass()) {
                ComponentAnnotationProcessor.this.error(methodOrField, "Interface methods must not be annotated with @%s", new Object[]{methodAnnotation.getSimpleName()});
                valid = false;
            }
            return valid;
        }

        private void validatePackagePrivate(Element element, Class<? extends Annotation> annotationType) {
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                String kind = element.getKind().isField() ? "Fields" : (element.getKind() == ElementKind.METHOD ? "Methods" : "Types");
                ComponentAnnotationProcessor.this.error(element, "%s annotated with @%s must not be private", new Object[]{kind, annotationType});
            }
        }

        private void requireAnnotationOnSubType(TypeElement typeElement, Class<? extends Annotation> typeAnnotation) {
            for (TypeMirror typeMirror : ComponentAnnotationProcessor.this.types().directSupertypes(typeElement.asType())) {
                TypeElement superTypeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                if (ComponentAnnotationProcessor.this.getAnnotation(superTypeElement, typeAnnotation) == null) continue;
                ComponentAnnotationProcessor.this.error(typeElement, "Type %s must have annotation @%s because it extends/implements %s. Note that interface annotations are not inherited", new Object[]{typeElement.getSimpleName(), typeAnnotation.getSimpleName(), superTypeElement.getSimpleName()});
            }
        }

        public Model getModel() {
            Model.Package aPackage;
            HashMap<String, Model.Package> packages = new HashMap<String, Model.Package>();
            for (Model.AnnotatedType annotatedType : this.annotatedTypes.values()) {
                aPackage = packages.computeIfAbsent(annotatedType.packageName, Model.Package::new);
                aPackage.annotatedTypes.add(annotatedType);
                aPackage.typeElements.add(annotatedType.typeElement);
            }
            for (Model.ParsedType parsedType : this.parsedTypes.values()) {
                aPackage = packages.computeIfAbsent(parsedType.packageName, Model.Package::new);
                aPackage.parsedTypes.add(parsedType);
                aPackage.typeElements.add(parsedType.typeElement);
            }
            return new Model(this.module, this.annotatedTypes, this.parsedTypes, packages);
        }

        private List<String> getFactoryComponentNames(TypeElement typeElement) {
            DefaultFactoryFor factoryAnnotation = (DefaultFactoryFor)ComponentAnnotationProcessor.this.getAnnotation(typeElement, DefaultFactoryFor.class);
            ArrayList<String> componentNames = new ArrayList<String>();
            if (factoryAnnotation != null) {
                TypeElement defaultFactoryForType = ComponentAnnotationProcessor.this.elements().getTypeElement(DefaultFactoryFor.class.getName());
                List<TypeMirror> producedTypes = AnnotationTypeValuesExtractor.getTypeValues(typeElement, defaultFactoryForType, ComponentAnnotationProcessor.FACTORY_CLASSES);
                for (TypeMirror type : producedTypes) {
                    componentNames.add(this.binaryName(type));
                }
                Collections.addAll(componentNames, factoryAnnotation.names());
            }
            return componentNames;
        }

        private String binaryName(TypeElement typeElement) {
            if (typeElement == null) {
                return null;
            }
            return ComponentAnnotationProcessor.this.elements().getBinaryName(typeElement).toString();
        }

        private TypeMirror getInjectedType(VariableElement injectFieldOrParameter) {
            DeclaredType declaredType = (DeclaredType)injectFieldOrParameter.asType();
            TypeMirror componentType = ComponentAnnotationProcessor.this.types().erasure(declaredType);
            if (componentType.toString().equals(ComponentAnnotationProcessor.COMPONENT_REF_CLASS)) {
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                componentType = ComponentAnnotationProcessor.this.types().erasure(typeArguments.get(0));
            }
            return componentType;
        }

        private String getComponentName(VariableElement parameter, String componentTypeName) {
            ComponentName nameAnnotation = (ComponentName)ComponentAnnotationProcessor.this.getAnnotation(parameter, ComponentName.class);
            return nameAnnotation != null ? nameAnnotation.value() : componentTypeName;
        }

        private boolean isComponentRef(VariableElement injectFieldOrParameter) {
            String erasedType = ComponentAnnotationProcessor.this.types().erasure(injectFieldOrParameter.asType()).toString();
            return ComponentAnnotationProcessor.COMPONENT_REF_CLASS.equals(erasedType);
        }

        private String binaryName(TypeMirror type) {
            return this.binaryName((TypeElement)ComponentAnnotationProcessor.this.types().asElement(type));
        }

        private TypeElement getSuperClass(TypeElement typeElement, Class<? extends Annotation> annotationClass) {
            TypeElement superElement = (TypeElement)ComponentAnnotationProcessor.this.types().asElement(typeElement.getSuperclass());
            if (superElement == null || ComponentAnnotationProcessor.this.getAnnotation(superElement, annotationClass) != null) {
                return superElement;
            }
            return this.getSuperClass(superElement, annotationClass);
        }
    }
}

