/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.aesh.command.shell.Shell;
import org.aesh.readline.Prompt;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.tty.Size;
import org.infinispan.commons.util.Util;

public class StreamShell
implements Shell {
    private final BufferedReader in;
    private final PrintStream out;

    public StreamShell() {
        this(System.in, System.out);
    }

    public StreamShell(InputStream in, PrintStream out) {
        this.in = new BufferedReader(new InputStreamReader(in));
        this.out = out;
    }

    public void write(String msg, boolean paging) {
        this.out.print(msg);
    }

    public void writeln(String msg, boolean paging) {
        this.out.println(msg);
    }

    public void write(int[] cp) {
        this.out.print(Parser.fromCodePoints((int[])cp));
        this.out.flush();
    }

    public void write(char c) {
        this.out.print(c);
    }

    public String readLine() throws InterruptedException {
        try {
            String line = this.in.readLine();
            if (line == null) {
                Util.close((AutoCloseable)this.in);
            }
            return line;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String readLine(Prompt prompt) throws InterruptedException {
        return this.readLine();
    }

    public Key read() throws InterruptedException {
        try {
            int input = this.in.read();
            return Key.getKey((int[])new int[]{input});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Key read(long timeout, TimeUnit unit) throws InterruptedException {
        return this.read();
    }

    public Key read(Prompt prompt) throws InterruptedException {
        return this.read();
    }

    public boolean enableAlternateBuffer() {
        return false;
    }

    public boolean enableMainBuffer() {
        return false;
    }

    public Size size() {
        return new Size(0, 0);
    }

    public void clear() {
    }
}

