/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionGroup;
import org.aesh.io.Resource;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.TaskCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;

@GroupCommandDefinition(name="task", description="Executes or manipulates server-side tasks", activator=ConnectionActivator.class, groupCommands={Exec.class, Upload.class})
public class Task
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="upload", description="Uploads a new script task to the server", activator=ConnectionActivator.class)
    public static class Upload
    extends RestCliCommand {
        @Argument(description="The task name", required=true)
        String taskName;
        @Option(completer=FileOptionCompleter.class, shortName=102, required=true)
        Resource file;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            return client.tasks().uploadScript(this.taskName, RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (File)new File(this.file.getAbsolutePath())));
        }
    }

    @CommandDefinition(name="exec", description="Executes a server-side task", activator=ConnectionActivator.class)
    public static class Exec
    extends RestCliCommand {
        @Argument(completer=TaskCompleter.class, required=true)
        String taskName;
        @OptionGroup(shortName=80, description="Task parameters")
        Map<String, String> parameters;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            return client.tasks().exec(this.taskName, this.parameters == null ? Collections.emptyMap() : this.parameters);
        }
    }
}

