/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.troubleshoot;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.shell.Shell;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.completers.PersistentScopeCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.commons.time.DefaultTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.concurrent.FileSystemLock;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.globalstate.impl.GlobalStateHandler;

@CommandDefinition(name="persistent-state", description="Inspect the persistent state")
public class PersistentStateParse
extends CliCommand
implements PersistentScopeCompleter.PersistentScopeAwareCommand {
    @Option(name="show", completer=PersistentScopeCompleter.class, description="Show the persistent state of a single scope")
    String show;
    @Option(name="delete", completer=PersistentScopeCompleter.class, description="Delete the persistent state of a single scope")
    String delete;
    @Argument(completer=FileOptionCompleter.class, description="Path to the persistent state directory")
    String path;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    protected boolean isHelp() {
        return this.help || this.path == null;
    }

    @Override
    protected CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
        if (this.path == null) {
            return CommandResult.FAILURE;
        }
        Path p = Path.of(this.path, new String[0]);
        if (Files.notExists(p, new LinkOption[0]) || !Files.isDirectory(p, new LinkOption[0])) {
            invocation.getShellError().println("The path " + this.path + " does not exist or is not a directory");
            return CommandResult.FAILURE;
        }
        if (this.show != null) {
            this.showScope(invocation, this.show);
            return CommandResult.SUCCESS;
        }
        if (this.delete != null) {
            FileSystemLock lock = new FileSystemLock(p, "___global");
            try {
                if (!lock.tryLock() && !lock.isAcquired()) {
                    invocation.getShellError().printf("Global file lock is held by server at %s. Can not manipulate scoped data%n", this.path);
                    CommandResult commandResult = CommandResult.FAILURE;
                    return commandResult;
                }
                CommandResult commandResult = this.modifyScope(invocation);
                return commandResult;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (lock.isAcquired()) {
                    lock.unlock();
                }
            }
        }
        this.listAllScopes(invocation);
        return CommandResult.SUCCESS;
    }

    private CommandResult modifyScope(ContextAwareCommandInvocation invocation) {
        if (this.delete != null) {
            this.showScope(invocation, this.delete);
            this.deleteScope(invocation, this.delete);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public Collection<String> getPersistentScopes() {
        List<String> list;
        block8: {
            Stream<Path> paths = Files.walk(Path.of(this.path, new String[0]), new FileVisitOption[0]);
            try {
                list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".state")).map(p -> p.getFileName().toString().replace(".state", "")).filter(s -> !Objects.equals(s, "___global")).toList();
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            paths.close();
        }
        return list;
    }

    private void showScope(ContextAwareCommandInvocation invocation, String scope) {
        GlobalStateHandler handler = new GlobalStateHandler(this.path, (TimeService)DefaultTimeService.INSTANCE);
        Optional optional = handler.readScopedState(scope);
        if (optional.isEmpty()) {
            invocation.getShellError().println("The scope " + scope + " does not exist in " + this.path);
            return;
        }
        ScopedPersistentState state = (ScopedPersistentState)optional.get();
        invocation.getShell().writeln(String.format("Scope=%s; Checksum=%d", scope, state.getChecksum()));
        state.forEach((k, v) -> invocation.getShell().writeln(String.format("key=%s; value=%s", k, v)));
    }

    private void deleteScope(ContextAwareCommandInvocation invocation, String scope) {
        GlobalStateHandler handler = new GlobalStateHandler(this.path, (TimeService)DefaultTimeService.INSTANCE);
        handler.deleteScopedState(scope);
        invocation.getShellOutput().printf("Deleted scope %s in %s.%n", scope, this.path);
    }

    private void listAllScopes(ContextAwareCommandInvocation invocation) {
        invocation.getShellOutput().printf("List all states in: %s%n", this.path);
        this.getPersistentScopes().forEach(arg_0 -> ((Shell)invocation.getShell()).writeln(arg_0));
    }
}

