/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.KubernetesContext;

@GroupCommandDefinition(name="delete", description="Deletes resources.", groupCommands={Cluster.class})
public class Delete
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="cluster", description="Deletes a cluster")
    public static class Cluster
    extends CliCommand {
        @Option(shortName=110, description="Specifies the namespace of the cluster to delete. Uses the default namespace if you do not specify one.")
        String namespace;
        @Argument(description="Specifies the name of the cluster to delete. Defaults to 'infinispan'", defaultValue={"infinispan"})
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            KubernetesClient client = KubernetesContext.getClient(invocation);
            ((Resource)((NonNamespaceOperation)client.genericKubernetesResources((ResourceDefinitionContext)Kube.INFINISPAN_CLUSTER_CRD).inNamespace(Kube.getNamespaceOrDefault(client, this.namespace))).withName(this.name)).delete();
            return CommandResult.SUCCESS;
        }
    }
}

