/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionGroup;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.completers.EncryptionCompleter;
import org.infinispan.cli.completers.ExposeCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.KubernetesContext;
import org.infinispan.cli.logging.Messages;

@GroupCommandDefinition(name="create", description="Creates resources.", groupCommands={Cluster.class})
public class Create
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="cluster", description="Creates a cluster")
    public static class Cluster
    extends CliCommand {
        @Option(shortName=110, description="Specifies the namespace where the cluster is created. Uses the default namespace if you do not specify one.")
        String namespace;
        @Option(shortName=114, description="Specifies the number of replicas. Defaults to 1.", defaultValue={"1"})
        int replicas;
        @Option(shortName=118, description="Specifies the server version. If omitted, the latest available version will be used.")
        String version;
        @Option(name="expose-type", completer=ExposeCompleter.class, description="Makes the service available on the network through a LoadBalancer, NodePort, or Route.")
        String exposeType;
        @Option(name="expose-port", defaultValue={"0"}, description="Sets the network port where the service is available. You must set a port if the expose type is LoadBalancer or NodePort.")
        int exposePort;
        @Option(name="expose-host", description="Optionally sets the hostname if the expose type is Route.")
        String exposeHost;
        @Option(name="encryption-type", completer=EncryptionCompleter.class, description="The type of encryption: one of None, Secret, Service")
        String encryptionType;
        @Option(name="encryption-secret", description="The name of the secret containing the TLS certificate")
        String encryptionSecret;
        @Argument(description="Defines the cluster name. Defaults to 'infinispan'", defaultValue={"infinispan"})
        String name;
        @OptionGroup(shortName=80, description="Sets a spec property. Use the '.' as separator for child nodes")
        Map<String, String> specProperties;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            KubernetesClient client = KubernetesContext.getClient(invocation);
            this.namespace = Kube.getNamespaceOrDefault(client, this.namespace);
            GenericKubernetesResource infinispan = new GenericKubernetesResource();
            infinispan.setKind(Kube.INFINISPAN_CLUSTER_CRD.getKind());
            ObjectMeta metadata = new ObjectMeta();
            metadata.setName(this.name);
            metadata.setNamespace(this.namespace);
            infinispan.setMetadata(metadata);
            GenericKubernetesResource spec = new GenericKubernetesResource();
            infinispan.setAdditionalProperty("spec", (Object)spec);
            spec.setAdditionalProperty("replicas", (Object)this.replicas);
            if (this.version != null) {
                spec.setAdditionalProperty("version", (Object)this.version);
            }
            if (this.exposeType != null) {
                GenericKubernetesResource expose = new GenericKubernetesResource();
                spec.setAdditionalProperty("expose", (Object)expose);
                expose.setAdditionalProperty("type", (Object)this.exposeType);
                switch (ExposeCompleter.Expose.valueOf(this.exposeType)) {
                    case LoadBalancer: {
                        if (this.exposePort == 0) {
                            throw Messages.MSG.exposeTypeRequiresPort(this.exposeType);
                        }
                        expose.setAdditionalProperty("port", (Object)this.exposePort);
                        break;
                    }
                    case NodePort: {
                        if (this.exposePort == 0) {
                            throw Messages.MSG.exposeTypeRequiresPort(this.exposeType);
                        }
                        expose.setAdditionalProperty("nodePort", (Object)this.exposePort);
                    }
                }
                if (this.exposeHost != null) {
                    expose.setAdditionalProperty("host", (Object)this.exposeHost);
                }
            }
            if (this.encryptionType != null) {
                GenericKubernetesResource security = new GenericKubernetesResource();
                spec.setAdditionalProperty("security", (Object)security);
                GenericKubernetesResource encryption = new GenericKubernetesResource();
                security.setAdditionalProperty("endpointEncryption", (Object)encryption);
                encryption.setAdditionalProperty("type", (Object)this.encryptionType);
                if (EncryptionCompleter.Encryption.valueOf(this.encryptionType) == EncryptionCompleter.Encryption.Secret) {
                    if (this.encryptionSecret != null) {
                        encryption.setAdditionalProperty("certSecretName", (Object)this.encryptionSecret);
                    } else {
                        throw Messages.MSG.encryptionTypeRequiresSecret(this.encryptionType);
                    }
                }
            }
            if (this.specProperties != null) {
                this.specProperties.forEach((k, v) -> Kube.setProperty(spec, v, k.split("\\.")));
            }
            ((NonNamespaceOperation)client.genericKubernetesResources((ResourceDefinitionContext)Kube.INFINISPAN_CLUSTER_CRD).inNamespace(this.namespace)).create((Object)infinispan);
            return CommandResult.SUCCESS;
        }
    }
}

